/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDTC;
import com.ecmtuning.ecmlink.device.ecmlink.OBDReadyFlag;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC2GDSMRecord;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DTC2GRecordModel
extends RecordModel {
    ValueModel mdlEvapEGR;
    ValueModel mdlO2;
    ValueModel mdlMisfire;
    ValueModel mdlFuelTrim;
    ValueModel mdlAT;
    ValueModel mdlClosedLoop;
    ValueModel mdlIdle;
    ArrayListModel listMdlDTCs;
    ArrayListModel listMdlDTCDescs;
    ArrayListModel listMdlReadinessName;
    ArrayListModel listMdlReadinessState;
    final DTC2GDSMRecord dtcRecord;
    PropertyChangeListener dtcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DTC2GRecordModel.this.updateLists();
        }
    };
    static int[] SUPPORTED_TOOLS_RECORD_IDS = new int[]{5, 20};

    DTC2GRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
        this.listMdlDTCs = new ArrayListModel();
        this.listMdlDTCDescs = new ArrayListModel();
        this.listMdlReadinessName = new ArrayListModel();
        this.listMdlReadinessState = new ArrayListModel();
        Map map = recordSet.getPersistentRecordMap();
        this.dtcRecord = (DTC2GDSMRecord)RecordSet.getRecord(-2, map);
        WeakListeners.addValueChangeListener(this.dtcListener, this.dtcRecord.getField("DtcTable"));
        WeakListeners.addValueChangeListener(this.dtcListener, this.dtcRecord.getField("OBD2Readiness"));
    }

    public void updateLists() {
        Integer n;
        List list = this.dtcRecord.getDTCs();
        this.listMdlDTCs.clear();
        this.listMdlDTCDescs.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (n = (Integer)iterator.next()) != 0) {
            this.listMdlDTCs.add((Object)XFormatter.toHex4(n));
            this.listMdlDTCDescs.add((Object)ECMLinkDTC.get2GDTCDesc(n));
        }
        int n2 = this.dtcRecord.getReadinessValue();
        this.listMdlReadinessName.clear();
        this.listMdlReadinessState.clear();
        for (OBDReadyFlag oBDReadyFlag : ECMLinkDTC.obdReadyFlags2GDSM) {
            this.listMdlReadinessName.add((Object)oBDReadyFlag.getName());
            this.listMdlReadinessState.add((Object)oBDReadyFlag.getStateText(n2));
        }
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(5, map);
        if (baseRecord == null) {
            baseRecord = RecordSet.getRecord(20, map);
        }
        this.mdlEvapEGR = this.track(this.mdlEvapEGR, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 1));
        this.mdlO2 = this.track(this.mdlO2, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 2));
        this.mdlMisfire = this.track(this.mdlMisfire, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 4));
        this.mdlFuelTrim = this.track(this.mdlFuelTrim, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 8));
        this.mdlAT = this.track(this.mdlAT, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 16));
        this.mdlClosedLoop = this.track(this.mdlClosedLoop, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 32));
        this.mdlIdle = this.track(this.mdlIdle, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 64));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(-2, map) && RecordSet.containsAnyRecordId(SUPPORTED_TOOLS_RECORD_IDS, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return RecordSet.containsAnyRecordId(SUPPORTED_TOOLS_RECORD_IDS, map);
    }
}

