/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDTC;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ListBasedTableModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTC2GRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTC2GTab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.AbstractView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class DTC2GRecordView
extends AbstractView {
    private JCheckBox cbEvapEGR;
    private JCheckBox cbO2;
    private JCheckBox cbMisfire;
    private JCheckBox cbFuelTrim;
    private JCheckBox cbAT;
    private JCheckBox cbClosedLoop;
    private JCheckBox cbIdle;
    private JButton btnUpdateDTC;
    private JButton btnUpdateReadiness;
    private JButton btnClearDTC;
    HandyJTable tblDTC;
    HandyJTable tblReadiness;
    private final DTC2GRecordModel dtcModel;
    private final DTC2GTab parentDTCTab;

    public DTC2GRecordView(DTC2GRecordModel dTC2GRecordModel, DTC2GTab dTC2GTab) {
        this.dtcModel = dTC2GRecordModel;
        this.parentDTCTab = dTC2GTab;
    }

    private void initComponents() {
        this.cbEvapEGR = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlEvapEGR, (String)"Evap/EGR/MDP");
        this.cbEvapEGR.setToolTipText("If checked, will enable diagnostics for various emissions controls");
        this.cbO2 = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlO2, (String)"Cat efficiency/O2");
        this.cbO2.setToolTipText("If checked, will enable diagnostics related to front and rear O2 sensor operation");
        this.cbMisfire = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlMisfire, (String)"Cylinder misfire");
        this.cbMisfire.setToolTipText("If checked, will enable misfire detection");
        this.cbFuelTrim = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlFuelTrim, (String)"Fuel trim");
        this.cbFuelTrim.setToolTipText("If checked, will enable checks for fuel trim adjustment range");
        this.cbAT = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlAT, (String)"Automatic Transmission");
        this.cbAT.setToolTipText("If checked, will turn on the check engine light if the A/T computer indicates an error");
        this.cbClosedLoop = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlClosedLoop, (String)"Closed loop");
        this.cbClosedLoop.setToolTipText("If checked, will enable checks against time to enter closed loop");
        this.cbIdle = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlIdle, (String)"Idle control");
        this.cbIdle.setToolTipText("If checked, will enable diagnostics related to idle control");
        this.btnClearDTC = new JButton(this.parentDTCTab.clearDTCAction);
        this.btnUpdateDTC = new JButton(this.parentDTCTab.updateDTCAction);
        this.btnUpdateReadiness = new JButton(this.parentDTCTab.updateDTCAction);
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel();
        listBasedTableModel.setMinimumRowCount(3);
        listBasedTableModel.addColumn("DTC", (ListModel)this.dtcModel.listMdlDTCs);
        listBasedTableModel.addColumn("Description", (ListModel)this.dtcModel.listMdlDTCDescs);
        this.tblDTC = new HandyJTable();
        this.tblDTC.setAutoResizeMode(3);
        this.tblDTC.setUsePreferredSizeAsScrollSize(true);
        this.tblDTC.setModel(listBasedTableModel);
        this.tblDTC.setColumnWidthFromProto(0, "00000");
        this.tblDTC.setColumnWidthFromProto(1, ECMLinkDTC.getAllDTCDescs());
        this.tblDTC.setColumnAlignments(new int[]{4, 2});
        ListBasedTableModel listBasedTableModel2 = new ListBasedTableModel();
        listBasedTableModel2.addColumn("Name", (ListModel)this.dtcModel.listMdlReadinessName);
        listBasedTableModel2.addColumn("State", (ListModel)this.dtcModel.listMdlReadinessState);
        this.tblReadiness = new HandyJTable();
        this.tblReadiness.setAutoResizeMode(3);
        this.tblReadiness.setUsePreferredSizeAsScrollSize(true);
        this.tblReadiness.setModel(listBasedTableModel2);
        this.dtcModel.updateLists();
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Reported DTCs", cellConstraints.xyw(1, n, 3));
        panelBuilder.add((Component)this.buildDTCTblPanel(), cellConstraints.xy(2, n += 2));
        panelBuilder.addSeparator("Enabled DTC Checks", cellConstraints.xyw(1, n += 2, 3));
        panelBuilder.add((Component)this.buildDTCCheckPanel(), cellConstraints.xy(2, n += 2));
        panelBuilder.addSeparator("OBD II Readiness", cellConstraints.xyw(1, n += 2, 3));
        panelBuilder.add((Component)this.buildReadinessPanel(), cellConstraints.xy(2, n += 2));
        return panelBuilder.getPanel();
    }

    private JComponent buildDTCTblPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tblDTC));
        jPanel.add((Component)jScrollPane, "Center");
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)this.btnUpdateDTC);
        buttonStackBuilder.addGridded((JComponent)this.btnClearDTC);
        jPanel.add((Component)buttonStackBuilder.getPanel(), "East");
        return jPanel;
    }

    private JComponent buildReadinessPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tblReadiness), 21, 31);
        jPanel.add((Component)jScrollPane, "Center");
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)this.btnUpdateReadiness);
        jPanel.add((Component)buttonStackBuilder.getPanel(), "East");
        return jPanel;
    }

    private JComponent buildDTCCheckPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(new ColumnSpec((Size)Sizes.dluX((int)10)));
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(new ColumnSpec((Size)Sizes.dluX((int)10)));
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(new ColumnSpec((Size)Sizes.dluX((int)10)));
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.cbEvapEGR, cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.cbMisfire, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.cbAT, cellConstraints.xy(5, n));
        panelBuilder.add((Component)this.cbIdle, cellConstraints.xy(7, n));
        panelBuilder.add((Component)this.cbO2, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.cbFuelTrim, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.cbClosedLoop, cellConstraints.xy(5, n));
        n += 2;
        return panelBuilder.getPanel();
    }
}

