/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.view.ecmlink.DTC2GRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTC2GRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.uif.AbstractView;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;

public class DTC2GTab
extends SettingsSubTab {
    AbstractAction clearDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DTC2GTab.this.clearDTCTask, true);
        }
    };
    Task clearDTCTask = new Task(){

        public Object run() throws Exception {
            ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(DTC2GTab.this.getRecordSet().getDeviceId());
            eCMLinkDeviceManager.clearDTCs();
            return null;
        }
    };
    AbstractAction updateDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DTC2GTab.this.updateDTCTask, true);
        }
    };
    Task updateDTCTask = new Task(){

        public Object run() throws Exception {
            ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(DTC2GTab.this.getRecordSet().getDeviceId());
            eCMLinkDeviceManager.updateDTCRecord();
            return null;
        }
    };

    public DTC2GTab(RecordSet recordSet, SettingsTab settingsTab) {
        super(recordSet, settingsTab);
        this.clearDTCAction.putValue("Name", "Clear All");
        this.clearDTCAction.putValue("ShortDescription", "Clears any pending DTCs and resets the OBD II readiness states");
        this.updateDTCAction.putValue("Name", "Update All");
        this.updateDTCAction.putValue("ShortDescription", "Updates the view with the latest DTC and readiness information from the device");
        this.clearDTCAction.setEnabled(false);
        this.updateDTCAction.setEnabled(false);
    }

    public static boolean canDisplay(Map map) {
        return DTC2GRecordModel.canDisplay(map);
    }

    @Override
    void setLiveView(boolean bl) {
        this.clearDTCAction.setEnabled(bl);
        this.updateDTCAction.setEnabled(bl);
        super.setLiveView(bl);
    }

    @Override
    protected RecordModel createLocalModel() {
        return new DTC2GRecordModel(this.getRecordSet());
    }

    @Override
    protected AbstractView createView(RecordModel recordModel) {
        return new DTC2GRecordView((DTC2GRecordModel)recordModel, this);
    }

    @Override
    protected String getTabTitle() {
        return "DTCs";
    }

    @Override
    protected String getTipText() {
        return "Shows trouble codes and readiness status";
    }

    @Override
    protected String getTabHelpId() {
        return "ecmlink.dtc.tab";
    }
}

