/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDTC;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC1GDSMRecord;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTCE3Record;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DTCE3RecordModel
extends RecordModel {
    ValueModel mdlEGR;
    ValueModel mdlO2;
    ValueModel mdlTPS;
    ValueModel mdlSpeed;
    ValueModel mdlKnock;
    ArrayListModel listMdlDTCs;
    ArrayListModel listMdlDTCDescs;
    final DTC1GDSMRecord dtcRecord;
    PropertyChangeListener dtcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DTCE3RecordModel.this.updateLists();
        }
    };

    DTCE3RecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
        this.listMdlDTCs = new ArrayListModel();
        this.listMdlDTCDescs = new ArrayListModel();
        Map map = recordSet.getPersistentRecordMap();
        this.dtcRecord = (DTCE3Record)RecordSet.getRecord(-3, map);
        WeakListeners.addValueChangeListener(this.dtcListener, this.dtcRecord.getField("DtcTable"));
    }

    public void updateLists() {
        Integer n;
        List list = this.dtcRecord.getDTCs();
        this.listMdlDTCs.clear();
        this.listMdlDTCDescs.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (n = (Integer)iterator.next()) != 0) {
            this.listMdlDTCs.add((Object)XFormatter.toHex4(n));
            this.listMdlDTCDescs.add((Object)ECMLinkDTC.getE3DTCDesc(n));
        }
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(45, map);
        this.mdlEGR = this.track(this.mdlEGR, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 1));
        this.mdlO2 = this.track(this.mdlO2, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 2));
        this.mdlTPS = this.track(this.mdlTPS, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 4));
        this.mdlSpeed = this.track(this.mdlSpeed, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 8));
        this.mdlKnock = this.track(this.mdlKnock, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 16));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(-3, map) && RecordSet.containsRecordId(45, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return RecordSet.containsRecordId(45, map);
    }
}

