/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDTC;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ListBasedTableModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTCE3RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTCE3Tab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.AbstractView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class DTCE3RecordView
extends AbstractView {
    private JButton btnHelp;
    private JCheckBox cbEGR;
    private JCheckBox cbO2;
    private JCheckBox cbTPS;
    private JCheckBox cbSpeed;
    private JCheckBox cbKnock;
    private JButton btnUpdateDTC;
    private JButton btnClearDTC;
    HandyJTable tblDTC;
    private final DTCE3RecordModel dtcModel;
    private final DTCE3Tab parentDTCTab;

    public DTCE3RecordView(DTCE3RecordModel dTCE3RecordModel, DTCE3Tab dTCE3Tab) {
        this.dtcModel = dTCE3RecordModel;
        this.parentDTCTab = dTCE3Tab;
    }

    private void initComponents() {
        this.cbEGR = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlEGR, (String)"EGR");
        this.cbEGR.setToolTipText("If checked, will enable diagnostics for the exhaust gas recirc (EGR) valve");
        this.cbO2 = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlO2, (String)"Oxygen sensor");
        this.cbO2.setToolTipText("If checked, will enable diagnostics related to front O2 sensor operation");
        this.cbTPS = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlTPS, (String)"Throttle position sensor");
        this.cbTPS.setToolTipText("If checked, will enable checks for valid throttle position data");
        this.cbSpeed = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlSpeed, (String)"Speed sensor");
        this.cbSpeed.setToolTipText("If checked, will enable checks of the speed sensor");
        this.cbKnock = BasicComponentFactory.createCheckBox((ValueModel)this.dtcModel.mdlKnock, (String)"Knock sensor");
        this.cbKnock.setToolTipText("If checked, will enable diagnostic checks of knock sensor operation");
        this.btnClearDTC = new JButton(this.parentDTCTab.clearDTCAction);
        this.btnUpdateDTC = new JButton(this.parentDTCTab.updateDTCAction);
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel();
        listBasedTableModel.setMinimumRowCount(3);
        listBasedTableModel.addColumn("DTC", (ListModel)this.dtcModel.listMdlDTCs);
        listBasedTableModel.addColumn("Description", (ListModel)this.dtcModel.listMdlDTCDescs);
        this.tblDTC = new HandyJTable();
        this.tblDTC.setAutoResizeMode(3);
        this.tblDTC.setUsePreferredSizeAsScrollSize(true);
        this.tblDTC.setModel(listBasedTableModel);
        this.tblDTC.setColumnWidthFromProto(0, "0x00000");
        this.tblDTC.setColumnWidthFromProto(1, ECMLinkDTC.getAllDTCDescs());
        this.tblDTC.setColumnAlignments(new int[]{4, 2});
        this.dtcModel.updateLists();
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Reported DTCs", cellConstraints.xyw(1, n, 3));
        panelBuilder.add((Component)this.buildDTCTblPanel(), cellConstraints.xy(2, n += 2));
        panelBuilder.addSeparator("Enabled DTC Checks", cellConstraints.xyw(1, n += 2, 3));
        panelBuilder.add((Component)this.buildDTCCheckPanel(), cellConstraints.xy(2, n += 2));
        return panelBuilder.getPanel();
    }

    private JComponent buildDTCTblPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tblDTC));
        jPanel.add((Component)jScrollPane, "Center");
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addGlue();
        buttonStackBuilder.addGridded((JComponent)this.btnUpdateDTC);
        buttonStackBuilder.addGridded((JComponent)this.btnClearDTC);
        jPanel.add((Component)buttonStackBuilder.getPanel(), "East");
        return jPanel;
    }

    private JComponent buildDTCCheckPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(new ColumnSpec((Size)Sizes.dluX((int)10)));
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.cbEGR, cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.cbO2, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.cbTPS, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.cbSpeed, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.cbKnock, cellConstraints.xy(1, n += 2));
        n += 2;
        return panelBuilder.getPanel();
    }
}

