/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.view.ecmlink.DTCE3RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.DTCE3RecordView;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.uif.AbstractView;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;

public class DTCE3Tab
extends SettingsSubTab {
    AbstractAction clearDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DTCE3Tab.this.clearDTCTask, true);
        }
    };
    Task clearDTCTask = new Task(){

        public Object run() throws Exception {
            ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(DTCE3Tab.this.getRecordSet().getDeviceId());
            eCMLinkDeviceManager.clearDTCs();
            return null;
        }
    };
    AbstractAction updateDTCAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(DTCE3Tab.this.updateDTCTask, true);
        }
    };
    Task updateDTCTask = new Task(){

        public Object run() throws Exception {
            ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(DTCE3Tab.this.getRecordSet().getDeviceId());
            eCMLinkDeviceManager.updateDTCRecord();
            return null;
        }
    };

    public DTCE3Tab(RecordSet recordSet, SettingsTab settingsTab) {
        super(recordSet, settingsTab);
        this.clearDTCAction.putValue("Name", "Clear DTCs");
        this.clearDTCAction.putValue("ShortDescription", "Clears any pending DTCs in the ECU");
        this.updateDTCAction.putValue("Name", "Update DTCs");
        this.updateDTCAction.putValue("ShortDescription", "Updates the view with the latest DTC information from the ECU");
        this.clearDTCAction.setEnabled(false);
        this.updateDTCAction.setEnabled(false);
    }

    public static boolean canDisplay(Map map) {
        return DTCE3RecordModel.canDisplay(map);
    }

    @Override
    void setLiveView(boolean bl) {
        this.clearDTCAction.setEnabled(bl);
        this.updateDTCAction.setEnabled(bl);
        super.setLiveView(bl);
    }

    @Override
    protected RecordModel createLocalModel() {
        return new DTCE3RecordModel(this.getRecordSet());
    }

    @Override
    protected AbstractView createView(RecordModel recordModel) {
        return new DTCE3RecordView((DTCE3RecordModel)recordModel, this);
    }

    @Override
    protected String getTabTitle() {
        return "DTCs";
    }

    @Override
    protected String getTipText() {
        return "Shows trouble codes and readiness status";
    }

    @Override
    protected String getTabHelpId() {
        return "ecmlink.dtc.tab";
    }
}

