/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractGaugeModel;
import com.ecmtuning.ecmlink.view.ecmlink.Gauge1GModel;
import com.ecmtuning.ecmlink.view.ecmlink.Gauge2GModel;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.util.List;
import java.util.Map;

class DashRecordModel
extends RecordModel {
    ValueModel mdlGauge;
    ValueModelPlug mdlKnock;
    ValueModelPlug mdlTemp;
    ValueModelPlug mdlTempOff;
    Object dashRecordId;
    List gaugeChoices;
    static final int[] DASH_RECORD_IDS = new int[]{10, 19, 43};

    DashRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(DASH_RECORD_IDS, map);
        if (this.doingPersistedCreate) {
            this.dashRecordId = baseRecord.getRecordID();
        }
        this.mdlKnock = this.track(this.mdlKnock, baseRecord.numberFieldAsString("knockMILX"));
        this.mdlTemp = baseRecord.numberFieldAsString("TempMILX");
        UnitsHelper.installFilter(this.mdlTemp, "typeTemperatureFromF");
        this.track(null, this.mdlTemp);
        this.mdlTempOff = baseRecord.numberFieldAsString("CoolTempOffset");
        UnitsHelper.installFilter(this.mdlTempOff, "typeOffsetTemperatureFromF");
        this.track(null, this.mdlTempOff);
        boolean bl = ECMLinkDeviceMap.is2GDSMDevice(baseRecord.getDeviceId());
        boolean bl2 = ECMLinkDeviceMap.is1GDSMDevice(baseRecord.getDeviceId());
        AbstractGaugeModel abstractGaugeModel = null;
        if (bl) {
            abstractGaugeModel = new Gauge2GModel(baseRecord);
        } else if (bl2) {
            abstractGaugeModel = new Gauge1GModel(baseRecord);
        }
        if (abstractGaugeModel != null) {
            this.mdlGauge = this.track(this.mdlGauge, abstractGaugeModel);
            this.gaugeChoices = abstractGaugeModel.getComboListValues();
        }
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(DASH_RECORD_IDS, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(DASH_RECORD_IDS, map);
        return baseRecord != null && BindingUtils.equals((Object)baseRecord.getRecordID(), (Object)this.dashRecordId);
    }
}

