/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.DashRecordModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;

public class DashRecordView
extends AbstractView {
    private JComboBox comboGauge;
    private JSpinner spnrKnock;
    private JSpinner spnrTemp;
    private JSpinner spnrTempOffset;
    private final DashRecordModel model;

    public DashRecordView(DashRecordModel dashRecordModel) {
        this.model = dashRecordModel;
    }

    private void initComponents() {
        if (this.model.mdlGauge != null) {
            this.comboGauge = DialogUtil.createComboBox(this.model.gaugeChoices, this.model.mdlGauge, false, "Selects the value to display on the factory boost gauge");
        }
        this.spnrKnock = DialogUtil.createSpinnerTextField(this.model.mdlKnock, "Sets the knock retard value above which the check engine light will illuminate");
        this.spnrTemp = DialogUtil.createSpinnerTextField(this.model.mdlTemp, "Sets the coolant temperature above which the check engine light will illuminate");
        this.spnrTempOffset = DialogUtil.createSpinnerTextField(this.model.mdlTempOff, "Adds the specified value to the coolant temperature seen by the ECU");
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Dash Controls", cellConstraints.xyw(1, n, 7));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "Knock CEL:", this.spnrKnock, "\u00b0 retard", cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Coolant CEL:", this.spnrTemp, UnitsHelper.createJLabel("typeTemperatureFromF"), cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Coolant offset:", this.spnrTempOffset, UnitsHelper.createJLabel("typeOffsetTemperatureFromF"), cellConstraints.xy(2, n));
        if (this.comboGauge != null) {
            panelBuilder.addLabel("Boost gauge:", cellConstraints.xy(2, n));
            panelBuilder.add((Component)this.comboGauge, cellConstraints.xyw(4, n, 4, CellConstraints.LEFT, CellConstraints.DEFAULT));
        }
        return panelBuilder.getPanel();
    }
}

