/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.util.ReflectionUtils;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetachedTableDialog
extends AbstractDialog {
    ValueModel mdlTitlePrefix;
    String titleSuffix;
    ValueModel mdlDetached;
    JComponent detachedComponent;
    Frame parentFrame;
    WindowListener parentFrameListener = new WindowAdapter(){

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            DetachedTableDialog.this.show();
            DetachedTableDialog.this.parentFrame.toFront();
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            DetachedTableDialog.this.hide();
        }
    };
    PropertyChangeListener tabNameListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DetachedTableDialog.this.pushName();
        }
    };
    static final Class[] setWindowOpacityParmTypes = new Class[]{Window.class, Float.TYPE};

    public static DetachedTableDialog createPopoutDialog(Frame frame) {
        JFrame jFrame = new JFrame();
        Image image = frame.getIconImage();
        jFrame.setIconImage(image);
        return new DetachedTableDialog(jFrame, frame);
    }

    public void setPopoutControls(ValueModel valueModel, String string, ValueModel valueModel2, JComponent jComponent) {
        this.mdlTitlePrefix = valueModel;
        this.titleSuffix = string;
        this.mdlDetached = valueModel2;
        this.detachedComponent = jComponent;
        WeakListeners.addValueChangeListener(this.tabNameListener, valueModel);
        this.pushName();
    }

    private DetachedTableDialog(Frame frame, Frame frame2) {
        super(frame, "", false);
        this.parentFrame = frame2;
        this.parentFrame.addWindowListener(this.parentFrameListener);
    }

    void pushName() {
        this.setTitle(this.mdlTitlePrefix.getValue() + " - " + this.titleSuffix);
    }

    public void reallyClose() {
        this.getContentPane().remove(this.detachedComponent);
        this.parentFrame.removeWindowListener(this.parentFrameListener);
        super.close();
    }

    public void close() {
        this.mdlDetached.setValue((Object)Boolean.FALSE);
        this.parentFrame.removeWindowListener(this.parentFrameListener);
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 3));
        jPanel.add((Component)this.buildNorthPanel(), "North");
        jPanel.add((Component)this.detachedComponent, "Center");
        jPanel.setPreferredSize(this.detachedComponent.getSize());
        return jPanel;
    }

    protected JComponent buildNorthPanel() {
        PropertyAdapter propertyAdapter;
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.UNRELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        FormLayout formLayout = new FormLayout(arrayList, new ArrayList());
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.appendRow(DialogUtil.CENTER_PREF_NOGROW_ROWSPEC);
        panelBuilder.setColumn(2);
        JCheckBox jCheckBox = new JCheckBox("Always on top");
        boolean bl = false;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object object = ReflectionUtils.invokeMethodIfThere(toolkit, "isAlwaysOnTopSupported");
        if (object != null && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        if (bl) {
            propertyAdapter = new PropertyAdapter((Object)this, "alwaysOnTop", true);
            Bindings.bind((JCheckBox)jCheckBox, (ValueModel)propertyAdapter);
        } else {
            jCheckBox.setText(jCheckBox.getText() + " - <unsupported by JVM>");
            jCheckBox.setEnabled(false);
        }
        panelBuilder.add((Component)jCheckBox);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("Opacity:");
        panelBuilder.nextColumn(2);
        propertyAdapter = new ValueHolder();
        propertyAdapter.setValue((Object)new Integer(99));
        JComponent jComponent = null;
        boolean bl2 = false;
        Class clazz = DetachedTableDialog.findAWTUtilities();
        if (clazz != null && ReflectionUtils.hasMethod(clazz, "setWindowOpacity", setWindowOpacityParmTypes)) {
            bl2 = true;
        }
        if (bl2) {
            BoundedRangeAdapter boundedRangeAdapter = new BoundedRangeAdapter((ValueModel)propertyAdapter, 0, 50, 99);
            jComponent = new JSlider((BoundedRangeModel)boundedRangeAdapter);
            try {
                ReflectionUtils.invokeMethod(clazz, "setWindowOpacity", setWindowOpacityParmTypes, new Object[]{this, new Float(0.99f)});
                boundedRangeAdapter.addChangeListener((ChangeListener)new OpacityChangeListener(boundedRangeAdapter));
            }
            catch (Exception exception) {}
        } else {
            jComponent = new JLabel("<unsupported by JVM>");
            jComponent.setEnabled(false);
        }
        panelBuilder.add((Component)jComponent);
        return panelBuilder.getPanel();
    }

    static Class findAWTUtilities() {
        Class clazz = null;
        try {
            clazz = ReflectionUtils.resolveClass("com.sun.awt.AWTUtilities");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = ReflectionUtils.resolveClass("java.awt.AWTUtilities");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    protected void locateOnScreen() {
        this.setLocationRelativeTo(this.parentFrame);
    }

    class OpacityChangeListener
    implements ChangeListener {
        final BoundedRangeAdapter boundedRangeAdapter;

        public OpacityChangeListener(BoundedRangeAdapter boundedRangeAdapter) {
            this.boundedRangeAdapter = boundedRangeAdapter;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            float f = (float)this.boundedRangeAdapter.getValue() / 100.0f;
            ReflectionUtils.invokeMethod(DetachedTableDialog.findAWTUtilities(), "setWindowOpacity", setWindowOpacityParmTypes, new Object[]{DetachedTableDialog.this, new Float(f)});
        }
    }
}

