/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.CheckedValueListener;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.model.ObjectListFilter;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessModel;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableColumn;

public class DirectAccessListAdapter
extends ChtTblDataAdapter {
    public static final Integer DISPLAY_TYPE_FILTERED = new Integer(0);
    public static final Integer DISPLAY_TYPE_BASE10 = new Integer(1);
    public static final Integer DISPLAY_TYPE_BASE16 = new Integer(2);
    private ChtTblBuilder chtTblBuilder;
    final ByteRecordDescriptor descriptor;
    final DirectAccessModel.DescriptorModel model;
    ValueModel rawPersistedModel;
    ListModelPlug stringPersistedModel;
    Number2StringFilter persistedStringFilter;
    private PropertyAdapter stockValuesVisibleHolder = new PropertyAdapter((Object)this, "templateVisible", true);
    ToggleAction toggleStockAction;
    ToggleAction base10Action;
    ToggleAction base16Action;
    ToggleAction convertedAction;
    Action useStockAction;
    Action copyTableAction;
    Action pasteTableAction;

    DirectAccessListAdapter(DirectAccessModel.DescriptorModel descriptorModel) {
        this.descriptor = descriptorModel.descriptor;
        this.model = descriptorModel;
        this.chtTblBuilder = new ChtTblBuilder(this);
        super.construct(this.descriptor.getValuePrototypes());
        this.rawPersistedModel = this.createRawPersistedModel();
        this.stringPersistedModel = this.createStringPersistedModel();
        this.stringDataModel.getLocalArrayListValue().addListDataListener((ListDataListener)new CheckedValueListener(this.stringDataModel, this.stringPersistedModel, this.stringTemplateModel, this.rawDataModel, this.rawPersistedModel, this.rawTemplateModel));
        this.createLocalActions();
    }

    JPanel buildPanel(boolean bl) {
        this.initTable();
        this.initChart();
        return this.chtTblBuilder.getPanel(bl);
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        ((Component)((Object)handyJTable)).addMouseListener(this.getPopupListener());
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        FloatRect floatRect = new FloatRect();
        FloatRect floatRect2 = new FloatRect();
        floatRect.setCorners(this.descriptor.getAxisMinX(), this.descriptor.getAxisMinValue(), this.descriptor.getAxisMaxX(), this.descriptor.getAxisMaxValue());
        floatRect2.setCorners(this.descriptor.getAxisMinX(), 0.0f, this.descriptor.getAxisMaxX(), 255.0f);
        this.setMaxViewportForDisplayType(DISPLAY_TYPE_FILTERED, floatRect);
        this.setMaxViewportForDisplayType(DISPLAY_TYPE_BASE10, floatRect2);
        this.setMaxViewportForDisplayType(DISPLAY_TYPE_BASE16, floatRect2);
        FloatRect floatRect3 = new FloatRect(0.0f, 0.0f, this.descriptor.getGridWidth(), this.descriptor.getGridHeight());
        FloatRect floatRect4 = new FloatRect(0.0f, 0.0f, this.descriptor.getGridWidth(), 20.0f);
        this.setGridForDisplayType(DISPLAY_TYPE_FILTERED, floatRect3);
        this.setGridForDisplayType(DISPLAY_TYPE_BASE10, floatRect4);
        this.setGridForDisplayType(DISPLAY_TYPE_BASE16, floatRect4);
        chart.setXAxisLoc(this.descriptor.getOriginX());
        chart.setYAxisLoc(this.descriptor.getOriginValue());
        this.chtTblBuilder.setStandardPlotDescs();
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.getPopupListener());
    }

    HandyJTable getDataTable() {
        return this.chtTblBuilder.getDataTable();
    }

    Chart getChartForFocus() {
        return this.chtTblBuilder.getChart();
    }

    @Override
    protected ValueModel createDataColumnHeaderModel() {
        return new ValueHolder((Object)this.descriptor.getValueHeader());
    }

    @Override
    protected ValueModel createRowHeaderColumnHeaderModel() {
        return this.descriptor.getXAxisHeaderModel();
    }

    @Override
    protected ValueModel createTemplateColumnHeaderModel() {
        return new ValueHolder((Object)"Stock");
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return this.model.xAxisValues;
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.model.mdlBytes;
    }

    @Override
    protected ValueModel createRawTemplateModel() {
        return this.model.mdlStockBytes;
    }

    @Override
    protected ListModelPlug createNumberRowHeaderModel() {
        return new ListModelPlug(this.model.xAxisRawValues, null, true);
    }

    protected ValueModel createRawPersistedModel() {
        return this.model.mdlPersistedBytes;
    }

    protected ListModelPlug createStringPersistedModel() {
        this.persistedStringFilter = new BaseTblDataAdapter.DynamicNumber2StringFilter(0);
        return this._createStringDataModel(this.rawPersistedModel, this.persistedStringFilter);
    }

    @Override
    protected void addDataFilters(ListModelPlug listModelPlug) {
        listModelPlug.addObjectListFilter(new LocalObjectFilter(this.descriptor));
    }

    @Override
    protected int getRowHeaderPrec() {
        return this.descriptor.getXAxisPrec();
    }

    @Override
    protected int getDataPrec() {
        if (DISPLAY_TYPE_FILTERED.equals(this.getDisplayType())) {
            return this.descriptor.getValuePrec();
        }
        return 0;
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = this.descriptor.getValueBaseField();
        Float f = new Float(float8Field.convertFromRawValue(number.intValue()));
        f = bl ? float8Field.nextStepValue(f) : float8Field.previousStepValue(f);
        return new Float(float8Field.convertToRawValue(f.floatValue()));
    }

    public ValueModel getStockValuesVisibleHolder() {
        return this.stockValuesVisibleHolder;
    }

    @Override
    protected void handleNewDisplayType() {
        boolean bl = DISPLAY_TYPE_BASE16.equals(this.getDisplayType());
        this.dataStringFilter.setBase16(bl);
        this.templateStringFilter.setBase16(bl);
        this.persistedStringFilter.setBase16(bl);
        this.stringPersistedModel.resetLocalValue();
        TableColumn tableColumn = this.getDataColumnModel().getColumn(COLUMN_INDEX_DATA);
        if (DISPLAY_TYPE_FILTERED.equals(this.getDisplayType())) {
            tableColumn.setHeaderValue(this.descriptor.getValueHeader());
        } else {
            tableColumn.setHeaderValue("Raw");
        }
    }

    MouseListener getPopupListener() {
        return new PopupAdapter(false){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return DirectAccessListAdapter.this.buildPopupMenu();
            }
        };
    }

    private JPopupMenu buildPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.addToggle(this.convertedAction);
        popupMenuBuilder.addToggle(this.base10Action);
        popupMenuBuilder.addToggle(this.base16Action);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.addToggle(this.toggleStockAction);
        if (this.getTemplateVisible().booleanValue()) {
            popupMenuBuilder.add(this.useStockAction);
        }
        this.addExtraPopupActions(popupMenuBuilder);
        return popupMenuBuilder.getPopupMenu();
    }

    private void createLocalActions() {
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)this, "displayType", true);
        this.base10Action = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_BASE10);
        ECMLinkResources.configureAction((Action)this.base10Action, "directAccessBase10");
        this.base16Action = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_BASE16);
        ECMLinkResources.configureAction((Action)this.base16Action, "directAccessBase16");
        this.convertedAction = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_FILTERED);
        ECMLinkResources.configureAction((Action)this.convertedAction, "directAccessConverted");
        this.toggleStockAction = ToggleAction.createCheck((ValueModel)this.stockValuesVisibleHolder);
        ECMLinkResources.configureAction((Action)this.toggleStockAction, "directAccessShowStock");
        this.useStockAction = new DispatchingAction("directAccessUseStock");
        ECMLinkResources.configureAction(this.useStockAction, "directAccessUseStock");
        this.copyTableAction = this.chtTblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = this.chtTblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    private class DispatchingAction
    extends AbstractAction {
        private final String id;

        DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id == "directAccessUseStock") {
                List list = (List)DirectAccessListAdapter.this.rawDataModel.getValue();
                List list2 = (List)DirectAccessListAdapter.this.rawTemplateModel.getValue();
                Collections.copy(list, list2);
            }
        }
    }

    private final class LocalObjectFilter
    implements ObjectListFilter {
        final Float8Field baseField;
        final ObjectFilter valueFilter;

        LocalObjectFilter(ByteRecordDescriptor byteRecordDescriptor) {
            this.baseField = byteRecordDescriptor.getValueBaseField();
            this.valueFilter = byteRecordDescriptor.getValueFilter();
        }

        @Override
        public Object filter(Object object, int n) {
            if (DISPLAY_TYPE_FILTERED.equals(DirectAccessListAdapter.this.getDisplayType())) {
                object = new Float(this.baseField.convertFromRawValue(((Number)object).intValue()));
                if (this.valueFilter != null) {
                    object = this.valueFilter.filter(object);
                }
            }
            return object;
        }

        @Override
        public Object unfilter(Object object, int n, Object object2) throws Exception {
            if (DISPLAY_TYPE_FILTERED.equals(DirectAccessListAdapter.this.getDisplayType())) {
                if (this.valueFilter != null) {
                    object = this.valueFilter.unfilter(object, object2);
                }
                object = new Float(this.baseField.convertToRawValue(((Number)object).floatValue()));
            }
            return object;
        }
    }
}

