/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.ByteRecord;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DirectAccessModel
extends RecordModel {
    final List descriptorModels = new ArrayList();

    public DirectAccessModel(List list, RecordSet recordSet) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.descriptorModels.add(new DescriptorModel((ByteRecordDescriptor)iterator.next()));
        }
        this.initialize(recordSet);
    }

    boolean matchesStockBytes() {
        for (DescriptorModel descriptorModel : this.descriptorModels) {
            if (descriptorModel.mdlBytes != null && descriptorModel.mdlStockBytes != null && descriptorModel.mdlBytes.hasEqualValues(descriptorModel.mdlStockBytes)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void initAndTrackModels(Map map) {
        for (DescriptorModel descriptorModel : this.descriptorModels) {
            this._initAndTrackModels(descriptorModel, map);
        }
    }

    private void _initAndTrackModels(DescriptorModel descriptorModel, Map map) {
        ByteRecordDescriptor byteRecordDescriptor = descriptorModel.descriptor;
        ByteRecord byteRecord = byteRecordDescriptor.findCompatibleRecord(map.values());
        ListModelPlug listModelPlug = byteRecord.numberListField("bytes");
        listModelPlug.setReverseSubjectAccess(byteRecordDescriptor.isReverseOrder());
        descriptorModel.mdlBytes = this.track(descriptorModel.mdlBytes, listModelPlug);
        if (this.doingPersistedCreate) {
            descriptorModel.mdlPersistedBytes = listModelPlug;
        }
        descriptorModel.mdlStockBytes = this.track(descriptorModel.mdlStockBytes, new ListModelPlug(byteRecordDescriptor.getStockValuesModel(), null, false));
        descriptorModel.xAxisHeader = this.track(descriptorModel.xAxisHeader, new ValueModelPlug(byteRecordDescriptor.getXAxisHeaderModel(), null, false), false);
        descriptorModel.xAxisValues = this.track(descriptorModel.xAxisValues, new ListModelPlug(byteRecordDescriptor.getXAxisValuesModel(), null, false), false);
        descriptorModel.xAxisRawValues = this.track(descriptorModel.xAxisRawValues, new ListModelPlug(byteRecordDescriptor.getXAxisRawValuesModel(), null, false), false);
        if (byteRecordDescriptor.isTableRecord()) {
            descriptorModel.yAxisHeader = this.track(descriptorModel.yAxisHeader, new ValueModelPlug(byteRecordDescriptor.getYAxisHeaderModel(), null, false), false);
            descriptorModel.yAxisValues = this.track(descriptorModel.yAxisValues, new ListModelPlug(byteRecordDescriptor.getYAxisValuesModel(), null, false), false);
            descriptorModel.yAxisRawValues = this.track(descriptorModel.yAxisRawValues, new ListModelPlug(byteRecordDescriptor.getYAxisRawValuesModel(), null, false), false);
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        Collection collection = map.values();
        for (DescriptorModel descriptorModel : this.descriptorModels) {
            if (descriptorModel.descriptor.findCompatibleRecord(collection) != null) continue;
            return false;
        }
        return true;
    }

    static class DescriptorModel {
        final ByteRecordDescriptor descriptor;
        ListModelPlug mdlBytes;
        ListModelPlug mdlPersistedBytes;
        ListModelPlug mdlStockBytes;
        ValueModelPlug xAxisHeader;
        ValueModelPlug yAxisHeader;
        ListModelPlug xAxisValues;
        ListModelPlug yAxisValues;
        ListModelPlug xAxisRawValues;
        ListModelPlug yAxisRawValues;

        DescriptorModel(ByteRecordDescriptor byteRecordDescriptor) {
            this.descriptor = byteRecordDescriptor;
        }
    }
}

