/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.control.ecmlink.DirectAccessUpdateTask;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptorBase;
import com.ecmtuning.ecmlink.device.records.ByteRecordGroupDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.ui.SwingInvokeUtils;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessModel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessView;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetTab;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.AbstractView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.border.Border;

public class DirectAccessSubPanel
extends RecordSetSubTab {
    final List descriptors;
    final ByteRecordDescriptorBase baseDesc;
    DirectAccessView view = null;
    ValueHolder showStockValuesModel = new ValueHolder((Object)Boolean.FALSE);
    boolean shown = false;

    public DirectAccessSubPanel(ByteRecordDescriptor byteRecordDescriptor, RecordSet recordSet, RecordSetTab recordSetTab) {
        super(recordSet, recordSetTab);
        this.descriptors = new ArrayList();
        this.descriptors.add(byteRecordDescriptor);
        this.baseDesc = byteRecordDescriptor;
        this.initializeListeners();
        this.initialize();
    }

    public DirectAccessSubPanel(ByteRecordGroupDescriptor byteRecordGroupDescriptor, RecordSet recordSet, RecordSetTab recordSetTab) {
        super(recordSet, recordSetTab);
        this.descriptors = byteRecordGroupDescriptor.getDescriptorRecords();
        this.baseDesc = byteRecordGroupDescriptor;
        this.initializeListeners();
        this.initialize();
    }

    @Override
    protected void deregisterTab() {
        if (this.view != null) {
            this.view.dropView();
        }
        if (this.descriptors != null) {
            this.descriptors.clear();
        }
        super.deregisterTab();
    }

    protected void initializeListeners() {
        this.showStockValuesModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (DirectAccessSubPanel.this.view != null) {
                    DirectAccessSubPanel.this.view.setStockValuesVisible((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    ValueModel getShowStockValuesModel() {
        if (this.view != null && this.view.getStockValuesVisibleModel() != null) {
            return this.view.getStockValuesVisibleModel();
        }
        return this.showStockValuesModel;
    }

    @Override
    String getTabHelpId() {
        return "ecmlink.directaccess.tab";
    }

    @Override
    String getTabTitle() {
        return "tabtitle";
    }

    @Override
    String getTipText() {
        return "tiptext";
    }

    @Override
    RecordModel createLocalModel() {
        return new DirectAccessModel(this.descriptors, this.getRecordSet());
    }

    @Override
    AbstractView createView(RecordModel recordModel) {
        this.view = new DirectAccessView(this.baseDesc, (DirectAccessModel)recordModel, this);
        return this.view;
    }

    @Override
    Border getSubTabBorder() {
        return null;
    }

    String getListBoxName() {
        return this.baseDesc.getListBoxName();
    }

    @Override
    void saveTabToECU() throws IOException, DeviceException {
        ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(this.getRecordSet().getDeviceId());
        ByteRecordSet byteRecordSet = eCMLinkDeviceManager.getByteRecordSet();
        Map map = byteRecordSet.getPersistentRecordMapCopy();
        if (!this.isCompatibleWith(map)) {
            JOptionPane.showMessageDialog(this, "This tab contains data that is not compatible with\nthe current ECU.", "Incompatible data", 0);
            return;
        }
        this.applyVolatileModel(map);
        List list = eCMLinkDeviceManager.gatherUpdatedBytes(map);
        if (list.size() == 0) {
            int n = JOptionPane.showOptionDialog(this, "Data on this tab already matches ECU data.\nDo a save all?", "Empty save operation", 0, 3, null, null, null);
            if (n == 0) {
                this.getParentTab().getSaveAllAction().actionPerformed(null);
                return;
            }
            return;
        }
        DirectAccessUpdateTask directAccessUpdateTask = new DirectAccessUpdateTask(eCMLinkDeviceManager, list);
        directAccessUpdateTask.doReflash();
        if (!this.getParentTab().isLiveView()) {
            Map map2 = byteRecordSet.getVolatileRecordMap();
            this.applyVolatileModel(map2);
        }
    }

    @Override
    JComponent getCustomButtonBarComponent() {
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.panelShown(false);
        } else {
            this.panelHidden(false);
        }
    }

    public synchronized void panelShown(boolean bl) {
        if (!this.shown) {
            try {
                if (bl) {
                    SwingInvokeUtils.requestFocusInWindowLater(this.view.getDefaultFocusComponent());
                }
            }
            finally {
                this.shown = true;
            }
        }
    }

    public synchronized void panelHidden(boolean bl) {
        if (this.shown) {
            this.shown = false;
        }
    }
}

