/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.ecmlink.ControlUtil;
import com.ecmtuning.ecmlink.control.ecmlink.DirectAccessUpdateTask;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptorBase;
import com.ecmtuning.ecmlink.device.records.ByteRecordGroupDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.device.records.ByteRecordSetFile;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSetFile;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessModel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessSubPanel;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetTab;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.ToolBarBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class DirectAccessTab
extends RecordSetTab {
    private JList lstRecords;
    private CardLayout recordPanelLayout;
    private JPanel recordPanel;
    private boolean initialSizing = true;
    private static final Logger logger = Logger.getLogger(DirectAccessTab.class.getName());
    PropertyAdapter stockValuesVisibleAdapter;
    ToggleAction toggleStockAction;
    String[] fueltimingids = new String[]{"openloop-max-octane-fuel-dsm-tbl", "openloop-min-octane-fuel-dsm-tbl", "timing-max-octane-tbl", "timing-min-octane-tbl"};
    String[] v3liteaircompIds = new String[]{"air-vol-conv-e3-tbl", "air-vol-corr-e3-tbl", "air-vol-offset-e3-tbl", "air-vol-factor-e3-tbl", "air-dens-comp-e3-tbl"};
    final ListSelectionListener recordPanelSelectionListener = new ListSelectionListener(){

        @Override
        public final void valueChanged(ListSelectionEvent listSelectionEvent) {
            DirectAccessSubPanel directAccessSubPanel = (DirectAccessSubPanel)DirectAccessTab.this.lstRecords.getSelectedValue();
            DirectAccessTab.this.stockValuesVisibleAdapter.setBean((Object)directAccessSubPanel.getShowStockValuesModel());
            DirectAccessTab.this.recordPanelLayout.show(DirectAccessTab.this.recordPanel, directAccessSubPanel.getListBoxName());
        }
    };
    final PropertyChangeListener modelChangeListener = new PropertyChangeListener(){

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DirectAccessTab.this.lstRecords.repaint();
        }
    };
    protected List toolbarItems = new ArrayList();

    public DirectAccessTab(RecordSet recordSet, DatalogFile datalogFile) {
        super(recordSet, datalogFile);
        this.initialize(datalogFile == null);
    }

    public DirectAccessTab(RecordSetFile recordSetFile) {
        super(recordSetFile);
        this.initialize(false);
    }

    public DirectAccessTab(RecordSet recordSet) {
        super(recordSet);
        this.initialize(false);
    }

    @Override
    protected void initialize(boolean bl) {
        ValueHolder valueHolder = new ValueHolder((Object)new ValueHolder((Object)Boolean.FALSE));
        this.stockValuesVisibleAdapter = new PropertyAdapter((ValueModel)valueHolder, "value", true);
        this.toggleStockAction = ToggleAction.createCheck((ValueModel)this.stockValuesVisibleAdapter);
        ECMLinkResources.configureAction((Action)this.toggleStockAction, "directAccessAllToggleStock");
        try {
            this.initialSizing = true;
            super.initialize(bl);
            this.lstRecords.setFixedCellWidth((int)this.lstRecords.getPreferredScrollableViewportSize().getWidth());
        }
        finally {
            this.initialSizing = false;
        }
    }

    @Override
    String getResourcePrefix() {
        return "directAccessTab";
    }

    @Override
    protected RecordSetSubTab[] build() {
        Object[] objectArray2;
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.setOpaque(false);
        ArrayListModel arrayListModel = new ArrayListModel();
        this.lstRecords = new JList(arrayListModel);
        this.lstRecords.addListSelectionListener(this.recordPanelSelectionListener);
        this.lstRecords.setSelectionMode(0);
        this.lstRecords.setCellRenderer(new CellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.lstRecords);
        this.add((Component)jScrollPane, "West");
        this.recordPanelLayout = new CardLayout();
        this.recordPanel = new JPanel(this.recordPanelLayout);
        this.add((Component)this.recordPanel, "Center");
        List list = this.createGroupedDescriptorsList();
        for (Object[] objectArray2 : list) {
            DirectAccessSubPanel directAccessSubPanel = null;
            if (objectArray2.isGroupRecord()) {
                directAccessSubPanel = new DirectAccessSubPanel((ByteRecordGroupDescriptor)objectArray2, (RecordSet)((ByteRecordSet)this.getManagedRecordSet()), (RecordSetTab)this);
            } else if (objectArray2.isListRecord() || objectArray2.isTableRecord()) {
                directAccessSubPanel = new DirectAccessSubPanel((ByteRecordDescriptor)objectArray2, (RecordSet)((ByteRecordSet)this.getManagedRecordSet()), (RecordSetTab)this);
            }
            if (directAccessSubPanel == null) continue;
            directAccessSubPanel.getRecordModel().addPropertyChangeListener("volatileValueChanged", this.modelChangeListener);
            if (arrayListModel.size() == 0) {
                directAccessSubPanel.build();
                directAccessSubPanel.panelShown(true);
            }
            arrayListModel.add((Object)directAccessSubPanel);
            this.recordPanel.add((Component)directAccessSubPanel, objectArray2.getListBoxName());
        }
        this.lstRecords.setSelectedIndex(0);
        objectArray2 = new RecordSetSubTab[arrayListModel.size()];
        arrayListModel.toArray(objectArray2);
        return objectArray2;
    }

    private List createGroupedDescriptorsList() {
        List list = DirectAccessTab.initDescriptorList(this.getManagedRecordSet());
        List list2 = ByteRecordDescriptor.getCompatibleGroups(list);
        if (list2 != null) {
            for (ByteRecordGroupDescriptor byteRecordGroupDescriptor : list2) {
                boolean bl = false;
                for (int i = 0; i < list.size(); ++i) {
                    String string;
                    Object e = list.get(i);
                    String string2 = string = e instanceof ByteRecordDescriptor ? ((ByteRecordDescriptorBase)e).getListBoxName() : ((ByteRecordGroupDescriptor)e).getListBoxName();
                    if (string.compareTo(byteRecordGroupDescriptor.getListBoxName()) <= 0) continue;
                    list.add(i, byteRecordGroupDescriptor);
                    bl = true;
                    break;
                }
                if (bl) continue;
                list.add(byteRecordGroupDescriptor);
            }
        }
        return list;
    }

    private static List initDescriptorList(RecordSet recordSet) {
        List list = ByteRecordDescriptor.getCompatibleDescriptors(recordSet.getPersistentRecordMap().values());
        if (list.remove(0) != null) {
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.direct.access.readerr.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setOkText("Continue");
            optionalMessageDialog.setOptionDisplayed(false);
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((ByteRecordDescriptorBase)object).getListBoxName();
                String string2 = ((ByteRecordDescriptorBase)object2).getListBoxName();
                return string.compareTo(string2);
            }
        });
        return list;
    }

    @Override
    protected File createDefaultFile(FilenameModel filenameModel) {
        return filenameModel.createNewDirectAccessFile();
    }

    @Override
    protected FileFilter getRecordSetFileFilter() {
        return FilenameModel.getDirectAccessFileFilter();
    }

    @Override
    protected String getFileExtension() {
        return "eda";
    }

    @Override
    protected RecordSetFile createRecordSetFile(File file) {
        return new ByteRecordSetFile(this.getManagedRecordSet(), file);
    }

    @Override
    protected void saveAllRecordsToECU() throws IOException, DeviceException {
        ECMLinkDeviceManager eCMLinkDeviceManager = ControlUtil.findCompatibleActiveManager(this.getManagedRecordSet().getDeviceId());
        ByteRecordSet byteRecordSet = eCMLinkDeviceManager.getByteRecordSet();
        Map map = byteRecordSet.getPersistentRecordMapCopy();
        RecordSetSubTab[] recordSetSubTabArray = this.getSubTabs();
        for (int i = 0; i < recordSetSubTabArray.length; ++i) {
            if (!recordSetSubTabArray[i].isCompatibleWith(map)) {
                JOptionPane.showMessageDialog(this, "SaveAll is not possible because some data in this collection\nis incompatible with the current ECU.  Try to save each item\none at a time instead.", "Incompatible data", 0);
                return;
            }
            recordSetSubTabArray[i].applyVolatileModel(map);
        }
        List list = eCMLinkDeviceManager.gatherUpdatedBytes(map);
        if (list.size() == 0) {
            return;
        }
        DirectAccessUpdateTask directAccessUpdateTask = new DirectAccessUpdateTask(eCMLinkDeviceManager, list);
        directAccessUpdateTask.doReflash();
        if (!this.isLiveView()) {
            Map map2 = byteRecordSet.getVolatileRecordMap();
            for (int i = 0; i < recordSetSubTabArray.length; ++i) {
                recordSetSubTabArray[i].applyVolatileModel(map2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initToolbarItems() {
        if (this.toolbarItems.size() == 0) {
            List list = this.toolbarItems;
            synchronized (list) {
                if (this.toolbarItems.size() == 0) {
                    ToolBarBuilder toolBarBuilder = new ToolBarBuilder();
                    this.toolbarItems.add(DialogUtil.createToolbarSeparator());
                    this.toolbarItems.add(toolBarBuilder.addToggle(this.toggleStockAction));
                }
            }
        }
    }

    @Override
    public void tabShown() {
        super.tabShown();
        this.initToolbarItems();
        MainView mainView = MainModel.getInstance().getMainView();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = 0; i < this.toolbarItems.size(); ++i) {
            jToolBar.add((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
        DirectAccessSubPanel directAccessSubPanel = (DirectAccessSubPanel)this.lstRecords.getSelectedValue();
        if (directAccessSubPanel != null) {
            directAccessSubPanel.panelShown(true);
        }
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
        MainView mainView = MainModel.getInstance().getMainView();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        for (int i = this.toolbarItems.size() - 1; i >= 0; --i) {
            jToolBar.remove((Component)this.toolbarItems.get(i));
        }
        jToolBar.repaint();
        DirectAccessSubPanel directAccessSubPanel = (DirectAccessSubPanel)this.lstRecords.getSelectedValue();
        if (directAccessSubPanel != null) {
            directAccessSubPanel.panelHidden(true);
        }
    }

    private final class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public final Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DirectAccessSubPanel directAccessSubPanel = (DirectAccessSubPanel)object;
            String string = directAccessSubPanel.getListBoxName();
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            if (DirectAccessTab.this.initialSizing) {
                DialogUtil.makeBold(this);
            } else {
                DirectAccessModel directAccessModel = (DirectAccessModel)directAccessSubPanel.getRecordModel();
                if (directAccessModel.getDirty()) {
                    this.setForeground(Color.RED);
                }
                if (!directAccessModel.matchesStockBytes()) {
                    DialogUtil.makeBold(this);
                }
            }
            return this;
        }
    }
}

