/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ColorMapEntry;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.gui.chart.CheckedValueListener;
import com.ecmtuning.ecmlink.gui.chart.TblBuilder;
import com.ecmtuning.ecmlink.gui.chart.TblDataAdapter;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.DetachedTableDialog;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessModel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessSubPanel;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.TableSelectionDataAdapter;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellRenderer;

public class DirectAccessTableAdapter
extends TblDataAdapter {
    public static final Integer DISPLAY_TYPE_FILTERED = new Integer(0);
    public static final Integer DISPLAY_TYPE_BASE10 = new Integer(1);
    public static final Integer DISPLAY_TYPE_BASE16 = new Integer(2);
    private TblBuilder tblBuilder;
    final ByteRecordDescriptor descriptor;
    final DirectAccessModel.DescriptorModel model;
    ValueModel rawPersistedModel;
    ListModelPlug stringPersistedModel;
    Number2StringFilter persistedStringFilter;
    LocalObjectFilter dataFilter;
    private ValueHolder stockValuesVisibleHolder = new ValueHolder((Object)Boolean.FALSE);
    boolean changingStockValues = false;
    ValueHolder mdlDetached = new ValueHolder(false);
    ToggleAction actionDetach;
    DetachedTableDialog detachedDialog;
    PropertyAdapter detachedNameAdapter = new PropertyAdapter(null, "tabName", true);
    DirectAccessSubPanel subPanel;
    JComponent componentPanel;
    JComponent tableComponent;
    Object tableConstraints;
    String listBoxName;
    ValueHolder mdlTrackData = new ValueHolder(false);
    ToggleAction trackDataAction;
    TableSelectionDataAdapter tableSelectionAdapter;
    private List nonStockValues = null;
    ToggleAction toggleStockAction;
    ToggleAction base10Action;
    ToggleAction base16Action;
    ToggleAction convertedAction;
    Action copyTableAction;
    Action pasteTableAction;

    DirectAccessTableAdapter(DirectAccessModel.DescriptorModel descriptorModel) {
        this.descriptor = descriptorModel.descriptor;
        this.model = descriptorModel;
        this.tblBuilder = new TblBuilder(this);
        super.construct(this.descriptor.getValuePrototypes());
        this.rawPersistedModel = this.createRawPersistedModel();
        this.stringPersistedModel = this.createStringPersistedModel();
        this.stringDataModel.getLocalArrayListValue().addListDataListener((ListDataListener)new CheckedValueListener(this.stringDataModel, this.stringPersistedModel, this.stringTemplateModel, this.rawDataModel, this.rawPersistedModel, this.rawTemplateModel));
        this.addPropertyChangeListener("displayType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DirectAccessTableAdapter.this.getDataTableModel().fireTableDataChanged();
            }
        });
        this.stockValuesVisibleHolder.addValueChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DirectAccessTableAdapter directAccessTableAdapter = DirectAccessTableAdapter.this;
                synchronized (directAccessTableAdapter) {
                    block11: {
                        try {
                            DirectAccessTableAdapter.this.changingStockValues = true;
                            List list = (List)DirectAccessTableAdapter.this.rawDataModel.getValue();
                            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                            if (bl) {
                                DirectAccessTableAdapter.this.nonStockValues = new ArrayList(list);
                                List list2 = (List)DirectAccessTableAdapter.this.rawTemplateModel.getValue();
                                Collections.copy(list, list2);
                                break block11;
                            }
                            DirectAccessTableAdapter directAccessTableAdapter2 = DirectAccessTableAdapter.this;
                            synchronized (directAccessTableAdapter2) {
                                if (DirectAccessTableAdapter.this.nonStockValues != null) {
                                    Collections.copy(list, DirectAccessTableAdapter.this.nonStockValues);
                                    DirectAccessTableAdapter.this.nonStockValues = null;
                                }
                            }
                        }
                        finally {
                            DirectAccessTableAdapter.this.changingStockValues = false;
                        }
                    }
                }
            }
        });
        ((ArrayListModel)this.rawDataModel.getValue()).addListDataListener(new ListDataListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                DirectAccessTableAdapter directAccessTableAdapter = DirectAccessTableAdapter.this;
                synchronized (directAccessTableAdapter) {
                    if (!DirectAccessTableAdapter.this.changingStockValues) {
                        DirectAccessTableAdapter.this.nonStockValues = null;
                        DirectAccessTableAdapter.this.stockValuesVisibleHolder.setValue((Object)Boolean.FALSE);
                    }
                }
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        this.createLocalActions();
    }

    @Override
    protected int dataModelIndex(int n, int n2) {
        if (this.descriptor.isFlipXY()) {
            return n * this.dataRowCount + n2;
        }
        return n2 * this.dataColumnCount + n;
    }

    JComponent buildTable(boolean bl) {
        this.initTable();
        JScrollPane jScrollPane = this.tblBuilder.getDataTableWithScrollPane();
        if (!bl) {
            HandyJTable handyJTable = this.tblBuilder.getDataTable();
            handyJTable.setScrollPane(jScrollPane);
            handyJTable.setUsePreferredSizeAsScrollSize(true);
            jScrollPane.setVerticalScrollBarPolicy(21);
        }
        return jScrollPane;
    }

    HandyJTable getDataTable() {
        return this.tblBuilder.getDataTable();
    }

    HandyJTable getRowHeaderTable() {
        return this.tblBuilder.getRowHeaderTable();
    }

    private void initTable() {
        HandyJTable handyJTable = this.tblBuilder.getDataTable();
        this.tblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        TableCellRenderer tableCellRenderer = ((JTable)((Object)handyJTable)).getDefaultRenderer(String.class);
        MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer(tableCellRenderer, this.descriptor.getColorMap());
        ((JTable)((Object)handyJTable)).setDefaultRenderer(String.class, myTableCellRenderer);
        ((Component)((Object)handyJTable)).addMouseListener(this.getPopupListener());
    }

    public void setDetached(boolean bl) {
        this.mdlDetached.setValue(bl);
    }

    public boolean isDetached() {
        return this.mdlDetached.booleanValue();
    }

    ToggleAction getDetachedToggleAction() {
        if (this.actionDetach == null) {
            this.actionDetach = ToggleAction.createCheck((ValueModel)this.mdlDetached);
            ECMLinkResources.configureAction((Action)this.actionDetach, "detach");
            this.mdlDetached.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DirectAccessTableAdapter.this.handleDetachedChange();
                }
            });
        }
        return this.actionDetach;
    }

    protected synchronized void handleDetachedChange() {
        if (this.isDetached()) {
            if (this.detachedDialog == null) {
                this.detachedNameAdapter.setBean((Object)this.subPanel.getParentTab());
                this.componentPanel.remove(this.tableComponent);
                this.componentPanel.revalidate();
                this.componentPanel.repaint();
                this.detachedDialog = DetachedTableDialog.createPopoutDialog(Application.getDefaultParentFrame());
                this.detachedDialog.setPopoutControls((ValueModel)this.detachedNameAdapter, this.listBoxName, (ValueModel)this.mdlDetached, this.tableComponent);
                this.detachedDialog.open();
            }
        } else if (this.detachedDialog != null) {
            this.detachedNameAdapter.setBean(null);
            this.detachedDialog.reallyClose();
            this.detachedDialog = null;
            this.componentPanel.add((Component)this.tableComponent, this.tableConstraints);
            this.componentPanel.revalidate();
            this.componentPanel.repaint();
        }
    }

    void setDetachSupport(DirectAccessSubPanel directAccessSubPanel, JComponent jComponent, JComponent jComponent2, Object object, String string) {
        this.subPanel = directAccessSubPanel;
        this.componentPanel = jComponent;
        this.tableComponent = jComponent2;
        this.tableConstraints = object;
        this.listBoxName = string;
        this.tableSelectionAdapter = new TableSelectionDataAdapter((JTable)((Object)this.tblBuilder.getDataTable()), this.descriptor.getTrackXValues(), this.descriptor.getTrackYValues());
    }

    public void setTrackData(boolean bl) {
        this.mdlTrackData.setValue(bl);
    }

    public boolean isTrackData() {
        return this.mdlTrackData.booleanValue();
    }

    ToggleAction getTrackDataToggleAction() {
        if (this.trackDataAction == null) {
            this.trackDataAction = ToggleAction.createCheck((ValueModel)this.mdlTrackData);
            ECMLinkResources.configureAction((Action)this.trackDataAction, "trackData");
            this.mdlTrackData.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DirectAccessTableAdapter.this.handleTrackDataChange();
                }
            });
        }
        return this.trackDataAction;
    }

    protected synchronized void handleTrackDataChange() {
        if (this.isTrackData()) {
            this.reconnectTracking(true);
        } else {
            this.tableSelectionAdapter.deregisterModels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void reconnectTracking(boolean bl) {
        LocationTOC locationTOC;
        Dataset dataset;
        DatalogTab datalogTab;
        boolean bl2;
        block22: {
            bl2 = false;
            datalogTab = this.subPanel.getParentTab().getParentDatalogTab();
            if (datalogTab == null) {
                if (bl) {
                    MainModel.showErrorMessage("Can't find associated datalog tab.", "Error");
                }
                if (bl2) return;
                this.setTrackData(false);
                return;
            }
            Dataset dataset2 = dataset = datalogTab.getDataset();
            // MONITORENTER : dataset2
            locationTOC = dataset.getMainDataTOC();
            if (locationTOC != null) break block22;
            if (bl) {
                MainModel.showErrorMessage("No active datalog found.  You must start a datalog first.", "Error");
            }
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        List list = DisplayChain.generateDisplayChains(locationTOC, false);
        DisplayChain displayChain = DisplayChain.findChainByOutputType(list, this.descriptor.getTrackXDataTypeName());
        if (displayChain == null) {
            if (bl) {
                MainModel.showErrorMessage("Unable to find a value of type '" + this.descriptor.getTrackXDataTypeName() + "' to use for X index.", "Error");
            }
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        DisplayChain displayChain2 = DisplayChain.findChainByOutputType(list, this.descriptor.getTrackYDataTypeName());
        if (displayChain2 == null) {
            if (bl) {
                MainModel.showErrorMessage("Unable to find a value of type '" + this.descriptor.getTrackYDataTypeName() + "' to use for Y index.", "Error");
            }
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        DisplaySet displaySet = new DisplaySet();
        try {
            displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
            ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
            arrayList.add(displayChain);
            arrayList.add(displayChain2);
            displaySet.setDisplayChains(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (bl) {
                MainModel.showErrorMessage("Internal error: " + exception.getMessage(), "Error");
            }
            displaySet.deregisterModels();
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        try {
            this.tableSelectionAdapter.registerModels(displaySet, datalogTab.getTextDisplayTimeModel());
            bl2 = true;
            // MONITOREXIT : dataset2
            return;
        }
        finally {
            if (!bl2) {
                this.setTrackData(false);
            }
        }
    }

    @Override
    protected ValueModel createRawColumnHeaderModel() {
        return this.model.xAxisValues;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return this.model.yAxisValues;
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.model.mdlBytes;
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = this.descriptor.getValueBaseField();
        if (!DISPLAY_TYPE_FILTERED.equals(this.getDisplayType()) && float8Field.isReciprocateRaw()) {
            bl = !bl;
        }
        Float f = new Float(float8Field.convertFromRawValue(number.intValue()));
        f = bl ? float8Field.nextStepValue(f) : float8Field.previousStepValue(f);
        return new Float(float8Field.convertToRawValue(f.floatValue()));
    }

    @Override
    protected ListModelPlug createStringColumnHeaderModel() {
        if (this.descriptor.getXAxisType() == 4) {
            ListModelPlug listModelPlug = new ListModelPlug(this.rawColumnHeaderModel, null, true);
            listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(2));
            return listModelPlug;
        }
        return super.createStringColumnHeaderModel();
    }

    @Override
    protected ListModelPlug createStringRowHeaderModel() {
        if (this.descriptor.getYAxisType() == 4) {
            ListModelPlug listModelPlug = new ListModelPlug(this.rawRowHeaderModel, null, true);
            listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(1));
            return listModelPlug;
        }
        return super.createStringRowHeaderModel();
    }

    @Override
    protected ValueModel createRawTemplateModel() {
        return this.model.mdlStockBytes;
    }

    @Override
    protected void addDataFilters(ListModelPlug listModelPlug) {
        if (this.dataFilter == null) {
            this.dataFilter = new LocalObjectFilter(this.descriptor);
        }
        listModelPlug.addObjectFilter(this.dataFilter);
    }

    @Override
    protected int getRowHeaderPrec() {
        return this.descriptor.getYAxisPrec();
    }

    @Override
    protected int getColumnHeaderPrec() {
        return this.descriptor.getXAxisPrec();
    }

    @Override
    protected int getDataPrec() {
        if (DISPLAY_TYPE_FILTERED.equals(this.getDisplayType())) {
            return this.descriptor.getValuePrec();
        }
        return 0;
    }

    protected ValueModel createRawPersistedModel() {
        return this.model.mdlPersistedBytes;
    }

    protected ListModelPlug createStringPersistedModel() {
        this.persistedStringFilter = new BaseTblDataAdapter.DynamicNumber2StringFilter(0);
        return this._createStringDataModel(this.rawPersistedModel, this.persistedStringFilter);
    }

    public ValueModel getStockValuesVisibleHolder() {
        return this.stockValuesVisibleHolder;
    }

    @Override
    protected void handleNewDisplayType() {
        boolean bl = DISPLAY_TYPE_BASE16.equals(this.getDisplayType());
        this.dataStringFilter.setBase16(bl);
        this.templateStringFilter.setBase16(bl);
        this.persistedStringFilter.setBase16(bl);
        this.stringPersistedModel.resetLocalValue();
        super.handleNewDisplayType();
    }

    MouseListener getPopupListener() {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return DirectAccessTableAdapter.this.buildPopupMenu();
            }
        };
    }

    private JPopupMenu buildPopupMenu() {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.addToggle(this.convertedAction);
        popupMenuBuilder.addToggle(this.base10Action);
        popupMenuBuilder.addToggle(this.base16Action);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.addToggle(this.toggleStockAction);
        this.addExtraPopupActions(popupMenuBuilder);
        return popupMenuBuilder.getPopupMenu();
    }

    private void createLocalActions() {
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)this, "displayType", true);
        this.base10Action = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_BASE10);
        ECMLinkResources.configureAction((Action)this.base10Action, "directAccessBase10");
        this.base16Action = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_BASE16);
        ECMLinkResources.configureAction((Action)this.base16Action, "directAccessBase16");
        this.convertedAction = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_FILTERED);
        ECMLinkResources.configureAction((Action)this.convertedAction, "directAccessConverted");
        this.toggleStockAction = ToggleAction.createCheck((ValueModel)this.stockValuesVisibleHolder);
        ECMLinkResources.configureAction((Action)this.toggleStockAction, "directAccessShowStock");
        this.copyTableAction = this.tblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = this.tblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    final class LocalObjectFilter
    implements ObjectFilter {
        final Float8Field baseField;
        final ObjectFilter valueFilter;

        LocalObjectFilter(ByteRecordDescriptor byteRecordDescriptor) {
            this.baseField = byteRecordDescriptor.getValueBaseField();
            this.valueFilter = byteRecordDescriptor.getValueFilter();
        }

        @Override
        public Object filter(Object object) {
            if (DISPLAY_TYPE_FILTERED.equals(DirectAccessTableAdapter.this.getDisplayType())) {
                object = new Float(this.baseField.convertFromRawValue(((Number)object).intValue()));
                if (this.valueFilter != null) {
                    object = this.valueFilter.filter(object);
                }
            }
            return object;
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            if (DISPLAY_TYPE_FILTERED.equals(DirectAccessTableAdapter.this.getDisplayType())) {
                if (this.valueFilter != null) {
                    object = this.valueFilter.unfilter(object, object2);
                }
                object = new Float(this.baseField.convertToRawValue(((Number)object).floatValue()));
            }
            return object;
        }
    }

    class MyTableCellRenderer
    implements TableCellRenderer {
        final TableCellRenderer defaultRenderer;
        final ColorMapEntry[] colorMap;
        final List volatileList;
        final List persistedList;
        Font boldFont;
        Font standardFont;

        MyTableCellRenderer(TableCellRenderer tableCellRenderer, ColorMapEntry[] colorMapEntryArray) {
            this.defaultRenderer = tableCellRenderer;
            this.colorMap = colorMapEntryArray;
            this.volatileList = DirectAccessTableAdapter.this.model.mdlBytes.getLocalArrayListValue();
            this.persistedList = DirectAccessTableAdapter.this.model.mdlPersistedBytes.getLocalArrayListValue();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            Component component = this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.standardFont == null) {
                this.standardFont = component.getFont();
                this.boldFont = this.standardFont.deriveFont(1);
            }
            if (BindingUtils.equals(this.volatileList.get(n3 = DirectAccessTableAdapter.this.dataModelIndex(n2, n)), this.persistedList.get(n3))) {
                component.setFont(this.standardFont);
            } else {
                component.setFont(this.boldFont);
            }
            if (this.colorMap == null || !DISPLAY_TYPE_FILTERED.equals(DirectAccessTableAdapter.this.getDisplayType())) {
                if (!bl) {
                    component.setBackground(null);
                }
                if (DirectAccessTableAdapter.this.getTemplateVisible().booleanValue()) {
                    // empty if block
                }
            } else {
                float f = XFormatter.parse((String)object);
                Color color = ColorMapEntry.lookupColor(this.colorMap, f);
                Color color2 = Color.BLACK;
                if (bl) {
                    color = color.darker().darker();
                    color2 = Color.WHITE;
                } else if (DirectAccessTableAdapter.this.getTemplateVisible().booleanValue()) {
                    // empty if block
                }
                component.setBackground(color);
                component.setForeground(color2);
            }
            return component;
        }
    }
}

