/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptor;
import com.ecmtuning.ecmlink.device.records.ByteRecordDescriptorBase;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.InterpListValuesAction;
import com.ecmtuning.ecmlink.util.ui.InterpTableValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleListValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleTableValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetListValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetTableValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessListAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessModel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessSubPanel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessTableAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.AbstractView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

public class DirectAccessView
extends AbstractView {
    final DirectAccessModel model;
    final ByteRecordDescriptorBase baseDesc;
    final DirectAccessSubPanel parentSubPanel;
    JPanel componentPanel;
    final List adapters = new ArrayList();
    JTextArea taDesc;
    protected static final String STOCK_VALUES_HEADER_SUFFIX = " *** STOCK VALUES ***";
    Component defaultFocusComponent = null;

    public DirectAccessView(ByteRecordDescriptorBase byteRecordDescriptorBase, DirectAccessModel directAccessModel, DirectAccessSubPanel directAccessSubPanel) {
        this.model = directAccessModel;
        this.baseDesc = byteRecordDescriptorBase;
        this.parentSubPanel = directAccessSubPanel;
    }

    protected JComponent buildPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 3));
        boolean bl = this.model.descriptorModels.size() > 1;
        JComponent jComponent = this.buildCenterPanel(bl);
        jPanel.add((Component)jComponent, "Center");
        jPanel.add((Component)this.buildTextAreaAndPanel(bl), "South");
        if (!bl) {
            DirectAccessModel.DescriptorModel descriptorModel = (DirectAccessModel.DescriptorModel)this.model.descriptorModels.get(0);
            this.taDesc.setText(descriptorModel.descriptor.getDescText());
        } else {
            Iterator iterator = this.model.descriptorModels.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                DirectAccessModel.DescriptorModel descriptorModel = (DirectAccessModel.DescriptorModel)iterator.next();
                ByteRecordDescriptor byteRecordDescriptor = descriptorModel.descriptor;
                String string = byteRecordDescriptor.getBannerText() + " [" + byteRecordDescriptor.getListBoxName() + "]:\n";
                string = "******  [" + byteRecordDescriptor.getListBoxName() + "]  ******\n";
                stringBuffer.append(string);
                stringBuffer.append(byteRecordDescriptor.getDescText());
                if (!iterator.hasNext()) continue;
                stringBuffer.append("\n\n");
            }
            this.taDesc.setText(stringBuffer.toString());
            this.taDesc.setCaretPosition(0);
        }
        return jPanel;
    }

    private JComponent buildCenterPanel(boolean bl) {
        Object object;
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.ZERO, 1.0));
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        this.componentPanel = panelBuilder.getPanel();
        boolean bl2 = false;
        Iterator iterator = this.model.descriptorModels.iterator();
        while (iterator.hasNext()) {
            object = (DirectAccessModel.DescriptorModel)iterator.next();
            ByteRecordDescriptor byteRecordDescriptor = ((DirectAccessModel.DescriptorModel)object).descriptor;
            String string = byteRecordDescriptor.getListBoxName();
            String string2 = byteRecordDescriptor.getBannerText() + " [" + string + "]";
            JLabel jLabel = new JLabel(string2);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JComponent jComponent = this.buildDescriptorComponent((DirectAccessModel.DescriptorModel)object, jLabel, !bl);
            BaseTblDataAdapter baseTblDataAdapter = (BaseTblDataAdapter)((Object)this.adapters.get(this.adapters.size() - 1));
            panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
            panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
            CellConstraints cellConstraints = new CellConstraints(panelBuilder.getColumn(), panelBuilder.getRow());
            panelBuilder.nextLine(2);
            if (jComponent != null) {
                RowSpec rowSpec = DialogUtil.FILL_ZERO_GROW_ROWSPEC;
                if (bl) {
                    if (byteRecordDescriptor.isTableRecord()) {
                        rowSpec = DialogUtil.FILL_PREF_NOGROW_ROWSPEC;
                    } else {
                        bl2 = true;
                    }
                }
                panelBuilder.appendRow(rowSpec);
                panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
                CellConstraints cellConstraints2 = new CellConstraints(panelBuilder.getColumn(), panelBuilder.getRow());
                boolean bl3 = false;
                if (baseTblDataAdapter instanceof DirectAccessTableAdapter) {
                    DirectAccessTableAdapter directAccessTableAdapter = (DirectAccessTableAdapter)baseTblDataAdapter;
                    if (((DirectAccessModel.DescriptorModel)object).descriptor.hasTrackData()) {
                        directAccessTableAdapter.setDetachSupport(this.parentSubPanel, this.componentPanel, jComponent, cellConstraints2, string);
                        directAccessTableAdapter.addPopupAction(null);
                        directAccessTableAdapter.addPopupAction((Action)directAccessTableAdapter.getDetachedToggleAction());
                        directAccessTableAdapter.addPopupAction((Action)directAccessTableAdapter.getTrackDataToggleAction());
                        panelBuilder.add((Component)this.createHeaderPanel(jLabel, directAccessTableAdapter), cellConstraints);
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    panelBuilder.add((Component)jLabel, cellConstraints);
                }
                panelBuilder.add((Component)jComponent, cellConstraints2);
                panelBuilder.nextLine(2);
            }
            if (!bl || !iterator.hasNext()) continue;
            panelBuilder.appendParagraphGapRow();
            panelBuilder.nextLine();
        }
        if (bl && !bl2) {
            panelBuilder.appendGlueRow();
            panelBuilder.nextLine();
            object = new JScrollPane(this.componentPanel);
        } else {
            object = this.componentPanel;
        }
        return object;
    }

    private JComponent createHeaderPanel(JComponent jComponent, DirectAccessTableAdapter directAccessTableAdapter) {
        JToggleButton jToggleButton = BasicComponentFactory.createToggleButton((ValueModel)directAccessTableAdapter.mdlDetached, (String)"Detach");
        jToggleButton.setAction((Action)directAccessTableAdapter.getDetachedToggleAction());
        jToggleButton.setIcon(null);
        JToggleButton jToggleButton2 = BasicComponentFactory.createToggleButton((ValueModel)directAccessTableAdapter.mdlTrackData, (String)"Track");
        jToggleButton2.setAction((Action)directAccessTableAdapter.getTrackDataToggleAction());
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_GROW_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        formLayout.setColumnGroups((int[][])new int[][]{{2, 3}});
        panelBuilder.appendRow(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        panelBuilder.setColumn(1);
        panelBuilder.add((Component)jComponent);
        panelBuilder.nextColumn();
        panelBuilder.add((Component)jToggleButton);
        panelBuilder.nextColumn();
        panelBuilder.add((Component)jToggleButton2);
        return panelBuilder.getPanel();
    }

    private JComponent buildTextAreaAndPanel(boolean bl) {
        this.taDesc = new JTextArea();
        this.taDesc.setText("placeholder");
        this.taDesc.setLineWrap(true);
        this.taDesc.setWrapStyleWord(true);
        this.taDesc.setEditable(false);
        this.taDesc.setRows(bl ? 6 : 4);
        return new JScrollPane(this.taDesc);
    }

    protected JComponent buildDescriptorComponent(DirectAccessModel.DescriptorModel descriptorModel, JLabel jLabel, boolean bl) {
        ByteRecordDescriptor byteRecordDescriptor = descriptorModel.descriptor;
        if (byteRecordDescriptor.isListRecord()) {
            return this.buildListPanel(descriptorModel, jLabel, bl);
        }
        if (byteRecordDescriptor.isTableRecord()) {
            return this.buildTablePanel(descriptorModel, jLabel, bl);
        }
        return null;
    }

    protected JComponent buildListPanel(DirectAccessModel.DescriptorModel descriptorModel, JLabel jLabel, boolean bl) {
        Serializable serializable;
        DirectAccessListAdapter directAccessListAdapter = new DirectAccessListAdapter(descriptorModel);
        ByteRecordDescriptor byteRecordDescriptor = descriptorModel.descriptor;
        if (byteRecordDescriptor.doMenuSetValues()) {
            serializable = new InterpListValuesAction((JTable)((Object)directAccessListAdapter.getDataTable()));
            ECMLinkResources.configureAction(serializable, "interpTableValues");
            directAccessListAdapter.addPopupAction((Action)((Object)serializable));
            serializable = new SetListValuesAction((JTable)((Object)directAccessListAdapter.getDataTable()));
            ECMLinkResources.configureAction(serializable, "setTableValues");
            directAccessListAdapter.addPopupAction((Action)((Object)serializable));
            serializable = new ScaleListValuesAction((JTable)((Object)directAccessListAdapter.getDataTable()));
            ECMLinkResources.configureAction(serializable, "scaleTableValues");
            directAccessListAdapter.addPopupAction((Action)((Object)serializable));
            directAccessListAdapter.addPopupAction(null);
        }
        directAccessListAdapter.addPopupAction(this.parentSubPanel.getResetTabAction());
        directAccessListAdapter.addPopupAction(this.parentSubPanel.getSaveTabAction());
        this.adapters.add(directAccessListAdapter);
        serializable = directAccessListAdapter.buildPanel(bl);
        if (this.defaultFocusComponent == null) {
            this.defaultFocusComponent = directAccessListAdapter.getChartForFocus();
        }
        return serializable;
    }

    protected JComponent buildTablePanel(DirectAccessModel.DescriptorModel descriptorModel, final JLabel jLabel, boolean bl) {
        DirectAccessTableAdapter directAccessTableAdapter = new DirectAccessTableAdapter(descriptorModel);
        JComponent jComponent = directAccessTableAdapter.buildTable(bl);
        directAccessTableAdapter.getStockValuesVisibleHolder().addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                String string = jLabel.getText();
                if (bl) {
                    if (!string.endsWith(DirectAccessView.STOCK_VALUES_HEADER_SUFFIX)) {
                        jLabel.setText(string + DirectAccessView.STOCK_VALUES_HEADER_SUFFIX);
                    }
                } else if (string.endsWith(DirectAccessView.STOCK_VALUES_HEADER_SUFFIX)) {
                    jLabel.setText(string.substring(0, string.length() - DirectAccessView.STOCK_VALUES_HEADER_SUFFIX.length()));
                }
            }
        });
        ByteRecordDescriptor byteRecordDescriptor = descriptorModel.descriptor;
        if (byteRecordDescriptor.doMenuSetValues() && (byteRecordDescriptor.getXSize() > 6 || byteRecordDescriptor.getYSize() > 6)) {
            AbstractAction abstractAction;
            if (byteRecordDescriptor.hasTrackData()) {
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), byteRecordDescriptor.getTrackXValues(), byteRecordDescriptor.getTrackYValues(), true, true);
                ECMLinkResources.configureAction(abstractAction, "interpTableValues");
                directAccessTableAdapter.addPopupAction(abstractAction);
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), byteRecordDescriptor.getTrackXValues(), byteRecordDescriptor.getTrackYValues(), true, false);
                ECMLinkResources.configureAction(abstractAction, "interpTableRows");
                directAccessTableAdapter.addPopupAction(abstractAction);
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), byteRecordDescriptor.getTrackXValues(), byteRecordDescriptor.getTrackYValues(), false, true);
                ECMLinkResources.configureAction(abstractAction, "interpTableColumns");
                directAccessTableAdapter.addPopupAction(abstractAction);
            } else {
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), directAccessTableAdapter.getRowHeaderTable(), true, true);
                ECMLinkResources.configureAction(abstractAction, "interpTableValues");
                directAccessTableAdapter.addPopupAction(abstractAction);
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), directAccessTableAdapter.getRowHeaderTable(), true, false);
                ECMLinkResources.configureAction(abstractAction, "interpTableRows");
                directAccessTableAdapter.addPopupAction(abstractAction);
                abstractAction = new InterpTableValuesAction(directAccessTableAdapter.getDataTable(), directAccessTableAdapter.getRowHeaderTable(), false, true);
                ECMLinkResources.configureAction(abstractAction, "interpTableColumns");
                directAccessTableAdapter.addPopupAction(abstractAction);
            }
            abstractAction = new SetTableValuesAction((JTable)((Object)directAccessTableAdapter.getDataTable()));
            ECMLinkResources.configureAction(abstractAction, "setTableValues");
            directAccessTableAdapter.addPopupAction(abstractAction);
            abstractAction = new ScaleTableValuesAction((JTable)((Object)directAccessTableAdapter.getDataTable()));
            ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
            directAccessTableAdapter.addPopupAction(abstractAction);
            directAccessTableAdapter.addPopupAction(null);
        }
        directAccessTableAdapter.addPopupAction(this.parentSubPanel.getResetTabAction());
        directAccessTableAdapter.addPopupAction(this.parentSubPanel.getSaveTabAction());
        this.adapters.add(directAccessTableAdapter);
        if (this.defaultFocusComponent == null) {
            this.defaultFocusComponent = directAccessTableAdapter.getDataTable();
        }
        return jComponent;
    }

    public void setStockValuesVisible(Boolean bl) {
        for (BaseTblDataAdapter baseTblDataAdapter : this.adapters) {
            if (baseTblDataAdapter instanceof DirectAccessTableAdapter) {
                ((DirectAccessTableAdapter)baseTblDataAdapter).getStockValuesVisibleHolder().setValue((Object)bl);
                continue;
            }
            if (!(baseTblDataAdapter instanceof DirectAccessListAdapter)) continue;
            ((DirectAccessListAdapter)baseTblDataAdapter).getStockValuesVisibleHolder().setValue((Object)bl);
        }
    }

    public ValueModel getStockValuesVisibleModel() {
        if (this.adapters.size() == 1) {
            BaseTblDataAdapter baseTblDataAdapter = (BaseTblDataAdapter)((Object)this.adapters.get(0));
            if (baseTblDataAdapter instanceof DirectAccessTableAdapter) {
                return ((DirectAccessTableAdapter)baseTblDataAdapter).getStockValuesVisibleHolder();
            }
            if (baseTblDataAdapter instanceof DirectAccessListAdapter) {
                return ((DirectAccessListAdapter)baseTblDataAdapter).getStockValuesVisibleHolder();
            }
        }
        return null;
    }

    void dropView() {
        for (BaseTblDataAdapter baseTblDataAdapter : this.adapters) {
            if (!(baseTblDataAdapter instanceof DirectAccessTableAdapter)) continue;
            DirectAccessTableAdapter directAccessTableAdapter = (DirectAccessTableAdapter)baseTblDataAdapter;
            directAccessTableAdapter.setTrackData(false);
            directAccessTableAdapter.setDetached(false);
        }
    }

    Component getDefaultFocusComponent() {
        return this.defaultFocusComponent;
    }
}

