/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.IntRangeValidator;
import com.ecmtuning.ecmlink.view.main.AbstractConfigDialog;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ECMLinkConfigDialog
extends AbstractConfigDialog {
    private JComboBox ecuTypeComboBox;
    private DefaultComboBoxModel ecuTypeComboModel;
    private JTextField byteDelayTextField;
    private JTextField timeoutTextField;
    private ECMLinkDeviceManager deviceManager;
    private static final int[] deviceListIds = new int[]{3, 4, 5, 1, 2};
    private static ECMLinkConfigDialog dialog;
    private static ECMLinkDeviceManager dialogManager;

    private ECMLinkConfigDialog(Frame frame, ECMLinkDeviceManager eCMLinkDeviceManager) {
        super(frame, eCMLinkDeviceManager);
        this.deviceManager = eCMLinkDeviceManager;
    }

    public static synchronized ECMLinkConfigDialog getInstance(Frame frame, ECMLinkDeviceManager eCMLinkDeviceManager) {
        if (dialog == null || eCMLinkDeviceManager != dialogManager) {
            dialog = new ECMLinkConfigDialog(frame, eCMLinkDeviceManager);
            dialogManager = eCMLinkDeviceManager;
        }
        return dialog;
    }

    @Override
    protected String getConfigDialogTitle() {
        return "ECMLink Connection Settings";
    }

    @Override
    protected String getHelpID() {
        return "ecmlink.connectionsettings";
    }

    @Override
    protected void updateView() {
        this.ecuTypeComboBox.setSelectedItem(ECMLinkDeviceMap.getListDisplayName(this.deviceManager.getConfiguredDeviceListId()));
        this.byteDelayTextField.setText(Long.toString(this.deviceManager.getByteDelayMillis()));
        this.timeoutTextField.setText(Long.toString(this.deviceManager.getCmdTimeoutMillis()));
        super.updateView();
    }

    @Override
    protected void updateModel() {
        this.deviceManager.setConfiguredDeviceListId(deviceListIds[this.ecuTypeComboBox.getSelectedIndex()]);
        this.deviceManager.setByteDelayMillis(Long.parseLong(this.byteDelayTextField.getText()));
        this.deviceManager.setCmdTimeoutMillis(Long.parseLong(this.timeoutTextField.getText()));
        super.updateModel();
    }

    @Override
    protected void initComponents() {
        this.ecuTypeComboModel = new DefaultComboBoxModel();
        for (int i = 0; i < deviceListIds.length; ++i) {
            this.ecuTypeComboModel.addElement(ECMLinkDeviceMap.getListDisplayName(deviceListIds[i]));
        }
        this.ecuTypeComboBox = new JComboBox();
        this.ecuTypeComboBox.setModel(this.ecuTypeComboModel);
        this.ecuTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                int n = deviceListIds[jComboBox.getSelectedIndex()];
                if (ECMLinkDeviceMap.isV3List(n)) {
                    ECMLinkConfigDialog.this.byteDelayTextField.setText("0");
                } else {
                    ECMLinkConfigDialog.this.byteDelayTextField.setText("30");
                }
            }
        });
        this.byteDelayTextField = new JTextField(5);
        new IntRangeValidator(this.byteDelayTextField, 0, 100);
        this.byteDelayTextField.setHorizontalAlignment(4);
        this.byteDelayTextField.setToolTipText("Delay between bytes; default: 30ms for V1/V2, 0ms for V3");
        this.timeoutTextField = new JTextField(5);
        new IntRangeValidator(this.timeoutTextField, 300, 1500);
        this.timeoutTextField.setHorizontalAlignment(4);
        this.timeoutTextField.setToolTipText("Time to wait for a reply; default: 300ms");
        super.initComponents();
    }

    @Override
    protected JPanel buildAdvancedPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Advanced", cellConstraints.xyw(1, n, 6));
        panelBuilder.addLabel("Byte delay:", cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.byteDelayTextField, cellConstraints.xy(4, n));
        panelBuilder.addLabel("ms", cellConstraints.xy(6, n));
        panelBuilder.addLabel("Timeout:", cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)this.timeoutTextField, cellConstraints.xy(4, n));
        panelBuilder.addLabel("ms", cellConstraints.xy(6, n));
        return panelBuilder.getPanel();
    }

    @Override
    protected Component getECUTypeComponent() {
        return this.ecuTypeComboBox;
    }
}

