/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ComboMap;
import com.ecmtuning.ecmlink.util.model.Integer2ComboFilter;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ECUIORecordModel
extends RecordModel {
    private static final String DISPLAY_NAME_UNDEFINED = "Undefined";
    ValueModelPlug mdlMAPInputX;
    ValueModelPlug mdlWBInputX;
    ComboMap[] inputXComboValues;
    ValueModelPlug mdlMAPSelect;
    ValueModelPlug mdlMAPScale;
    ValueModelPlug mdlMAPOffset;
    ValueModel mdlLockIATBaro;
    ValueModel mdlLockFrontO2;
    ValueModel mdlLockCoolant;
    ValueModel mdlLockMDP;
    ValueModel mdlLockRearO2;
    ValueModel mdlLockEGRT;
    boolean hasAliasAssignments = false;
    int deviceId = 0;
    int serialNum = 0;
    ECMLinkConfigRecordSet rs = null;
    Object bitsRecordId;
    ComboMap[] inputX1GMap = new ComboMap[]{new ComboMap(0, "Undefined"), new ComboMap(1, "Intake temp"), new ComboMap(2, "Baro"), new ComboMap(3, "Front O2"), new ComboMap(4, "Coolant temp"), new ComboMap(7, "EGR Temp")};
    ComboMap[] inputXE3Map = new ComboMap[]{new ComboMap(0, "Undefined"), new ComboMap(1, "Intake temp"), new ComboMap(2, "Baro"), new ComboMap(3, "Front O2"), new ComboMap(4, "Coolant temp"), new ComboMap(7, "Exh Temp")};
    ComboMap[] inputX2GMap = new ComboMap[]{new ComboMap(0, "Undefined"), new ComboMap(1, "Intake temp"), new ComboMap(2, "Baro"), new ComboMap(3, "Front O2"), new ComboMap(5, "Rear O2"), new ComboMap(4, "Coolant temp"), new ComboMap(6, "MDP")};
    ComboMap[] mapSelectMap = new ComboMap[]{new ComboMap(0, "Undefined"), new ComboMap(1, "GM 3 bar"), new ComboMap(2, "GM 3.3 bar"), new ComboMap(3, "AEM 3.5 bar"), new ComboMap(4, "AEM 5 bar"), new ComboMap(5, "Omni Power 3 bar"), new ComboMap(6, "Omni Power 4 bar"), new ComboMap(127, "User defined")};

    ECUIORecordModel(RecordSet recordSet) {
        if (recordSet instanceof ECMLinkConfigRecordSet) {
            this.rs = (ECMLinkConfigRecordSet)recordSet;
            this.deviceId = this.rs.getDeviceId();
            this.serialNum = this.rs.getSerialNum();
            this.hasAliasAssignments = true;
            this.inputXComboValues = ECMLinkDeviceMap.is1GDSMDevice(this.deviceId) ? this.inputX1GMap : (ECMLinkDeviceMap.isEVO3Device(this.deviceId) ? this.inputXE3Map : this.inputX2GMap);
        }
        this.initialize(recordSet);
    }

    List getCurrentAliasAssignments() {
        if (this.rs == null) {
            return Collections.EMPTY_LIST;
        }
        return this.rs.getAliasAssignments();
    }

    @Override
    protected void initAndTrackModels(Map map) {
        Integer2ComboFilter integer2ComboFilter;
        ValueModelPlug valueModelPlug;
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        this.bitsRecordId = baseRecord.getRecordID();
        if (baseRecord.hasFeature("mapInputX")) {
            valueModelPlug = baseRecord.getFeaturePlug("mapInputX");
            integer2ComboFilter = new Integer2ComboFilter(0, this.inputXComboValues[0]);
            integer2ComboFilter.addValidCombos(this.inputXComboValues);
            valueModelPlug.addObjectFilter(integer2ComboFilter);
            this.mdlMAPInputX = this.track(this.mdlMAPInputX, valueModelPlug);
        }
        if (baseRecord.hasFeature("wbInputX")) {
            valueModelPlug = baseRecord.getFeaturePlug("wbInputX");
            integer2ComboFilter = new Integer2ComboFilter(0, this.inputXComboValues[0]);
            integer2ComboFilter.addValidCombos(this.inputXComboValues);
            valueModelPlug.addObjectFilter(integer2ComboFilter);
            this.mdlWBInputX = this.track(this.mdlWBInputX, valueModelPlug);
        }
        if (baseRecord.hasFeature("mapSelectFeature")) {
            valueModelPlug = baseRecord.getFeaturePlug("mapSelectFeature");
            integer2ComboFilter = new Integer2ComboFilter(0, this.mapSelectMap[0]);
            integer2ComboFilter.addValidCombos(this.mapSelectMap);
            valueModelPlug.addObjectFilter(integer2ComboFilter);
            this.mdlMAPSelect = this.track(this.mdlMAPSelect, valueModelPlug);
            this.mdlMAPScale = this.track(this.mdlMAPScale, baseRecord.numberFieldAsInteger("MAPScale"));
            this.mdlMAPOffset = this.track(this.mdlMAPOffset, baseRecord.numberFieldAsInteger("MAPOffset"));
        }
        if ((valueModelPlug = baseRecord.getFeaturePlug("lockIATBaro")) == null) {
            valueModelPlug = baseRecord.getFeaturePlug("freezeCtl");
        }
        this.mdlLockIATBaro = this.track(this.mdlLockIATBaro, (UnpluggableValueModel)valueModelPlug);
        this.mdlLockMDP = this.track(this.mdlLockMDP, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockMDP"));
        this.mdlLockRearO2 = this.track(this.mdlLockRearO2, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockRearO2"));
        this.mdlLockFrontO2 = this.track(this.mdlLockFrontO2, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockFrontO2"));
        this.mdlLockEGRT = this.track(this.mdlLockEGRT, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockEGRT"));
        this.mdlLockCoolant = this.track(this.mdlLockCoolant, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockCoolant"));
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        return baseRecord != null && BindingUtils.equals((Object)baseRecord.getRecordID(), (Object)this.bitsRecordId);
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
    }
}

