/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.data.AliasAssignment;
import com.ecmtuning.ecmlink.device.data.AliasCandidate;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.LocationAlias;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV7Record;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ComboMap;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ListBasedTableModel;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.util.ui.TextSelectionTableCellEditor;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIORecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellEditor;

public class ECUIORecordView
extends AbstractRecordView {
    private JCheckBox cbLockIATBaro;
    private JCheckBox cbLockMDP;
    private JCheckBox cbLockRearO2;
    private JCheckBox cbLockFrontO2;
    private JCheckBox cbLockEGRT;
    private JCheckBox cbLockCoolant;
    private JButton btnSavePins;
    private JButton btnResetPins;
    private JButton btnEditCapturedValues;
    private JComboBox comboMAPInputX;
    private JComboBox comboWBInputX;
    private JComboBox comboMAPSelect;
    private JSpinner spnrMAPScale;
    private JSpinner spnrMAPOffset;
    private Float8Field mapScalePsiPerVolts = new Float8Field(0.0913242f, 0.0f, 23.287672f, 0.0f);
    private Float8Field mapOffsetVolts = new Float8Field(0.019607844f, 0.0f, 5.0f, -2.509804f);
    private final ECUIORecordModel model;
    HandyJTable tblAssignments;
    JComboBox aliasCombo;
    protected ArrayListModel inputPinListModel;
    protected ArrayListModel connectedSensorListModel;
    protected ArrayListModel displayNameListModel;
    protected ArrayListModel descListModel;
    protected List lastSavedConnectedSensorList;
    protected List lastSavedDisplayNameList;
    protected List lastSavedDescList;
    protected List aliasCandidates;
    protected List allAliases;
    protected String[] allAliasesStrs;
    protected String STOCK_LIST_ITEM;
    private static final Logger logger = Logger.getLogger(ECUIOTab.class.getName());
    ListDataListener connectedSensorListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (ECUIORecordView.this.tblAssignments == null || ECUIORecordView.this.aliasCombo == null || listDataEvent.getIndex0() != listDataEvent.getIndex1()) {
                return;
            }
            int n = ECUIORecordView.this.aliasCombo.getSelectedIndex();
            int n2 = listDataEvent.getIndex0();
            if (n2 < 0) {
                return;
            }
            if (n == 0) {
                ECUIORecordView.this.displayNameListModel.set(n2, (Object)"");
                ECUIORecordView.this.descListModel.set(n2, (Object)"");
                return;
            }
            LocationAlias locationAlias = (LocationAlias)ECUIORecordView.this.allAliases.get(--n);
            ECUIORecordView.this.descListModel.set(n2, (Object)locationAlias.getDescription());
            ECUIORecordView.this.displayNameListModel.set(n2, (Object)"");
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    };
    ListDataListener dirtyPinsListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            ECUIORecordView.this.setSaveResetEnabled();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    };
    boolean liveView = false;
    PropertyChangeListener userMAPListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = ECUIORecordView.this.mapScalePsiPerVolts.convertToRawValue(ECUIORecordView.this.mapScalePsiPerVolts.floatValue());
            int n2 = ECUIORecordView.this.mapOffsetVolts.convertToRawValue(ECUIORecordView.this.mapOffsetVolts.floatValue());
            ((ECUIORecordView)ECUIORecordView.this).model.mdlMAPScale.setValue(new Float(n));
            ((ECUIORecordView)ECUIORecordView.this).model.mdlMAPOffset.setValue(new Float(n2 - 128));
        }
    };
    PropertyChangeListener ecuMAPListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = ((Number)((ECUIORecordView)ECUIORecordView.this).model.mdlMAPScale.getValue()).intValue();
            int n2 = ((Number)((ECUIORecordView)ECUIORecordView.this).model.mdlMAPOffset.getValue()).intValue() + 128;
            ECUIORecordView.this.mapScalePsiPerVolts.setValue(ECUIORecordView.this.mapScalePsiPerVolts.convertFromRawValue(n));
            ECUIORecordView.this.mapOffsetVolts.setValue(ECUIORecordView.this.mapOffsetVolts.convertFromRawValue(n2));
        }
    };
    PropertyChangeListener mapSelectEnabler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboMap comboMap = (ComboMap)((ECUIORecordView)ECUIORecordView.this).model.mdlMAPInputX.getValue();
            ECUIORecordView.this.comboMAPSelect.setEnabled(comboMap.getIntValue() != 0);
            if (ECUIORecordView.this.spnrMAPScale != null) {
                if (!ECUIORecordView.this.comboMAPSelect.isEnabled()) {
                    ECUIORecordView.this.spnrMAPOffset.setEnabled(false);
                    ECUIORecordView.this.spnrMAPScale.setEnabled(false);
                } else {
                    comboMap = (ComboMap)((ECUIORecordView)ECUIORecordView.this).model.mdlMAPSelect.getValue();
                    boolean bl = comboMap.getIntValue() == 127;
                    ECUIORecordView.this.spnrMAPOffset.setEnabled(bl);
                    ECUIORecordView.this.spnrMAPScale.setEnabled(bl);
                }
            }
        }
    };
    PropertyChangeListener mapSelectUpdater = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComboMap comboMap = (ComboMap)((ECUIORecordView)ECUIORecordView.this).model.mdlMAPSelect.getValue();
            if (comboMap.getIntValue() != 127) {
                ((ECUIORecordView)ECUIORecordView.this).model.mdlMAPScale.setValue(MiscBitsV7Record.getMAPScaleValue(comboMap.getIntValue()));
                ((ECUIORecordView)ECUIORecordView.this).model.mdlMAPOffset.setValue(MiscBitsV7Record.getMAPOffsetValue(comboMap.getIntValue()));
                if (ECUIORecordView.this.spnrMAPScale != null) {
                    ECUIORecordView.this.spnrMAPScale.setEnabled(false);
                    ECUIORecordView.this.spnrMAPOffset.setEnabled(false);
                }
            } else if (ECUIORecordView.this.spnrMAPScale != null) {
                ECUIORecordView.this.spnrMAPScale.setEnabled(true);
                ECUIORecordView.this.spnrMAPOffset.setEnabled(true);
            }
        }
    };
    AbstractAction saveBtnAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ECUIORecordView.this.saveLocalModelToPrefs();
            if (OptionalMessageDialog.isShowingMsg("inputpin.saveconfirm.msg")) {
                OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "inputpin.saveconfirm.msg", ECMLinkResources.getResourceBundle());
                optionalMessageDialog.setDoCancel(false);
                DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            }
        }
    };
    AbstractAction resetBtnAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ECUIORecordView.this.loadLocalModelFromPrefs();
        }
    };

    public ECUIORecordView(ECUIORecordModel eCUIORecordModel) {
        int n;
        this.model = eCUIORecordModel;
        if (ECMLinkResources.resourceBundle == null) {
            throw new IllegalStateException("ResourceBundle for '" + ECMLinkResources.class.getName() + "' failed to load");
        }
        this.STOCK_LIST_ITEM = ECMLinkResources.getString("inputpin.factory.listitem");
        this.aliasCandidates = eCUIORecordModel.hasAliasAssignments ? new ArrayList(DataManager.getAliasCandidates(eCUIORecordModel.deviceId)) : new ArrayList();
        Collections.sort(this.aliasCandidates, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((AliasCandidate)object).getDisplayName().compareTo(((AliasCandidate)object2).getDisplayName());
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>();
        this.inputPinListModel = new ArrayListModel();
        Iterator iterator = this.aliasCandidates.iterator();
        while (iterator.hasNext()) {
            arrayList.add("");
            AliasCandidate aliasCandidate = (AliasCandidate)iterator.next();
            this.inputPinListModel.add((Object)aliasCandidate.getDisplayName());
        }
        this.connectedSensorListModel = new ArrayListModel(arrayList);
        this.displayNameListModel = new ArrayListModel(arrayList);
        this.descListModel = new ArrayListModel(arrayList);
        this.allAliases = new ArrayList(DataManager.getLocationAliases("5v"));
        Collections.sort(this.allAliases, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((LocationAlias)object).getSelectionName().compareTo(((LocationAlias)object2).getSelectionName());
            }
        });
        this.allAliasesStrs = new String[this.allAliases.size() + 1];
        this.allAliasesStrs[0] = this.STOCK_LIST_ITEM;
        for (n = 1; n < this.allAliasesStrs.length; ++n) {
            this.allAliasesStrs[n] = ((LocationAlias)this.allAliases.get(n - 1)).getSelectionName();
        }
        for (n = 0; n < this.allAliasesStrs.length; ++n) {
            for (int i = n + 1; i < this.allAliasesStrs.length; ++i) {
                if (!this.allAliasesStrs[n].equals(this.allAliasesStrs[i])) continue;
                logger.warning("Found duplicate alias selection text: '" + this.allAliasesStrs[n] + "'");
            }
        }
        this.connectedSensorListModel.addListDataListener(this.connectedSensorListDataListener);
        this.loadLocalModelFromPrefs();
    }

    synchronized void setLiveView(boolean bl) {
        this.liveView = bl;
        if (this.tblAssignments != null) {
            this.tblAssignments.setEnabled(this.liveView);
        }
        this.setSaveResetEnabled();
        if (this.btnEditCapturedValues != null) {
            this.btnEditCapturedValues.setEnabled(this.liveView);
        }
    }

    private void setSaveResetEnabled() {
        if (this.btnSavePins != null && this.btnResetPins != null) {
            boolean bl = this.liveView && this.isInputPinsDirty();
            this.btnSavePins.setEnabled(bl);
            this.btnResetPins.setEnabled(bl);
        }
    }

    private boolean isInputPinsDirty() {
        if (this.lastSavedConnectedSensorList == null) {
            return false;
        }
        return !this.lastSavedConnectedSensorList.equals(this.connectedSensorListModel) || !this.lastSavedDisplayNameList.equals(this.displayNameListModel) || !this.lastSavedDescList.equals(this.descListModel);
    }

    synchronized void loadLocalModelFromPrefs() {
        if (!this.model.hasAliasAssignments) {
            return;
        }
        List list = this.model.getCurrentAliasAssignments();
        Iterator iterator = this.aliasCandidates.iterator();
        int n = -1;
        while (iterator.hasNext()) {
            ++n;
            AliasCandidate aliasCandidate = (AliasCandidate)iterator.next();
            AliasAssignment aliasAssignment = DataManager.findAssignmentOfLocation(list, aliasCandidate.getCandidateLocation());
            if (aliasAssignment != null) {
                this.connectedSensorListModel.set(n, (Object)aliasAssignment.getAlias().getSelectionName());
                this.displayNameListModel.set(n, (Object)BasicStrings.blankIfEmpty(aliasAssignment.getDisplayNameOverride()));
                this.descListModel.set(n, (Object)BasicStrings.blankIfEmpty(aliasAssignment.getDescriptionOverride()));
                continue;
            }
            this.connectedSensorListModel.set(n, (Object)this.STOCK_LIST_ITEM);
            this.displayNameListModel.set(n, (Object)"");
            this.descListModel.set(n, (Object)"");
        }
        if (this.lastSavedConnectedSensorList == null) {
            this.recordLastSavedLists();
            this.connectedSensorListModel.addListDataListener(this.dirtyPinsListener);
            this.displayNameListModel.addListDataListener(this.dirtyPinsListener);
            this.descListModel.addListDataListener(this.dirtyPinsListener);
        }
    }

    private void recordLastSavedLists() {
        this.lastSavedConnectedSensorList = new ArrayList(this.connectedSensorListModel);
        this.lastSavedDisplayNameList = new ArrayList(this.displayNameListModel);
        this.lastSavedDescList = new ArrayList(this.descListModel);
        this.setSaveResetEnabled();
    }

    protected synchronized void saveLocalModelToPrefs() {
        if (!this.model.hasAliasAssignments) {
            return;
        }
        ArrayList<AliasAssignment> arrayList = new ArrayList<AliasAssignment>();
        Object[] objectArray = new String[this.allAliasesStrs.length - 1];
        System.arraycopy(this.allAliasesStrs, 1, objectArray, 0, objectArray.length);
        for (int i = 0; i < this.connectedSensorListModel.size(); ++i) {
            String string = (String)this.connectedSensorListModel.get(i);
            if (this.STOCK_LIST_ITEM.equals(string)) continue;
            int n = Arrays.binarySearch(objectArray, string);
            if (n >= 0) {
                AliasCandidate aliasCandidate = (AliasCandidate)this.aliasCandidates.get(i);
                LocationAlias locationAlias = (LocationAlias)this.allAliases.get(n);
                String string2 = BasicStrings.nullIfEmpty((String)this.displayNameListModel.get(i));
                String string3 = BasicStrings.nullIfEmpty((String)this.descListModel.get(i));
                AliasAssignment aliasAssignment = new AliasAssignment(this.model.deviceId, this.model.serialNum, aliasCandidate.getCandidateLocation(), locationAlias, string2, string3);
                arrayList.add(aliasAssignment);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("New alias assignment, " + aliasAssignment.toString());
                continue;
            }
            logger.warning(string + " not found in list of valid sensors; ignoring this input assignment.");
        }
        DataManager.setAliasAssignments(this.model.deviceId, this.model.serialNum, arrayList);
        this.recordLastSavedLists();
    }

    private void initComponents() {
        this.cbLockIATBaro = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockIATBaro, (String)"Lock intake temperature and barometric pressure");
        this.cbLockIATBaro.setToolTipText("Locks IAT and baro seen by factory ECU code to 80F(27C) and sealevel, respectively");
        if (this.model.mdlLockFrontO2 != null) {
            this.cbLockFrontO2 = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockFrontO2, (String)"Lock front O2 voltage");
            this.cbLockFrontO2.setToolTipText("Locks FrontO2 voltage seen by factory ECU code at 0.5v");
        }
        if (this.model.mdlLockCoolant != null) {
            this.cbLockCoolant = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockCoolant, (String)"Lock coolant temperature");
            this.cbLockCoolant.setToolTipText("Locks Coolant temperatue seen by factory ECU code at 227F(108C)");
        }
        if (this.model.mdlLockEGRT != null) {
            this.cbLockEGRT = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockEGRT, (String)"Lock EGR temperature");
            this.cbLockEGRT.setToolTipText("Locks EGR temperatue seen by factory ECU code to a fixed value");
        }
        if (this.model.mdlLockMDP != null && this.model.mdlLockRearO2 != null) {
            this.cbLockMDP = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockMDP, (String)"Lock manifold differential pressure (MDP)");
            this.cbLockMDP.setToolTipText("Locks MDP seen by factory ECU code to a fixed value");
            this.cbLockRearO2 = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockRearO2, (String)"Lock rear O2 voltage");
            this.cbLockRearO2.setToolTipText("Locks RearO2 voltage seen by factory ECU code at 0.5v");
        }
        if (this.model.mdlMAPInputX != null) {
            this.comboMAPInputX = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList((Object[])this.model.inputXComboValues, (ValueModel)this.model.mdlMAPInputX));
            this.comboMAPInputX.setToolTipText("Tells ECMLink functions where to find a manifold pressure sensor");
        }
        if (this.model.mdlWBInputX != null) {
            this.comboWBInputX = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList((Object[])this.model.inputXComboValues, (ValueModel)this.model.mdlWBInputX));
            this.comboWBInputX.setToolTipText("Tells ECMLink functions where to find a wideband signal");
        }
        if (this.model.mdlMAPSelect != null) {
            this.comboMAPSelect = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList((Object[])this.model.mapSelectMap, (ValueModel)this.model.mdlMAPSelect));
            this.comboMAPSelect.setToolTipText("Defines scaling for Speed Density operation.  Also defines offset for MAFClamp.");
            ArrayList<Number2StringFilter> arrayList = new ArrayList<Number2StringFilter>();
            arrayList.add(new Number2StringFilter(3));
            ValueModelPlug valueModelPlug = new ValueModelPlug((ValueModel)this.mapScalePsiPerVolts, arrayList);
            UnitsHelper.installFilter(valueModelPlug, "typeAbsoluteAirFromPSIA");
            ValueModelPlug valueModelPlug2 = new ValueModelPlug((ValueModel)this.mapOffsetVolts, arrayList);
            this.spnrMAPScale = DialogUtil.createSpinnerTextField(valueModelPlug, "Pressure per volt scaling of this sensor.");
            this.spnrMAPOffset = DialogUtil.createSpinnerTextField(valueModelPlug2, "Sensor output voltage that represents 0 absolute pressure.");
            this.mapScalePsiPerVolts.addValueChangeListener(this.userMAPListener);
            this.mapOffsetVolts.addValueChangeListener(this.userMAPListener);
            this.model.mdlMAPScale.addValueChangeListener(this.ecuMAPListener);
            this.model.mdlMAPInputX.addValueChangeListener(this.mapSelectEnabler);
            this.mapSelectEnabler.propertyChange(null);
            this.model.mdlMAPSelect.addValueChangeListener(this.mapSelectUpdater);
            this.mapSelectUpdater.propertyChange(null);
            this.model.mdlMAPOffset.addValueChangeListener(this.ecuMAPListener);
            this.ecuMAPListener.propertyChange(null);
        }
        ECMLinkResources.configureAction(this.saveBtnAction, "inputpin.save");
        ECMLinkResources.configureAction(this.resetBtnAction, "inputpin.reset");
        this.btnSavePins = new JButton(this.saveBtnAction);
        this.btnResetPins = new JButton(this.resetBtnAction);
        this.btnEditCapturedValues = new JButton(MainActions.getAction("capturedValues"));
    }

    protected synchronized JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.FILL_DEFAULT_GROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRows(prefRowSpec, interSectGap);
        panelBuilder.add((Component)this.buildInputPinPanel());
        panelBuilder.nextLine(2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        if (this.model.mdlMAPInputX != null || this.model.mdlWBInputX != null) {
            panelBuilder.add((Component)this.buildFuncsLocksPanel());
        } else {
            panelBuilder.add((Component)this.buildInputLocksPanel());
        }
        panelBuilder.nextLine(2);
        this.setLiveView(this.liveView);
        return panelBuilder.getPanel();
    }

    protected JComponent buildInputPinPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC, rowSpec);
        ListUtil.add(arrayList2, prefRowSpec, interCompGap);
        ListUtil.add(arrayList2, prefRowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        String string = "NONE";
        if (this.model.hasAliasAssignments) {
            string = DeviceMap.getDeviceDisplayName(this.model.deviceId);
        }
        String string2 = ECMLinkResources.getString("inputpin.header", new Object[]{string});
        panelBuilder.addSeparator(string2);
        JComponent jComponent = this.buildTablePanel();
        if (jComponent != null) {
            jComponent.setBorder(new EmptyBorder(0, 5, 0, 5));
            panelBuilder.add((Component)new JScrollPane(jComponent), cellConstraints.xy(1, 3));
        }
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGridded((JComponent)this.btnSavePins);
        buttonBarBuilder.addGridded((JComponent)this.btnResetPins);
        buttonBarBuilder.addGridded((JComponent)this.btnEditCapturedValues);
        panelBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    protected JComponent buildTablePanel() {
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && n < ECUIORecordView.this.inputPinListModel.size();
            }
        };
        listBasedTableModel.setMinimumRowCount(1);
        listBasedTableModel.addColumn(ECMLinkResources.getString("inputpin.inputpin.columnheader"), (ListModel)this.inputPinListModel);
        listBasedTableModel.addColumn(ECMLinkResources.getString("inputpin.sensor.columnheader"), (ListModel)this.connectedSensorListModel);
        listBasedTableModel.addColumn(ECMLinkResources.getString("inputpin.displayname.columnheader"), (ListModel)this.displayNameListModel);
        listBasedTableModel.addColumn(ECMLinkResources.getString("inputpin.desc.columnheader"), (ListModel)this.descListModel);
        this.aliasCombo = new JComboBox<String>(this.allAliasesStrs);
        this.tblAssignments = new HandyJTable(listBasedTableModel);
        this.tblAssignments.setAutoResizeMode(3);
        this.tblAssignments.setUsePreferredSizeAsScrollSize(true);
        this.tblAssignments.setEnabled(true);
        this.tblAssignments.setCellSelectionEnabled(true);
        this.tblAssignments.setColumnSelectionAllowed(true);
        this.tblAssignments.setRowSelectionAllowed(true);
        this.tblAssignments.setSelectionMode(0);
        this.tblAssignments.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.aliasCombo));
        TableCellEditor tableCellEditor = this.tblAssignments.getDefaultEditor(Object.class);
        this.tblAssignments.setDefaultEditor(Object.class, new TextSelectionTableCellEditor(tableCellEditor));
        this.tblAssignments.setColumnWidthFromProto(0, (List)this.inputPinListModel);
        this.tblAssignments.setColumnWidthFromProto(1, this.allAliasesStrs);
        this.tblAssignments.setColumnWidthFromProto(2, "XXXXXXXXXXXXX");
        this.tblAssignments.setColumnWidthFromProto(3, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.tblAssignments.padColumnWidths(8);
        return this.tblAssignments;
    }

    private JComponent buildFuncsLocksPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.TOP_PREF_NOGROW_ROWSPEC);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildFunctionsPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildInputLocksPanel(), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JComponent buildFunctionsPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRow(interCompGap);
        panelBuilder.nextLine();
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Pin Assignments for ECMLink Functions (ECU-side)");
        panelBuilder.nextLine(2, 2);
        if (this.comboMAPInputX != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.addLabel("Manifold pressure (MAP):");
            panelBuilder.nextColumn(2);
            panelBuilder.add((Component)this.comboMAPInputX);
            panelBuilder.nextColumn(2);
            panelBuilder.addLabel("(used for MAF Clamp/SD)");
            panelBuilder.nextLine(2, 2);
            if (this.comboMAPSelect != null) {
                panelBuilder.appendRows(prefRowSpec, interCompGap);
                panelBuilder.addLabel("");
                panelBuilder.nextColumn(2);
                panelBuilder.add((Component)this.comboMAPSelect);
                panelBuilder.nextColumn(2);
                panelBuilder.addLabel("(MAP sensor type)");
                panelBuilder.nextLine(2, 2);
                panelBuilder.appendRows(prefRowSpec, interCompGap);
                panelBuilder.addLabel("");
                panelBuilder.nextColumn(2);
                panelBuilder.add((Component)this.spnrMAPScale);
                panelBuilder.nextColumn(2);
                panelBuilder.add((Component)UnitsHelper.createJLabel("typeAbsoluteAirFromPSIA", "", "/volt (user-defined scale)"));
                panelBuilder.nextLine(2, 2);
                panelBuilder.appendRows(prefRowSpec, interCompGap);
                panelBuilder.addLabel("");
                panelBuilder.nextColumn(2);
                panelBuilder.add((Component)this.spnrMAPOffset);
                panelBuilder.nextColumn(2);
                panelBuilder.addLabel("volts (user-defined offset)");
                panelBuilder.nextLine(2, 2);
            }
        }
        if (this.comboWBInputX != null) {
            panelBuilder.appendRow(prefRowSpec);
            panelBuilder.addLabel("Wideband (WB):");
            panelBuilder.nextColumn(2);
            panelBuilder.add((Component)this.comboWBInputX);
            panelBuilder.nextColumn(2);
            panelBuilder.addLabel("(used for narrowband sim)");
            panelBuilder.nextLine(1, 2);
        }
        return panelBuilder.getPanel();
    }

    private JComponent buildInputLocksPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRow(interCompGap);
        panelBuilder.nextLine();
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("ECU Input Locks for Factory Code");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbLockIATBaro);
        panelBuilder.nextLine(2, 2);
        if (this.cbLockCoolant != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockCoolant);
            panelBuilder.nextLine(2, 2);
        }
        if (this.cbLockFrontO2 != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockFrontO2);
            panelBuilder.nextLine(2, 2);
        }
        if (this.cbLockEGRT != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockEGRT);
            panelBuilder.nextLine(2, 2);
        } else if (this.cbLockRearO2 != null && this.cbLockMDP != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockRearO2);
            panelBuilder.nextLine(2, 2);
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockMDP);
            panelBuilder.nextLine(2, 2);
        }
        return panelBuilder.getPanel();
    }
}

