/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.AliasAssignmentInterface;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIORecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIORecordView;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.uif.AbstractView;
import java.util.List;
import java.util.Map;

public class ECUIOTab
extends SettingsSubTab {
    ECUIORecordView view;
    AliasAssignmentInterface assignmentListener;

    public ECUIOTab(RecordSet recordSet, SettingsTab settingsTab) {
        super(recordSet, settingsTab);
    }

    public static boolean canDisplay(Map map) {
        return ECUIORecordModel.canDisplay(map);
    }

    @Override
    void setLiveView(boolean bl) {
        super.setLiveView(bl);
        if (bl && this.getRecordSet() instanceof ECMLinkConfigRecordSet) {
            ECMLinkConfigRecordSet eCMLinkConfigRecordSet = (ECMLinkConfigRecordSet)this.getRecordSet();
            this.assignmentListener = new AliasAssignmentInterface(){

                @Override
                public void newAliasAssignments(List list) {
                    if (ECUIOTab.this.view != null) {
                        ECUIOTab.this.view.loadLocalModelFromPrefs();
                    }
                }
            };
            eCMLinkConfigRecordSet.addAliasAssignmentListener(this.assignmentListener);
        }
        if (this.view != null) {
            this.view.setLiveView(bl);
        }
    }

    @Override
    void deregisterTab() {
        if (this.assignmentListener != null) {
            ECMLinkConfigRecordSet eCMLinkConfigRecordSet = (ECMLinkConfigRecordSet)this.getRecordSet();
            eCMLinkConfigRecordSet.removeAliasAssignmentListener(this.assignmentListener);
            this.assignmentListener = null;
        }
        super.deregisterTab();
    }

    @Override
    protected RecordModel createLocalModel() {
        return new ECUIORecordModel(this.getRecordSet());
    }

    @Override
    protected synchronized AbstractView createView(RecordModel recordModel) {
        if (this.view == null) {
            this.view = new ECUIORecordView((ECUIORecordModel)recordModel);
        }
        this.view.setLiveView(this.getParentTab().isLiveView());
        return this.view;
    }

    @Override
    protected String getTabTitle() {
        return "ECU Inputs";
    }

    @Override
    protected String getTipText() {
        return "Configures details about analog inputs to the ECU";
    }

    @Override
    protected String getTabHelpId() {
        return "ecmlink.ecuio.tab";
    }
}

