/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class EGRV1V2RecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModel mdlNormal;
    ValueModel mdlDisableOnClutch;
    ValueModel mdlDisableOnRev;
    ValueModelPlug mdlRPMLo;
    ValueModelPlug mdlRPMHi;
    ValueModelPlug mdlLoadFactorLo;
    ValueModelPlug mdlLoadFactorHi;
    ValueModelPlug mdlTPSLo;
    ValueModelPlug mdlTPSHi;
    ValueModelPlug mdlKnckLo;
    ValueModelPlug mdlKnckHi;
    ValueModelPlug mdlSpdLo;
    ValueModelPlug mdlSpdHi;
    ValueModelPlug mdlCoolLo;
    ValueModelPlug mdlCoolHi;
    ValueModelPlug mdlBoostLo;
    ValueModelPlug mdlBoostHi;
    ValueModelPlug mdlStateChangeMillis;

    EGRV1V2RecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.EGR_V1V2RECORD_IDS, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("EGRCtl", 128));
        this.mdlNormal = this.track(this.mdlNormal, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("EGRCtl", 64));
        this.mdlDisableOnClutch = this.track(this.mdlDisableOnClutch, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("EGRCtl", 32));
        this.mdlDisableOnRev = this.track(this.mdlDisableOnRev, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("EGRCtl", 16));
        this.mdlRPMLo = this.track(this.mdlRPMLo, baseRecord.numberFieldAsIntegerString("EGRPrecRPMLo", 50));
        this.mdlRPMHi = this.track(this.mdlRPMHi, baseRecord.numberFieldAsIntegerString("EGRPrecRPMHi", 50));
        this.mdlLoadFactorLo = this.track(this.mdlLoadFactorLo, baseRecord.numberFieldAsString("EGRTBAVPRLo", 1));
        this.mdlLoadFactorHi = this.track(this.mdlLoadFactorHi, baseRecord.numberFieldAsString("EGRTBAVPRHi", 1));
        this.mdlTPSLo = this.track(this.mdlTPSLo, baseRecord.numberFieldAsString("EGRTPSLo"));
        this.mdlTPSHi = this.track(this.mdlTPSHi, baseRecord.numberFieldAsString("EGRTPSHi"));
        this.mdlSpdLo = baseRecord.numberFieldAsString("EGRSpeedLo");
        this.mdlSpdHi = baseRecord.numberFieldAsString("EGRSpeedHi");
        UnitsHelper.installFilter(this.mdlSpdLo, "typeSpeedFromMPH");
        this.track(null, this.mdlSpdLo);
        UnitsHelper.installFilter(this.mdlSpdHi, "typeSpeedFromMPH");
        this.track(null, this.mdlSpdHi);
        this.mdlKnckLo = this.track(this.mdlKnckLo, baseRecord.numberFieldAsString("EGRKnockLo"));
        this.mdlKnckHi = this.track(this.mdlKnckHi, baseRecord.numberFieldAsString("EGRKnockHi"));
        if (baseRecord.getField("EGRCoolLo") != null) {
            this.mdlCoolLo = baseRecord.numberFieldAsString("EGRCoolLo");
            this.mdlCoolHi = baseRecord.numberFieldAsString("EGRCoolHi");
            UnitsHelper.installFilter(this.mdlCoolLo, "typeTemperatureFromF");
            this.track(null, this.mdlCoolLo);
            UnitsHelper.installFilter(this.mdlCoolHi, "typeTemperatureFromF");
            this.track(null, this.mdlCoolHi);
            this.mdlBoostLo = baseRecord.numberFieldAsString("EGRBoostLo");
            this.mdlBoostHi = baseRecord.numberFieldAsString("EGRBoostHi");
            UnitsHelper.installFilter(this.mdlBoostLo, "typeAirPressureFromPSIA");
            this.track(null, this.mdlBoostLo);
            UnitsHelper.installFilter(this.mdlBoostHi, "typeAirPressureFromPSIA");
            this.track(null, this.mdlBoostHi);
        }
        this.mdlStateChangeMillis = this.track(this.mdlStateChangeMillis, baseRecord.numberFieldAsInteger("EGRStateMillis", 5));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(ECMLinkRecordAdapter.EGR_V1V2RECORD_IDS, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return EGRV1V2RecordModel.canDisplay(map);
    }
}

