/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class FPSV1V2RecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModel mdlNormal;
    ValueModelPlug mdlRPMLo;
    ValueModelPlug mdlRPMHi;
    ValueModelPlug mdlTPS;
    ValueModelPlug mdlKnck;
    ValueModelPlug mdlTiming;
    ValueModelPlug mdlSpd;
    boolean v2Ind;

    FPSV1V2RecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    boolean isV2() {
        return this.v2Ind;
    }

    @Override
    protected void initAndTrackModels(Map map) {
        if (RecordSet.containsRecordId(18, map)) {
            this.v2Ind = true;
        }
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.FPS_V1V2RECORD_IDS, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 128));
        this.mdlNormal = this.track(this.mdlNormal, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 64));
        this.mdlRPMLo = this.track(this.mdlRPMLo, baseRecord.numberFieldAsIntegerString("FPSRPMLo", 50));
        this.mdlRPMHi = this.track(this.mdlRPMHi, baseRecord.numberFieldAsIntegerString("FPSRPMHi", 50));
        this.mdlTPS = this.track(this.mdlTPS, baseRecord.numberFieldAsString("FPSTPS"));
        this.mdlSpd = baseRecord.numberFieldAsString("FPSSpeed");
        UnitsHelper.installFilter(this.mdlSpd, "typeSpeedFromMPH");
        this.track(null, this.mdlSpd);
        this.mdlKnck = this.track(this.mdlKnck, baseRecord.numberFieldAsString("FPSKnock"));
        if (this.v2Ind) {
            this.mdlTiming = this.track(this.mdlTiming, baseRecord.numberFieldAsString("FPSIgnAdj"));
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        boolean bl = RecordSet.containsRecordId(14, map);
        boolean bl2 = RecordSet.containsRecordId(18, map);
        return this.isV2() ? bl2 : bl;
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(14, map) || RecordSet.containsRecordId(18, map);
    }
}

