/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.FPSV1V2RecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public class FPSV1V2RecordView
extends AbstractView {
    private JCheckBox cbFPSEnable;
    private JCheckBox cbFPSNormal;
    private JLabel lblFPSRPMLo;
    private JLabel lblFPSRPMLoUnits;
    private JLabel lblFPSRPMHi;
    private JLabel lblFPSRPMHiUnits;
    private JLabel lblFPSTPS;
    private JLabel lblFPSTPSUnits;
    private JLabel lblFPSSpd;
    private JLabel lblFPSSpdUnits;
    private JLabel lblFPSKnck;
    private JLabel lblFPSKnckUnits;
    private JLabel lblFPSTiming;
    private JLabel lblFPSTimingUnits;
    private JSpinner spnrFPSRPMLo;
    private JSpinner spnrFPSRPMHi;
    private JSpinner spnrFPSTPS;
    private JSpinner spnrFPSSpd;
    private JSpinner spnrFPSKnck;
    private JSpinner spnrFPSTiming;
    private final FPSV1V2RecordModel model;

    public FPSV1V2RecordView(FPSV1V2RecordModel fPSV1V2RecordModel) {
        this.model = fPSV1V2RecordModel;
    }

    private void initComponents() {
        this.cbFPSEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnable, (String)"Enable user-defined settings");
        this.cbFPSEnable.setToolTipText("Activates fuel pressure solenoid output based on user-defined conditions below");
        this.cbFPSNormal = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlNormal, (String)"Enable normal (factory) settings");
        this.cbFPSNormal.setToolTipText("Activates fuel pressure solenoid output based on factory-defined conditions");
        this.lblFPSRPMLo = new JLabel("Activate above:");
        this.spnrFPSRPMLo = DialogUtil.createSpinnerTextField(this.model.mdlRPMLo, "Deactivates output when engine RPM is below this value");
        this.lblFPSRPMLoUnits = new JLabel("rpm");
        this.lblFPSRPMHi = new JLabel("but below:");
        this.spnrFPSRPMHi = DialogUtil.createSpinnerTextField(this.model.mdlRPMHi, "Deactivates output when engine RPM is above this value");
        this.lblFPSRPMHiUnits = new JLabel("rpm");
        this.lblFPSTPS = new JLabel("And TPS above:");
        this.spnrFPSTPS = DialogUtil.createSpinnerTextField(this.model.mdlTPS, "Deactivates output when throttle angle is below this value");
        this.lblFPSTPSUnits = new JLabel("%");
        this.lblFPSSpd = new JLabel("And speed above:");
        this.spnrFPSSpd = DialogUtil.createSpinnerTextField(this.model.mdlSpd, "Deactivates output when speed is below this value");
        this.lblFPSSpdUnits = UnitsHelper.createJLabel("typeSpeedFromMPH");
        this.lblFPSKnck = new JLabel("And knock below:");
        this.spnrFPSKnck = DialogUtil.createSpinnerTextField(this.model.mdlKnck, "Deactivates output when knock retard is above this value");
        this.lblFPSKnckUnits = new JLabel("\u00b0");
        if (this.model.isV2()) {
            this.lblFPSTiming = new JLabel("Adjust timing by:");
            this.spnrFPSTiming = DialogUtil.createSpinnerTextField(this.model.mdlTiming, "When output is activated, ignition advance is adjusted by this value.  Negative values retard timing.");
            this.lblFPSTimingUnits = new JLabel("\u00b0");
            DialogUtil.installComponentEnabler(this.model.mdlEnable, new Component[]{this.lblFPSRPMLo, this.lblFPSRPMLoUnits, this.lblFPSRPMHi, this.lblFPSRPMHiUnits, this.lblFPSTPS, this.lblFPSTPSUnits, this.lblFPSSpd, this.lblFPSSpdUnits, this.lblFPSKnck, this.lblFPSKnckUnits, this.lblFPSTiming, this.lblFPSTimingUnits, this.spnrFPSRPMLo, this.spnrFPSRPMHi, this.spnrFPSTPS, this.spnrFPSSpd, this.spnrFPSKnck, this.spnrFPSTiming});
        } else {
            DialogUtil.installComponentEnabler(this.model.mdlEnable, new Component[]{this.lblFPSRPMLo, this.lblFPSRPMLoUnits, this.lblFPSRPMHi, this.lblFPSRPMHiUnits, this.lblFPSTPS, this.lblFPSTPSUnits, this.lblFPSSpd, this.lblFPSSpdUnits, this.lblFPSKnck, this.lblFPSKnckUnits, this.spnrFPSRPMLo, this.spnrFPSRPMHi, this.spnrFPSTPS, this.spnrFPSSpd, this.spnrFPSKnck});
        }
        DialogUtil.installComponentDisabler(this.model.mdlEnable, new Component[]{this.cbFPSNormal});
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Fuel Pressure Solenoid Control", cellConstraints.xyw(1, n, 7));
        panelBuilder.add((Component)this.cbFPSEnable, cellConstraints.xyw(2, n += 2, 6));
        panelBuilder.add((Component)this.cbFPSNormal, cellConstraints.xyw(2, n += 2, 6));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, this.lblFPSRPMLo, this.spnrFPSRPMLo, this.lblFPSRPMLoUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblFPSRPMHi, this.spnrFPSRPMHi, this.lblFPSRPMHiUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblFPSTPS, this.spnrFPSTPS, this.lblFPSTPSUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblFPSSpd, this.spnrFPSSpd, this.lblFPSSpdUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblFPSKnck, this.spnrFPSKnck, this.lblFPSKnckUnits, cellConstraints.xy(2, n));
        if (this.model.isV2()) {
            n = DialogUtil.addTriplet(panelBuilder, this.lblFPSTiming, this.spnrFPSTiming, this.lblFPSTimingUnits, cellConstraints.xy(2, n));
        }
        return panelBuilder.getPanel();
    }
}

