/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class FPSV3V4RecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModel mdlNormal;
    ValueModel mdlDisableOnClutch;
    ValueModel mdlDisableOnRev;
    ValueModelPlug mdlRPMLo;
    ValueModelPlug mdlRPMHi;
    ValueModelPlug mdlLoadFactorLo;
    ValueModelPlug mdlLoadFactorHi;
    ValueModelPlug mdlTPSLo;
    ValueModelPlug mdlTPSHi;
    ValueModelPlug mdlKnckLo;
    ValueModelPlug mdlKnckHi;
    ValueModelPlug mdlSpdLo;
    ValueModelPlug mdlSpdHi;
    ValueModelPlug mdlCoolLo;
    ValueModelPlug mdlCoolHi;
    ValueModelPlug mdlBoostLo;
    ValueModelPlug mdlBoostHi;
    ValueModelPlug mdlStateChangeMillis;

    FPSV3V4RecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.FPS_V3V4RECORD_IDS, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 128));
        this.mdlNormal = this.track(this.mdlNormal, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 64));
        this.mdlDisableOnClutch = this.track(this.mdlDisableOnClutch, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 32));
        this.mdlDisableOnRev = this.track(this.mdlDisableOnRev, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("FPSCtl", 16));
        this.mdlRPMLo = this.track(this.mdlRPMLo, baseRecord.numberFieldAsIntegerString("FPSPrecRPMLo", 50));
        this.mdlRPMHi = this.track(this.mdlRPMHi, baseRecord.numberFieldAsIntegerString("FPSPrecRPMHi", 50));
        this.mdlLoadFactorLo = this.track(this.mdlLoadFactorLo, baseRecord.numberFieldAsString("FPSTBAVPRLo", 1));
        this.mdlLoadFactorHi = this.track(this.mdlLoadFactorHi, baseRecord.numberFieldAsString("FPSTBAVPRHi", 1));
        this.mdlTPSLo = this.track(this.mdlTPSLo, baseRecord.numberFieldAsString("FPSTPSLo"));
        this.mdlTPSHi = this.track(this.mdlTPSHi, baseRecord.numberFieldAsString("FPSTPSHi"));
        this.mdlSpdLo = baseRecord.numberFieldAsString("FPSSpeedLo");
        this.mdlSpdHi = baseRecord.numberFieldAsString("FPSSpeedHi");
        UnitsHelper.installFilter(this.mdlSpdLo, "typeSpeedFromMPH");
        this.track(null, this.mdlSpdLo);
        UnitsHelper.installFilter(this.mdlSpdHi, "typeSpeedFromMPH");
        this.track(null, this.mdlSpdHi);
        this.mdlKnckLo = this.track(this.mdlKnckLo, baseRecord.numberFieldAsString("FPSKnockLo"));
        this.mdlKnckHi = this.track(this.mdlKnckHi, baseRecord.numberFieldAsString("FPSKnockHi"));
        if (baseRecord.getField("FPSCoolLo") != null) {
            this.mdlCoolLo = baseRecord.numberFieldAsString("FPSCoolLo");
            this.mdlCoolHi = baseRecord.numberFieldAsString("FPSCoolHi");
            UnitsHelper.installFilter(this.mdlCoolLo, "typeTemperatureFromF");
            this.track(null, this.mdlCoolLo);
            UnitsHelper.installFilter(this.mdlCoolHi, "typeTemperatureFromF");
            this.track(null, this.mdlCoolHi);
            this.mdlBoostLo = baseRecord.numberFieldAsString("FPSBoostLo");
            this.mdlBoostHi = baseRecord.numberFieldAsString("FPSBoostHi");
            UnitsHelper.installFilter(this.mdlBoostLo, "typeAirPressureFromPSIA");
            this.track(null, this.mdlBoostLo);
            UnitsHelper.installFilter(this.mdlBoostHi, "typeAirPressureFromPSIA");
            this.track(null, this.mdlBoostHi);
        }
        this.mdlStateChangeMillis = this.track(this.mdlStateChangeMillis, baseRecord.numberFieldAsInteger("FPSStateMillis", 5));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(ECMLinkRecordAdapter.FPS_V3V4RECORD_IDS, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return FPSV3V4RecordModel.canDisplay(map);
    }
}

