/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPref;
import com.ecmtuning.ecmlink.device.data.prefsedit.EditPrefsSection;
import com.ecmtuning.ecmlink.device.data.prefsedit.TextEditPref;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.ui.ActionWrapper;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.FuelEstimateEditPref;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.util.Resizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FuelEstimateDialog
extends AbstractDialog {
    private final List sectionList = new ArrayList();
    private final boolean is1GDevice;
    private FuelEstimateEditPref fuelEditPref;
    private String outputText;
    ActionWrapper okWrapper;
    JComponent contentPanel;

    public FuelEstimateDialog(Frame frame, int n, float f) {
        super(frame);
        this.is1GDevice = ECMLinkDeviceMap.is1GDSMDevice(n);
        DataPreferences dataPreferences = DataPreferences.getViewPreferences("fuelestimator");
        ArrayList<EditPref> arrayList = new ArrayList<EditPref>();
        TextEditPref textEditPref = new TextEditPref((Preferences)dataPreferences, "injsize", 450.0f);
        arrayList.add(textEditPref);
        textEditPref.set("Injector size", "Effective injector flow rate at 43.5 psi", null);
        textEditPref.installClipFilter(260.0f, 2500.0f);
        UnitsHelper.addFilter(textEditPref.getFilteredModel(), "typeFuelFlowFromCCPM");
        UnitsModel unitsModel = UnitsModel.getInstance();
        boolean bl = UnitsModel.INDEX_INJECTOR_SIZE_CCPMIN.equals(unitsModel.getInjectorSizeIndex());
        textEditPref.installFinalNumberFilter(bl ? 0 : 1);
        textEditPref.setUnitText(UnitsHelper.getUnitsLabel("typeFuelFlowFromCCPM"));
        BufferedValueModel bufferedValueModel = textEditPref.getBufferedValueModel();
        textEditPref = new TextEditPref((Preferences)dataPreferences, "fuelpressure", this.is1GDevice ? 37.0f : 42.6f);
        arrayList.add(textEditPref);
        textEditPref.set("Base fuel pressure", "Actual base fuel pressure (may be different from stock)", null);
        textEditPref.installClipFilter(25.0f, 60.0f);
        UnitsHelper.addFilter(textEditPref.getFilteredModel(), "typeFluidPressureFromPSIG");
        UnitsModel unitsModel2 = UnitsModel.getInstance();
        boolean bl2 = UnitsModel.INDEX_FLUID_PRESSURE_KPA.equals(unitsModel2.getFluidPressureIndex());
        textEditPref.installFinalNumberFilter(bl2 ? 0 : 1);
        textEditPref.setUnitText(UnitsHelper.getUnitsLabel("typeFluidPressureFromPSIG"));
        BufferedValueModel bufferedValueModel2 = textEditPref.getBufferedValueModel();
        textEditPref = new TextEditPref((Preferences)dataPreferences, "fuelstoichratio", 14.7f);
        arrayList.add(textEditPref);
        textEditPref.set("Stoichiometric ratio", "The stoichiometric ratio for your fuel type; e.g., 14.7 for gasoline", ":1");
        textEditPref.installFinalClipFilter(4.0f, 16.0f, 1);
        BufferedValueModel bufferedValueModel3 = textEditPref.getBufferedValueModel();
        this.fuelEditPref = new FuelEstimateEditPref((AbstractValueModel)bufferedValueModel, (AbstractValueModel)bufferedValueModel2, (AbstractValueModel)bufferedValueModel3, this.is1GDevice, f);
        arrayList.add(this.fuelEditPref);
        this.sectionList.add(new EditPrefsSection("Global Fuel Adjustment", arrayList));
        this.setTitle(ECMLinkResources.getString("ecmlink.fuelestimate.title"));
    }

    protected void setResizable() {
        this.setResizable(true);
    }

    protected void resizeHook(JComponent jComponent) {
        Resizer.FOUR2THREE.resizeDialogContent(jComponent);
    }

    public Action getOKAction() {
        Action action = super.getOKAction();
        if (this.okWrapper == null) {
            this.okWrapper = new ActionWrapper(action);
            this.okWrapper.overrideValue("Name", "Use");
        }
        return this.okWrapper;
    }

    public void doApply() {
        this.outputText = this.fuelEditPref.getOutputText();
        super.doApply();
    }

    public String getResultText() {
        return this.outputText;
    }

    protected JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildCenterPane(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancel(), "South");
            this.setDefaultButton(this.fuelEditPref.btnCalc);
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    private JPanel buildCenterPane() {
        FormLayout formLayout = new FormLayout("");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.appendRow(DialogUtil.FILL_PREF_GROW_ROWSPEC);
        panelBuilder.appendColumn(DialogUtil.FILL_DEFAULT_GROW_COLSPEC);
        panelBuilder.add(this.buildConverterPrefsPanel());
        panelBuilder.nextColumn();
        panelBuilder.appendGlueRow();
        return panelBuilder.getPanel();
    }

    private Component buildConverterPrefsPanel() {
        PanelBuilder panelBuilder = EditPref.createPanelBuilder();
        for (EditPrefsSection editPrefsSection : this.sectionList) {
            EditPref.addPrefsSection(editPrefsSection, panelBuilder, this.getTriggerChannel());
            panelBuilder.appendRow(DialogUtil.RELATED_GAP_ROWSPEC);
            panelBuilder.nextLine();
        }
        return panelBuilder.getPanel();
    }
}

