/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.prefsedit.EditPref;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.uif.component.UIFButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JTextField;

public class FuelEstimateEditPref
extends EditPref {
    final AbstractValueModel injSizeCCPMinModel;
    final AbstractValueModel basePressPSIGModel;
    final AbstractValueModel stoichModel;
    final boolean is1G;
    JButton btnCalc = new UIFButton("Calculate");
    JTextField tfOutput = new JTextField();
    String strOutput = "0";
    PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FuelEstimateEditPref.this.updateOutput();
        }
    };

    FuelEstimateEditPref(AbstractValueModel abstractValueModel, AbstractValueModel abstractValueModel2, AbstractValueModel abstractValueModel3, boolean bl, float f) {
        this.injSizeCCPMinModel = abstractValueModel;
        this.basePressPSIGModel = abstractValueModel2;
        this.stoichModel = abstractValueModel3;
        this.is1G = bl;
        this.tfOutput.setEditable(false);
        this.tfOutput.setColumns(5);
        this.tfOutput.setHorizontalAlignment(4);
        this.setLabelComponent(this.btnCalc);
        this.setValueComponent(this.tfOutput);
        this.setUnitText("%");
        this.btnCalc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FuelEstimateEditPref.this.updateOutput();
            }
        });
        abstractValueModel.addValueChangeListener(this.pListener);
        abstractValueModel2.addValueChangeListener(this.pListener);
        abstractValueModel3.addValueChangeListener(this.pListener);
        float f2 = 450.0f * this.calcFlowRateAdj() / (f / 100.0f + 1.0f);
        abstractValueModel.setValue(f2);
        this.setOutput(f);
    }

    String getOutputText() {
        return this.strOutput;
    }

    float calcFlowRateAdj() {
        float f = this.basePressPSIGModel.floatValue();
        float f2 = this.stoichModel.floatValue();
        float f3 = (float)(Math.pow((this.is1G ? 37.0 : 42.6) / (double)f, 0.5) * 14.7 / (double)f2);
        return f3;
    }

    void setOutput(float f) {
        this.tfOutput.setText(XFormatter.format(f, 1));
        this.strOutput = this.tfOutput.getText();
    }

    void updateOutput() {
        this.tfOutput.setText("");
        try {
            float f = this.injSizeCCPMinModel.floatValue();
            float f2 = 100.0f * (450.0f / f * this.calcFlowRateAdj() - 1.0f);
            this.setOutput(f2);
        }
        catch (Throwable throwable) {
            this.tfOutput.setText("ERR");
        }
    }
}

