/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class FuelRecordModel
extends RecordModel {
    ListModelPlug mdlFuelTbl;
    ValueModelPlug mdlInjScale;
    ValueModelPlug mdlInjAllDeadtime;
    ValueModelPlug mdlMinIPW;
    ValueModelPlug mdlInj1Deadtime;
    ValueModelPlug mdlInj2Deadtime;
    ValueModelPlug mdlInj3Deadtime;
    ValueModelPlug mdlInj4Deadtime;
    ValueModelPlug mdlLoadLimit;
    ValueModelPlug mdlMAPAdjLimit;
    public ValueModel mdlPersistedMAPInputX;
    public ValueModel mdlPersistedMAPSelect;
    final int originalDeviceID;
    Object fuelTblRecordId;
    boolean isRPMShifted;
    private static final int[] FUEL_TABLE_RECORD_IDS = new int[]{1, 56, 25, 46, 55};

    FuelRecordModel(RecordSet recordSet) {
        Map map = recordSet.getPersistentRecordMap();
        BaseRecord baseRecord = RecordSet.getRecord(44, map);
        this.initialize(recordSet);
        if (baseRecord != null) {
            this.mdlPersistedMAPInputX = baseRecord.getFeaturePlug("mapInputX");
            this.mdlPersistedMAPSelect = baseRecord.getFeaturePlug("mapSelectFeature");
        }
        this.originalDeviceID = recordSet.getDeviceId();
    }

    @Override
    protected void initAndTrackModels(Map map) {
        int n;
        BaseRecord baseRecord = RecordSet.getRecord(FUEL_TABLE_RECORD_IDS, map);
        this.fuelTblRecordId = baseRecord.getRecordID();
        this.isRPMShifted = !new Integer(1).equals(this.fuelTblRecordId) && !new Integer(56).equals(this.fuelTblRecordId);
        this.mdlFuelTbl = this.track(this.mdlFuelTbl, baseRecord.numberListField("FuelTable"));
        this.mdlInjScale = this.track(this.mdlInjScale, baseRecord.numberFieldAsString("InjScale", 1));
        this.mdlInjAllDeadtime = this.track(this.mdlInjAllDeadtime, baseRecord.getFeaturePlug("allInjDeadTimeFeature"));
        this.mdlMinIPW = this.track(this.mdlMinIPW, baseRecord.getFeaturePlug("minIPW"));
        this.mdlInj1Deadtime = this.track(this.mdlInj1Deadtime, baseRecord.getFeaturePlug("injDeadtimeCyl1Feature"));
        this.mdlInj2Deadtime = this.track(this.mdlInj2Deadtime, baseRecord.getFeaturePlug("injDeadtimeCyl2Feature"));
        this.mdlInj3Deadtime = this.track(this.mdlInj3Deadtime, baseRecord.getFeaturePlug("injDeadtimeCyl3Feature"));
        this.mdlInj4Deadtime = this.track(this.mdlInj4Deadtime, baseRecord.getFeaturePlug("injDeadtimeCyl4Feature"));
        BaseRecord baseRecord2 = RecordSet.getRecord(44, map);
        if (baseRecord2 != null && ((n = baseRecord2.getField("MiscBits3Mask").intValue()) & 0x20) != 0) {
            this.mdlLoadLimit = this.track(this.mdlLoadLimit, baseRecord2.numberFieldAsString("LoadLimit", 2));
            this.mdlMAPAdjLimit = baseRecord2.numberFieldAsString("MAPAdjLimit");
            UnitsHelper.installFilter(this.mdlMAPAdjLimit, "typeAirPressureFromPSIA");
            this.track(null, this.mdlMAPAdjLimit);
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        int n;
        BaseRecord baseRecord = RecordSet.getRecord(FUEL_TABLE_RECORD_IDS, map);
        boolean bl = baseRecord != null && baseRecord.getRecordID().equals(this.fuelTblRecordId);
        boolean bl2 = this.mdlLoadLimit != null;
        BaseRecord baseRecord2 = RecordSet.getRecord(44, map);
        boolean bl3 = baseRecord2 != null ? ((n = baseRecord2.getField("MiscBits3Mask").intValue()) & 0x20) != 0 : false;
        return bl && bl2 == bl3;
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(FUEL_TABLE_RECORD_IDS, map);
    }
}

