/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.FuelDataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.FuelEstimateDialog;
import com.ecmtuning.ecmlink.view.ecmlink.FuelRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FuelRecordView
extends AbstractRecordView {
    private JSpinner spnrGlobalFuel;
    private JSpinner spnrDeadtime;
    private JSpinner spnrDeadtimeCyl1;
    private JSpinner spnrDeadtimeCyl2;
    private JSpinner spnrDeadtimeCyl3;
    private JSpinner spnrDeadtimeCyl4;
    private JSpinner spnrLoadLimit;
    private JSpinner spnrMAPAdjLimit;
    private Action inputTabAction;
    private ActionLabel inputsTabActionLabel;
    private JSpinner spnrMinIPW;
    JComboBox comboStepSize;
    private JButton calculateBtn;
    private FuelDataAdapter dataAdapter;
    private ChtTblBuilder chtTblBuilder;
    private final FuelRecordModel model;
    private final SettingsTab parentTab;
    ValueHolder enabledHolder = new ValueHolder(false);
    ActionListener calculateBtnListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f = XFormatter.parse((String)((FuelRecordView)FuelRecordView.this).model.mdlInjScale.getValue());
            FuelEstimateDialog fuelEstimateDialog = new FuelEstimateDialog(MainModel.getDefaultParentFrame(), ((FuelRecordView)FuelRecordView.this).model.originalDeviceID, f);
            fuelEstimateDialog.open();
            if (!fuelEstimateDialog.hasBeenCanceled()) {
                String string = fuelEstimateDialog.getResultText();
                ((FuelRecordView)FuelRecordView.this).model.mdlInjScale.setValue(string);
            }
        }
    };

    public FuelRecordView(FuelRecordModel fuelRecordModel, SettingsTab settingsTab) {
        this.model = fuelRecordModel;
        this.parentTab = settingsTab;
    }

    public void resetViewport() {
        this.chtTblBuilder.getChart().resetViewport();
    }

    public Component getDefaultFocusComponent() {
        return this.chtTblBuilder.getChart();
    }

    private void initComponents() {
        Object object;
        this.dataAdapter = new FuelDataAdapter(this.model.mdlFuelTbl, this.model.isRPMShifted);
        this.chtTblBuilder = new ChtTblBuilder(this.dataAdapter);
        this.dataAdapter.createTableActions(this.chtTblBuilder);
        this.initTable();
        this.initChart();
        this.spnrGlobalFuel = DialogUtil.createSpinnerTextField(this.model.mdlInjScale, "Global fuel adjustment");
        if (this.model.mdlInj1Deadtime != null) {
            Component component;
            object = new ValueHolder(5);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(1));
            arrayList.add(new Integer(2));
            arrayList.add(new Integer(5));
            arrayList.add(new Integer(10));
            arrayList.add(new Integer(15));
            if (this.model.mdlInjAllDeadtime != null) {
                this.spnrDeadtime = DialogUtil.createSpinnerTextField(this.model.mdlInjAllDeadtime, "Added to injector pulsewidth to account for injector dead time/dwell time", (ValueModel)object);
            }
            this.comboStepSize = DialogUtil.createComboBox(arrayList, (ValueModel)object, true, "Step size for increment/decrement on deadtime spinners");
            if (this.comboStepSize.getEditor() != null && this.comboStepSize.getEditor().getEditorComponent() != null && (component = this.comboStepSize.getEditor().getEditorComponent()) instanceof JTextField) {
                ((JTextField)component).setColumns(3);
            }
            this.spnrDeadtimeCyl1 = DialogUtil.createSpinnerTextField(this.model.mdlInj1Deadtime, "Added to injector pulsewidth for cylinder #1 to account for injector dead time", (ValueModel)object);
            ((JFormattedTextField)this.spnrDeadtimeCyl1.getEditor().getComponent(0)).setColumns(4);
            this.spnrDeadtimeCyl2 = DialogUtil.createSpinnerTextField(this.model.mdlInj2Deadtime, "Added to injector pulsewidth for cylinder #2 to account for injector dead time", (ValueModel)object);
            ((JFormattedTextField)this.spnrDeadtimeCyl2.getEditor().getComponent(0)).setColumns(4);
            this.spnrDeadtimeCyl3 = DialogUtil.createSpinnerTextField(this.model.mdlInj3Deadtime, "Added to injector pulsewidth for cylinder #3 to account for injector dead time", (ValueModel)object);
            ((JFormattedTextField)this.spnrDeadtimeCyl3.getEditor().getComponent(0)).setColumns(4);
            this.spnrDeadtimeCyl4 = DialogUtil.createSpinnerTextField(this.model.mdlInj4Deadtime, "Added to injector pulsewidth for cylinder #4 to account for injector dead time", (ValueModel)object);
            ((JFormattedTextField)this.spnrDeadtimeCyl4.getEditor().getComponent(0)).setColumns(4);
        } else if (this.model.mdlInjAllDeadtime != null) {
            this.spnrDeadtime = DialogUtil.createSpinnerTextField(this.model.mdlInjAllDeadtime, "Added to injector pulsewidth to account for injector dead time/dwell time");
        }
        if (this.model.mdlMinIPW != null) {
            this.spnrMinIPW = DialogUtil.createSpinnerTextField(this.model.mdlMinIPW, "Minimum injector pulsewidth");
        }
        if (this.model.mdlLoadLimit != null && this.model.mdlMAPAdjLimit != null) {
            this.spnrLoadLimit = DialogUtil.createSpinnerTextField(this.model.mdlLoadLimit, "Activates fuel cut when LoadFactor is above this value");
            this.spnrMAPAdjLimit = DialogUtil.createSpinnerTextField(this.model.mdlMAPAdjLimit, "Activates fuel cut when ECUBoost is above this value");
            if (this.model.mdlPersistedMAPInputX != null && this.model.mdlPersistedMAPSelect != null) {
                this.inputTabAction = this.parentTab.createTabAction(ECUIOTab.class);
                this.inputsTabActionLabel = new ActionLabel(this.inputTabAction);
                object = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        FuelRecordView.this.updateEnabledValue();
                    }
                };
                this.model.mdlPersistedMAPInputX.addValueChangeListener((PropertyChangeListener)object);
                this.model.mdlPersistedMAPSelect.addValueChangeListener((PropertyChangeListener)object);
                this.updateEnabledValue();
            }
        }
        this.calculateBtn = new JButton("Calculate\u2026");
        this.calculateBtn.addActionListener(this.calculateBtnListener);
    }

    void updateEnabledValue() {
        boolean bl = ((Number)this.model.mdlPersistedMAPInputX.getValue()).intValue() != 0;
        boolean bl2 = ((Number)this.model.mdlPersistedMAPSelect.getValue()).intValue() != 0;
        boolean bl3 = bl && bl2;
        this.enabledHolder.setValue(bl3);
        if (!bl || !bl2) {
            this.inputsTabActionLabel.setForeground(Color.RED);
            String string = "";
            string = !bl && !bl2 ? "input pin & type" : (!bl ? "input pin" : "sensor type");
            this.inputsTabActionLabel.setText("Assign MAP " + string + "\u2026");
            this.spnrMAPAdjLimit.setEnabled(false);
        } else {
            this.inputsTabActionLabel.setForeground(Color.BLUE);
            this.inputsTabActionLabel.setText("Edit MAP input pin & type\u2026");
            this.spnrMAPAdjLimit.setEnabled(true);
        }
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        FloatRect floatRect = new FloatRect();
        float f = this.model.isRPMShifted ? 2000.0f : 0.0f;
        floatRect.setCorners(-400.0f + f, -55.0f, 8400.0f + f, 35.0f);
        this.dataAdapter.setMaxViewportForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect);
        FloatRect floatRect2 = new FloatRect(0.0f, 0.0f, 500.0f, 5.0f);
        this.dataAdapter.setGridForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect2);
        chart.setXAxisLoc(0.0f + f);
        chart.setYAxisLoc(0.0f);
        this.chtTblBuilder.setStandardPlotDescs();
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        handyJTable.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Fuel Adjustments Table", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.chtTblBuilder.getPanel(), cellConstraints.xy(2, 3));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Global fuel and deadtime", this.buildGlobalsTab());
        if (this.spnrDeadtimeCyl1 != null) {
            jTabbedPane.addTab("Individual deadtimes", this.buildIndivTab());
        }
        if (this.spnrMinIPW != null) {
            jTabbedPane.addTab("Short pulsewidth adjustments", this.buildLowPWTab());
        }
        if (this.spnrLoadLimit != null) {
            jTabbedPane.addTab("Fuel cut", this.buildFuelCutTab());
        }
        panelBuilder.add((Component)jTabbedPane, cellConstraints.xyw(1, 5, 2));
        return panelBuilder.getPanel();
    }

    protected Component buildGlobalsTab() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Injector size and global deadtime", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.buildSettingsPanel(), cellConstraints.xy(2, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBorder(Borders.DIALOG_BORDER);
        return jPanel;
    }

    protected Component buildIndivTab() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Individual deadtimes (added to global)", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.buildInjDeadtimePanel(), cellConstraints.xy(2, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBorder(Borders.DIALOG_BORDER);
        return jPanel;
    }

    protected Component buildLowPWTab() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Low flow adjustments and limits", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.buildLowPWPanel(), cellConstraints.xy(2, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBorder(Borders.DIALOG_BORDER);
        return jPanel;
    }

    protected Component buildFuelCutTab() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Airflow (LoadFactor) and ECU Boost-based fuel cut", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.buildFuelCutPanel(), cellConstraints.xy(2, 3));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBorder(Borders.DIALOG_BORDER);
        return jPanel;
    }

    protected JComponent buildLowPWPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        DialogUtil.addTriplet(panelBuilder, "Minimum pulsewidth:", this.spnrMinIPW, "\u00b5secs", cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    protected JComponent buildSettingsPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        if (this.spnrDeadtime != null) {
            arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
            arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
            arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
            arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
            arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
            arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        }
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        DialogUtil.addTriplet(panelBuilder, "Global fuel:", this.spnrGlobalFuel, "%", cellConstraints.xy(1, 1));
        if (this.spnrDeadtime != null) {
            DialogUtil.addTriplet(panelBuilder, "Global deadtime:", this.spnrDeadtime, "\u00b5secs", cellConstraints.xy(7, 1));
        }
        panelBuilder.add((Component)this.calculateBtn, cellConstraints.xy(this.spnrDeadtime == null ? 7 : 13, 1));
        return panelBuilder.getPanel();
    }

    protected JComponent buildInjDeadtimePanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        formLayout.setColumnGroups((int[][])new int[][]{{1, 5, 9, 13}, {3, 7, 11, 15}});
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRow(prefRowSpec);
        panelBuilder.setColumn(1);
        panelBuilder.addLabel("Cyl 1:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDeadtimeCyl1);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("Cyl 2:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDeadtimeCyl2);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("Cyl 3:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDeadtimeCyl3);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("Cyl 4:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDeadtimeCyl4);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("\u00b5secs");
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("+/- step:");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.comboStepSize);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("\u00b5secs");
        return panelBuilder.getPanel();
    }

    protected JComponent buildFuelCutPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        formLayout.setColumnGroups((int[][])new int[][]{{3, 7}});
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRow(prefRowSpec);
        panelBuilder.setColumn(1);
        panelBuilder.addLabel("Cut fuel when LoadFactor > ");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrLoadLimit);
        panelBuilder.nextColumn(2);
        panelBuilder.addLabel("or ECUBoost > ");
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrMAPAdjLimit);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)UnitsHelper.createJLabel("typeAirPressureFromPSIA"));
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.inputsTabActionLabel);
        return panelBuilder.getPanel();
    }
}

