/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.ListBasedTableModel;
import com.ecmtuning.ecmlink.util.ui.TextSelectionTableCellEditor;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.IdleAirClampRecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.table.TableCellEditor;

public class IdleAirClampRecordView
extends AbstractRecordView {
    private final IdleAirClampRecordModel model;
    private HandyJTable tblMain;
    private HandyJTable tblCoolAdj;
    private JCheckBox cbAdjEnable;
    private static final List rpmIndicesList = Arrays.asList("0", "500", "1000", "1500", "2000", "2500", "3000", "3500", "4000", "4500");
    ListModelPlug coolTempIndicesPlug;
    private static final List tempCIndicesList = Arrays.asList(new Float(-19.0f), new Float(-7.0f), new Float(8.0f), new Float(21.0f), new Float(35.0f), new Float(52.0f), new Float(80.0f), new Float(88.0f));

    public IdleAirClampRecordView(IdleAirClampRecordModel idleAirClampRecordModel) {
        this.model = idleAirClampRecordModel;
    }

    private void initComponents() {
        ArrayListModel arrayListModel = this.model.mdlClampAcTbl.getLocalArrayListValue();
        ArrayListModel arrayListModel2 = this.model.mdlClampNoAcTbl.getLocalArrayListValue();
        this.tblMain = this.createMainTable((ListModel)arrayListModel, (ListModel)arrayListModel2);
        this.tblCoolAdj = this.createCoolAdjTable(this.model.mdlCoolAdjTbl);
        this.cbAdjEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnableClamp, (String)"Enable idle air clamp");
        this.cbAdjEnable.setToolTipText("Enables a clamp on airflow (AvgAirVolPerRev) while the idle switch is active");
        DialogUtil.installComponentEnabler(this.model.mdlEnableClamp, new Component[]{this.tblMain, this.tblCoolAdj});
    }

    private HandyJTable createMainTable(final ListModel listModel, ListModel listModel2) {
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && n < listModel.getSize();
            }
        };
        ArrayListModel arrayListModel = new ArrayListModel((Collection)rpmIndicesList);
        listBasedTableModel.addColumn("RPM", (ListModel)arrayListModel);
        listBasedTableModel.addColumn("A/C off", listModel2);
        listBasedTableModel.addColumn("A/C on", listModel);
        HandyJTable handyJTable = new HandyJTable(listBasedTableModel);
        this.configStandardTable(handyJTable);
        handyJTable.setColumnWidthFromProto(0, (List)arrayListModel);
        handyJTable.setColumnWidthFromProto(1, "XXXXXX");
        handyJTable.setColumnWidthFromProto(2, "XXXXXX");
        handyJTable.setColumnAlignments(new int[]{4, 4, 4});
        handyJTable.padColumnWidths(8);
        handyJTable.setToolTipText("Clamps AvgAirVolPerRev to given values while idle switch is active");
        return handyJTable;
    }

    private void configStandardTable(HandyJTable handyJTable) {
        handyJTable.setAutoResizeMode(3);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        handyJTable.setEnabled(true);
        handyJTable.setCellSelectionEnabled(true);
        handyJTable.setColumnSelectionAllowed(true);
        handyJTable.setRowSelectionAllowed(true);
        handyJTable.setSelectionMode(0);
        TableCellEditor tableCellEditor = handyJTable.getDefaultEditor(Object.class);
        handyJTable.setDefaultEditor(Object.class, new TextSelectionTableCellEditor(tableCellEditor));
        handyJTable.setAssignRendererEnable(true);
    }

    private HandyJTable createCoolAdjTable(final ListModelPlug listModelPlug) {
        ListBasedTableModel listBasedTableModel = new ListBasedTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 != 0 && n < listModelPlug.getLocalArrayListValue().getSize();
            }
        };
        ValueHolder valueHolder = new ValueHolder((Object)new ArrayListModel((Collection)tempCIndicesList));
        this.coolTempIndicesPlug = new ListModelPlug((ValueModel)valueHolder, null);
        UnitsHelper.installFilter(this.coolTempIndicesPlug, "typeTemperatureFromC");
        this.coolTempIndicesPlug.addObjectFilter(new Number2StringFilter(0));
        listBasedTableModel.addColumn("Temp", (ListModel)this.coolTempIndicesPlug.getLocalArrayListValue());
        listBasedTableModel.addColumn("Adj (%)", (ListModel)listModelPlug.getLocalArrayListValue());
        HandyJTable handyJTable = new HandyJTable(listBasedTableModel);
        this.configStandardTable(handyJTable);
        handyJTable.setColumnWidthFromProto(0, "XXXXXX");
        handyJTable.setColumnWidthFromProto(1, "XXXXXX");
        handyJTable.setColumnAlignments(new int[]{4, 4});
        handyJTable.padColumnWidths(8);
        handyJTable.setToolTipText("Provides adjustments to clamp value based on coolant temp");
        return handyJTable;
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_GROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Idle Air Clamp", 3);
        panelBuilder.setColumn(5);
        panelBuilder.addSeparator("Coolant-based Adjustment", 2);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(DialogUtil.TOP_PREF_NOGROW_ROWSPEC, interCompGap);
        panelBuilder.add((Component)new JScrollPane((Component)((Object)this.tblMain)));
        panelBuilder.setColumn(6);
        panelBuilder.add((Component)new JScrollPane((Component)((Object)this.tblCoolAdj)));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbAdjEnable);
        panelBuilder.nextLine(2, 2);
        return panelBuilder.getPanel();
    }
}

