/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.records.MAFClampV1Record;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.InterpListValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleListValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetListValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public final class MAFClampDataAdapter
extends ChtTblDataAdapter {
    final ListModelPlug mdlVETbl;
    final boolean isRPMShifted;
    private final TemplateOptions templateOptions;
    private final float[] stockTemplate;
    Action stockAction;
    Action useTemplateAction;
    Action hideTemplateAction;
    Action copyTableAction;
    Action pasteTableAction;
    private final float[] STOCK_TEMPLATE_VALUES = new float[]{83.0f, 83.0f, 83.0f, 83.0f, 82.0f, 82.0f, 87.0f, 86.0f, 89.0f, 99.0f, 100.0f, 100.0f, 100.0f, 99.0f, 94.0f, 89.0f, 89.0f};
    private final float[] STOCK_SHIFTED_TEMPLATE_VALUES = new float[]{82.0f, 82.0f, 87.0f, 86.0f, 89.0f, 99.0f, 100.0f, 100.0f, 100.0f, 99.0f, 94.0f, 89.0f, 89.0f, 89.0f, 89.0f, 89.0f, 89.0f};
    private final float[] SMIM_TEMPLATE_VALUES = new float[]{83.0f, 83.0f, 83.0f, 83.0f, 82.0f, 82.0f, 87.0f, 86.0f, 89.0f, 99.0f, 100.0f, 100.0f, 104.0f, 105.0f, 105.0f, 101.0f, 97.0f};
    private final float[] SMIM_SHIFTED_TEMPLATE_VALUES = new float[]{82.0f, 82.0f, 87.0f, 86.0f, 89.0f, 99.0f, 100.0f, 100.0f, 104.0f, 105.0f, 105.0f, 101.0f, 97.0f, 95.0f, 94.0f, 94.0f, 94.0f};
    static float[] xIndices = new float[]{0.0f, 500.0f, 1000.0f, 1500.0f, 2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f};
    static ArrayListModel xFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(xIndices)));
    static float[] xIndicesShifted = new float[]{2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f, 8500.0f, 9000.0f, 9500.0f, 10000.0f};
    static ArrayListModel xFloatListShifted = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(xIndicesShifted)));

    public MAFClampDataAdapter(ListModelPlug listModelPlug, boolean bl) {
        this.mdlVETbl = listModelPlug;
        this.isRPMShifted = bl;
        this.stockTemplate = bl ? this.STOCK_SHIFTED_TEMPLATE_VALUES : this.STOCK_TEMPLATE_VALUES;
        this.templateOptions = new TemplateOptions();
        this.templateOptions.addTemplate("None", null);
        this.templateOptions.addTemplate("Stock IM", this.stockTemplate);
        this.templateOptions.addTemplate("Sheet metal IM", bl ? this.SMIM_SHIFTED_TEMPLATE_VALUES : this.SMIM_TEMPLATE_VALUES);
        super.construct("99999");
        this.createLocalActions();
        this.populateTemplateOptions();
    }

    @Override
    protected ValueModel createRowHeaderColumnHeaderModel() {
        return new ValueHolder((Object)"RPM");
    }

    @Override
    protected ValueModel createDataColumnHeaderModel() {
        return new ValueHolder((Object)"VE (%)");
    }

    @Override
    protected ValueModel createTemplateColumnHeaderModel() {
        return new ValueHolder((Object)"Templ");
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.mdlVETbl;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return new ValueHolder((Object)(this.isRPMShifted ? xFloatListShifted : xFloatList));
    }

    @Override
    protected ValueModel createRawTemplateModel() {
        MAFClampV1Record mAFClampV1Record = new MAFClampV1Record(1);
        ArrayListModel arrayListModel = (ArrayListModel)mAFClampV1Record.getField("VETbl").getValue();
        Collections.fill(arrayListModel, new Float(0.0f));
        return new ValueHolder((Object)arrayListModel);
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.mdlVETbl.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    @Override
    protected int getDataPrec() {
        return 1;
    }

    @Override
    protected void handleNewTemplateSelectionIndex(int n) {
        if (n >= 0) {
            if (n == 0) {
                Collections.fill((List)this.rawTemplateModel.getValue(), new Float(0.0f));
            } else {
                Object[] objectArray = this.templateOptions.getTemplateValues(n);
                ListUtil.setContents((List)this.rawTemplateModel.getValue(), objectArray);
            }
        }
        boolean bl = n != 0;
        this.getUseTemplateAction().setEnabled(bl);
        this.getHideTemplateAction().setEnabled(bl);
        this.setTemplateVisible(bl);
    }

    private void populateTemplateOptions() {
        this.setTemplateSelectionNames(this.templateOptions.getTemplateNames());
        this.setTemplateSelectionIndex(null, new Integer(0));
    }

    public Action getUseTemplateAction() {
        return this.useTemplateAction;
    }

    public Action getHideTemplateAction() {
        return this.hideTemplateAction;
    }

    public Action getStockAction() {
        return this.stockAction;
    }

    MouseListener getPopupListener(final HandyJTable handyJTable) {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return MAFClampDataAdapter.this.buildPopupMenu(handyJTable);
            }
        };
    }

    private JPopupMenu buildPopupMenu(HandyJTable handyJTable) {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.getHideTemplateAction());
        popupMenuBuilder.add(this.getUseTemplateAction());
        popupMenuBuilder.addSeparator();
        AbstractAction abstractAction = new InterpListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "interpTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new SetListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new ScaleListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.getStockAction());
        return popupMenuBuilder.getPopupMenu();
    }

    void createTableActions(ChtTblBuilder chtTblBuilder) {
        this.copyTableAction = chtTblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = chtTblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    private void createLocalActions() {
        this.stockAction = new DispatchingAction("mafClampResetToStock");
        ECMLinkResources.configureAction(this.stockAction, "mafClampResetToStock");
        this.useTemplateAction = new DispatchingAction("useTemplate");
        ECMLinkResources.configureAction(this.useTemplateAction, "useTemplate");
        this.hideTemplateAction = new DispatchingAction("hideTemplate");
        ECMLinkResources.configureAction(this.hideTemplateAction, "hideTemplate");
    }

    static class TemplateOptions {
        ArrayList templateNames = new ArrayList();
        ArrayList templateValues = new ArrayList();

        TemplateOptions() {
        }

        void addTemplate(String string, float[] fArray) {
            this.templateNames.add(string);
            this.templateValues.add(ListUtil.convertToFloatArray(fArray));
        }

        ArrayList getTemplateNames() {
            return this.templateNames;
        }

        Number[] getTemplateValues(int n) {
            return (Number[])this.templateValues.get(n);
        }
    }

    private class DispatchingAction
    extends AbstractAction {
        private final String id;

        DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id == "mafClampResetToStock") {
                List list = (List)MAFClampDataAdapter.this.rawDataModel.getValue();
                for (int i = 0; i < MAFClampDataAdapter.this.stockTemplate.length; ++i) {
                    list.set(i, new Float(MAFClampDataAdapter.this.stockTemplate[i]));
                }
            } else if (this.id == "useTemplate") {
                List list = (List)MAFClampDataAdapter.this.rawDataModel.getValue();
                Collections.copy(list, (List)MAFClampDataAdapter.this.rawTemplateModel.getValue());
            } else if (this.id == "hideTemplate") {
                MAFClampDataAdapter.this.setTemplateSelectionIndex(null, new Integer(0));
            }
        }
    }
}

