/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.records.BaseField;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.UnpluggablePropertyAdapter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class MAFClampRecordModel
extends RecordModel {
    ListModelPlug mdlVETbl;
    ValueModelPlug mdlClampPoint;
    ValueModelPlug mdlMAPOffset;
    ValueModel mdlUseMDP;
    ValueModel mdlClampEnable;
    ValueModel mdlMAPInputX;
    Object mafClampRecordId;
    boolean isRPMShifted;
    private static final int[] MAF_CLAMP_RECORD_IDS = new int[]{9, 27, 39};

    MAFClampRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(MAF_CLAMP_RECORD_IDS, map);
        this.mafClampRecordId = baseRecord.getRecordID();
        this.isRPMShifted = !new Integer(9).equals(this.mafClampRecordId);
        this.mdlVETbl = this.track(this.mdlVETbl, baseRecord.numberListField("VETbl"));
        this.mdlClampPoint = this.track(this.mdlClampPoint, baseRecord.numberFieldAsString("MAFClampPnt"));
        if (baseRecord.hasFeature("mapOffsetFeature")) {
            this.mdlMAPOffset = this.track(this.mdlMAPOffset, baseRecord.getFeaturePlug("mapOffsetFeature"));
        }
        BaseField baseField = baseRecord.getField("MAFClampPnt");
        this.mdlUseMDP = this.track(this.mdlUseMDP, new UnpluggablePropertyAdapter(baseField, "useMDP"));
        this.mdlClampEnable = this.track(this.mdlClampEnable, new UnpluggablePropertyAdapter(baseField, "clampEnable"));
        BaseRecord baseRecord2 = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        if (baseRecord2 != null && baseRecord2.hasFeature("mapInputX")) {
            ValueModelPlug valueModelPlug = baseRecord2.getFeaturePlug("mapInputX");
            this.track(null, valueModelPlug, false);
            if (this.doingPersistedCreate) {
                this.mdlMAPInputX = valueModelPlug;
            }
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(MAF_CLAMP_RECORD_IDS, map);
        return baseRecord != null && baseRecord.getRecordID().equals(this.mafClampRecordId);
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(MAF_CLAMP_RECORD_IDS, map);
    }
}

