/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFClampDataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFClampRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.component.UIFButton;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public class MAFClampRecordView
extends AbstractView {
    private JComboBox comboTemplate;
    private JButton btnUseTemplate;
    private JCheckBox cbEnableMAFClamp;
    private JCheckBox cbUseMAP;
    private JSpinner spnrMAPOffset;
    private JSpinner spnrSwitchover;
    private JLabel lblMapOffset;
    private JLabel lblMapOffsetUnits;
    private MAFClampDataAdapter dataAdapter;
    private ChtTblBuilder chtTblBuilder;
    private final MAFClampRecordModel model;
    private final SettingsTab parentTab;
    ActionLabel inputsTabActionLabel;

    public MAFClampRecordView(MAFClampRecordModel mAFClampRecordModel, SettingsTab settingsTab) {
        this.model = mAFClampRecordModel;
        this.parentTab = settingsTab;
    }

    public void resetViewport() {
        this.chtTblBuilder.getChart().resetViewport();
    }

    public Component getDefaultFocusComponent() {
        return this.chtTblBuilder.getChart();
    }

    private void initComponents() {
        this.dataAdapter = new MAFClampDataAdapter(this.model.mdlVETbl, this.model.isRPMShifted);
        this.chtTblBuilder = new ChtTblBuilder(this.dataAdapter);
        this.dataAdapter.createTableActions(this.chtTblBuilder);
        this.initTable();
        this.initChart();
        this.dataAdapter.addPropertyChangeListener("templateSelectionIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = ((Number)propertyChangeEvent.getNewValue()).intValue();
                MAFClampRecordView.this.dataAdapter.setTemplateVisible(n != 0);
            }
        });
        SelectionInList selectionInList = new SelectionInList((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionNames", true));
        selectionInList.setSelectionIndexHolder((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionIndex", true));
        this.comboTemplate = new JComboBox(new ComboBoxAdapter(selectionInList));
        this.btnUseTemplate = new UIFButton(this.dataAdapter.getUseTemplateAction());
        this.cbEnableMAFClamp = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlClampEnable, (String)"Enable MAF clamp function");
        this.cbEnableMAFClamp.setToolTipText("Activates a MAF clamp function when MAF frequency exceeds the switchover point");
        this.cbUseMAP = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlUseMDP, (String)"Use manifold pressure (MAP)");
        this.cbUseMAP.setToolTipText("Enables the use of a pressure sensor input to fine tune the MAF clamp operation");
        this.spnrSwitchover = DialogUtil.createSpinnerTextField(this.model.mdlClampPoint, "The point above which airflow data will be extrapolated from VE");
        if (this.model.mdlMAPOffset != null) {
            this.spnrMAPOffset = DialogUtil.createSpinnerTextField(this.model.mdlMAPOffset, "A voltage offset subtracted from the MAP sensor signal to zero it");
            this.lblMapOffset = new JLabel("MAP offset:");
            this.lblMapOffsetUnits = new JLabel("volts");
            DialogUtil.installComponentEnabler(this.model.mdlUseMDP, new Component[]{this.spnrMAPOffset, this.lblMapOffset, this.lblMapOffsetUnits});
        }
        if (this.model.mdlMAPInputX != null) {
            Action action = this.parentTab.createTabAction(ECUIOTab.class);
            this.inputsTabActionLabel = new ActionLabel(action);
            this.model.mdlMAPInputX.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MAFClampRecordView.this.setUseMapEnable();
                }
            });
            this.setUseMapEnable();
        }
    }

    void setUseMapEnable() {
        boolean bl = ((Number)this.model.mdlMAPInputX.getValue()).intValue() != 0;
        boolean bl2 = bl && this.cbUseMAP.isSelected();
        this.cbUseMAP.setEnabled(bl);
        if (this.model.mdlMAPOffset != null) {
            this.spnrMAPOffset.setEnabled(bl2);
            this.lblMapOffset.setEnabled(bl2);
            this.lblMapOffsetUnits.setEnabled(bl2);
        }
        if (!bl) {
            this.inputsTabActionLabel.setForeground(Color.RED);
            this.inputsTabActionLabel.setText("To enable, assign MAP input pin\u2026");
        } else {
            this.inputsTabActionLabel.setForeground(Color.BLUE);
            this.inputsTabActionLabel.setText("Edit MAP input pin assignment\u2026");
        }
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        FloatRect floatRect = new FloatRect();
        float f = this.model.isRPMShifted ? 2000.0f : 0.0f;
        floatRect.setCorners(-400.0f + f, 45.0f, 8400.0f + f, 115.0f);
        this.dataAdapter.setMaxViewportForDisplayType(BaseTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect);
        FloatRect floatRect2 = new FloatRect(0.0f, 0.0f, 500.0f, 5.0f);
        this.dataAdapter.setGridForDisplayType(BaseTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect2);
        chart.setXAxisLoc(0.0f + f);
        chart.setYAxisLoc(50.0f);
        this.chtTblBuilder.setStandardPlotDescs();
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        handyJTable.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.FILL_MIN_GROW_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec2, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("MAF Clamp VE Table", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.chtTblBuilder.getPanel(), cellConstraints.xy(2, 3));
        panelBuilder.addSeparator("Options", cellConstraints.xyw(1, 5, 2));
        panelBuilder.add((Component)this.buildOptionPanel(), cellConstraints.xy(2, 7));
        panelBuilder.addSeparator("Settings", cellConstraints.xyw(1, 9, 2));
        panelBuilder.add((Component)this.buildSettingsPanel(), cellConstraints.xy(2, 11));
        return panelBuilder.getPanel();
    }

    protected JComponent buildOptionPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{3, 5}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel("Display template:", cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.comboTemplate, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.btnUseTemplate, cellConstraints.xy(5, n));
        return panelBuilder.getPanel();
    }

    protected JComponent buildSettingsPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.RELATED_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.cbEnableMAFClamp, cellConstraints.xy(1, n));
        DialogUtil.addTriplet(panelBuilder, "Clamp switchover:", this.spnrSwitchover, "hz", cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.cbUseMAP, cellConstraints.xy(1, n += 2));
        if (this.model.mdlMAPOffset != null) {
            DialogUtil.addTriplet(panelBuilder, this.lblMapOffset, this.spnrMAPOffset, this.lblMapOffsetUnits, cellConstraints.xy(3, n));
        }
        if (this.inputsTabActionLabel != null) {
            if (this.model.mdlMAPOffset != null) {
                panelBuilder.add((Component)this.inputsTabActionLabel, cellConstraints.xy(9, n));
            } else {
                panelBuilder.add((Component)this.inputsTabActionLabel, cellConstraints.xyw(3, n, 7));
            }
        }
        return panelBuilder.getPanel();
    }
}

