/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;

class MAFScaleDialog
extends AbstractDialog {
    private final SpinnerModel newScalarModel;
    private final String initialScalar;
    private final String centerScalar;
    private String newScalar;
    JComponent contentPanel;

    public MAFScaleDialog(JFrame jFrame, String string, String string2, SpinnerModel spinnerModel) {
        super((Frame)jFrame);
        this.setTitle(ECMLinkResources.getString("ecmlink.globalmafdialog.title"));
        this.initialScalar = string;
        this.centerScalar = string2;
        this.newScalarModel = spinnerModel;
    }

    float getNewScalar() {
        return XFormatter.parse(this.newScalar);
    }

    public void doApply() {
        this.newScalar = (String)this.newScalarModel.getValue();
        super.doApply();
    }

    protected JComponent buildContent() {
        if (this.contentPanel == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buildCenterPanel(), "Center");
            jPanel.add((Component)this.buildButtonBarWithOKCancel(), "South");
            this.contentPanel = jPanel;
        }
        return this.contentPanel;
    }

    protected JComponent buildCenterPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        ValueModelPlug valueModelPlug = new ValueModelPlug((ValueModel)new ValueHolder((Object)this.initialScalar), null);
        JSpinner jSpinner = DialogUtil.createSpinnerTextField(valueModelPlug, "Current global scalar value");
        jSpinner.setEnabled(false);
        panelBuilder.addLabel("Current global scalar:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jSpinner, cellConstraints.xy(3, 1));
        panelBuilder.addLabel("%", cellConstraints.xy(5, 1));
        JSpinner jSpinner2 = DialogUtil.createSpinngerTextField(this.newScalarModel, "New global scalar value");
        panelBuilder.addLabel("New global scalar:", cellConstraints.xy(1, 3));
        panelBuilder.add((Component)jSpinner2, cellConstraints.xy(3, 3));
        panelBuilder.addLabel("%", cellConstraints.xy(5, 3));
        JButton jButton = new JButton("Auto Adj");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MAFScaleDialog.this.newScalarModel.setValue(MAFScaleDialog.this.centerScalar);
            }
        });
        panelBuilder.add((Component)jButton, cellConstraints.xy(3, 5));
        return panelBuilder.getPanel();
    }
}

