/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV2Record;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.ObjectListFilter;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.InterpListValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleListValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetListValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2RecordModel;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public final class MAFV2DataAdapter
extends ChtTblDataAdapter {
    public static final String PROPERTYNAME_MAF_TYPE = "mafType";
    public static final Integer DISPLAY_TYPE_PERCENT = new Integer(0);
    public static final Integer DISPLAY_TYPE_FREQUENCY = new Integer(1);
    public static final String HEADER_OUTPUT_ADJ = "Adj %";
    public static final String HEADER_OUTPUT_FREQ = "Out (hz)";
    Integer mafType = new Integer(1);
    ValueModel dataColumnHeader = new ValueHolder((Object)"Adj %");
    ListModelPlug mdlCompTbl;
    final MAFV2RecordModel recordModel;
    Action zeroAction;
    Action useTemplateAction;
    Action hideTemplateAction;
    ToggleAction percentToggleAction;
    ToggleAction frequencyToggleAction;
    private static ArrayList templateOptionsForMAFType = new ArrayList();
    private ObjectListFilter localOutputFilter = new ObjectListFilter(){

        @Override
        public Object filter(Object object, int n) {
            float f = ((Number)object).floatValue();
            if (DISPLAY_TYPE_FREQUENCY.equals(MAFV2DataAdapter.this.getDisplayType())) {
                f = (f + 100.0f) / 100.0f * xIndices[n];
            }
            return new Float(f);
        }

        @Override
        public Object unfilter(Object object, int n, Object object2) throws Exception {
            float f = ((Number)object).floatValue();
            if (DISPLAY_TYPE_FREQUENCY.equals(MAFV2DataAdapter.this.getDisplayType()) && xIndices[n] > 0.0f) {
                f = f / xIndices[n] * 100.0f - 100.0f;
            }
            return new Float(f);
        }
    };
    private static float[] xIndices;
    private static ArrayListModel xFloatList;

    public MAFV2DataAdapter(MAFV2RecordModel mAFV2RecordModel) {
        this.recordModel = mAFV2RecordModel;
        this.mdlCompTbl = mAFV2RecordModel.mdlCompTbl;
        super.construct(new String[]{HEADER_OUTPUT_ADJ, HEADER_OUTPUT_FREQ, "99999"});
        this.createLocalActions();
        this.populateTemplateOptions();
    }

    @Override
    protected ValueModel createRowHeaderColumnHeaderModel() {
        return new ValueHolder((Object)"In (hz)");
    }

    @Override
    protected ValueModel createDataColumnHeaderModel() {
        return this.dataColumnHeader;
    }

    @Override
    protected ValueModel createTemplateColumnHeaderModel() {
        return new ValueHolder((Object)"Templ");
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.mdlCompTbl;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return new ValueHolder((Object)xFloatList);
    }

    @Override
    protected ValueModel createRawTemplateModel() {
        MAFV2Record mAFV2Record = new MAFV2Record(1);
        ArrayListModel arrayListModel = (ArrayListModel)mAFV2Record.getField("MafComp").getValue();
        Collections.fill(arrayListModel, new Float(0.0f));
        return new ValueHolder((Object)arrayListModel);
    }

    @Override
    protected void addDataFilters(ListModelPlug listModelPlug) {
        listModelPlug.addObjectListFilter(this.localOutputFilter);
    }

    @Override
    protected void handleNewDisplayType() {
        if (this.getDisplayType() == DISPLAY_TYPE_PERCENT) {
            this.dataColumnHeader.setValue((Object)HEADER_OUTPUT_ADJ);
        } else {
            this.dataColumnHeader.setValue((Object)HEADER_OUTPUT_FREQ);
        }
    }

    @Override
    protected void handleNewTemplateSelectionIndex(int n) {
        MAFTemplateOptions mAFTemplateOptions = (MAFTemplateOptions)templateOptionsForMAFType.get(this.mafType);
        if (n >= 0) {
            if (n == 0) {
                Collections.fill((List)this.rawTemplateModel.getValue(), new Float(0.0f));
            } else {
                Object[] objectArray = mAFTemplateOptions.getTemplateValues(n);
                ListUtil.setContents((List)this.rawTemplateModel.getValue(), objectArray);
            }
        }
        boolean bl = n != 0;
        this.getUseTemplateAction().setEnabled(bl);
        this.getHideTemplateAction().setEnabled(bl);
        this.setTemplateVisible(bl);
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.mdlCompTbl.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    public float[] getXIndices() {
        return xIndices;
    }

    public float[] getPersistedValuesCopy() {
        ArrayListModel arrayListModel = this.recordModel.persistedMdlCompTbl.getLocalArrayListValue();
        float[] fArray = new float[xIndices.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Number)arrayListModel.get(i)).floatValue();
        }
        return fArray;
    }

    public void setGeneratedTemplateData(float[] fArray) {
        Object[] objectArray = ListUtil.convertToFloatArray(fArray);
        this.setTemplateSelectionIndex(null, new Integer(0));
        ListUtil.setContents((List)this.rawTemplateModel.getValue(), objectArray);
        this.getUseTemplateAction().setEnabled(true);
        this.getHideTemplateAction().setEnabled(true);
        this.setTemplateVisible(Boolean.TRUE);
    }

    @Override
    protected int getDataPrec() {
        return 1;
    }

    private void populateTemplateOptions() {
        MAFTemplateOptions mAFTemplateOptions = (MAFTemplateOptions)templateOptionsForMAFType.get(this.mafType);
        this.setTemplateSelectionNames(mAFTemplateOptions.getTemplateNames());
        this.setTemplateSelectionIndex(null, new Integer(0));
    }

    public Integer getMafType() {
        return this.mafType;
    }

    public void setMafType(Integer n) {
        Integer n2 = this.mafType;
        if (!n2.equals(n)) {
            this.mafType = n;
            this.populateTemplateOptions();
            this.firePropertyChange(PROPERTYNAME_MAF_TYPE, n2, n);
        }
    }

    public Action getUseTemplateAction() {
        return this.useTemplateAction;
    }

    public Action getHideTemplateAction() {
        return this.hideTemplateAction;
    }

    public ToggleAction getFrequencyToggleAction() {
        return this.frequencyToggleAction;
    }

    public ToggleAction getPercentToggleAction() {
        return this.percentToggleAction;
    }

    public Action getZeroAction() {
        return this.zeroAction;
    }

    MouseListener getPopupListener(final HandyJTable handyJTable) {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return MAFV2DataAdapter.this.buildPopupMenu(handyJTable);
            }
        };
    }

    private JPopupMenu buildPopupMenu(HandyJTable handyJTable) {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        AbstractAction abstractAction = new InterpListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "interpTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new SetListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new ScaleListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.getHideTemplateAction());
        popupMenuBuilder.add(this.getUseTemplateAction());
        popupMenuBuilder.add(this.getZeroAction());
        return popupMenuBuilder.getPopupMenu();
    }

    private void createLocalActions() {
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)this, "displayType", true);
        this.percentToggleAction = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_PERCENT);
        ECMLinkResources.configureAction((Action)this.percentToggleAction, "mafV2EditPercent");
        this.frequencyToggleAction = ToggleAction.createRadio((ValueModel)propertyAdapter, (Object)DISPLAY_TYPE_FREQUENCY);
        ECMLinkResources.configureAction((Action)this.frequencyToggleAction, "mafV2EditFrequency");
        this.zeroAction = new DispatchingAction("zeroAdjustments");
        ECMLinkResources.configureAction(this.zeroAction, "zeroAdjustments");
        this.useTemplateAction = new DispatchingAction("useTemplate");
        ECMLinkResources.configureAction(this.useTemplateAction, "useTemplate");
        this.hideTemplateAction = new DispatchingAction("hideTemplate");
        ECMLinkResources.configureAction(this.hideTemplateAction, "hideTemplate");
    }

    static {
        MAFTemplateOptions mAFTemplateOptions = new MAFTemplateOptions(0);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 1G", new float[]{9.375f, 5.47f, 5.47f, 3.125f, 2.34f, 3.9f, 1.56f, 1.56f, 1.56f});
        templateOptionsForMAFType.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFTemplateOptions(1);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 2G", new float[]{48.0f, 30.0f, 25.0f, 22.0f, 17.0f, 13.0f, 13.0f, 13.0f, 13.0f});
        mAFTemplateOptions.addTemplate("Stock EVO8", new float[]{31.0f, 25.0f, 23.0f, 23.0f, 25.0f, 27.0f, 27.0f, 27.0f, 27.0f});
        mAFTemplateOptions.addTemplate("Stock 3G", new float[]{31.0f, 25.0f, 23.0f, 23.0f, 25.0f, 27.0f, 27.0f, 27.0f, 27.0f});
        templateOptionsForMAFType.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFTemplateOptions(2);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType.add(mAFTemplateOptions);
        xIndices = new float[]{50.0f, 150.0f, 250.0f, 400.0f, 800.0f, 1200.0f, 1600.0f, 2000.0f, 2400.0f};
        xFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(xIndices)));
    }

    static class MAFTemplateOptions {
        int mafType;
        ArrayList templateNames = new ArrayList();
        ArrayList templateValues = new ArrayList();

        MAFTemplateOptions(int n) {
            this.mafType = n;
        }

        void addTemplate(String string, float[] fArray) {
            this.templateNames.add(string);
            this.templateValues.add(ListUtil.convertToFloatArray(fArray));
        }

        ArrayList getTemplateNames() {
            return this.templateNames;
        }

        int getTemplateValuesSize() {
            return this.templateValues.size();
        }

        Number[] getTemplateValues(int n) {
            return (Number[])this.templateValues.get(n);
        }
    }

    private class DispatchingAction
    extends AbstractAction {
        private final String id;

        DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id == "zeroAdjustments") {
                List list = (List)MAFV2DataAdapter.this.rawDataModel.getValue();
                Collections.fill(list, new Float(0.0f));
            } else if (this.id == "useTemplate") {
                List list = (List)MAFV2DataAdapter.this.rawDataModel.getValue();
                Collections.copy(list, (List)MAFV2DataAdapter.this.rawTemplateModel.getValue());
            } else if (this.id == "hideTemplate") {
                MAFV2DataAdapter.this.setTemplateSelectionIndex(null, new Integer(0));
            }
        }
    }
}

