/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import java.util.Map;

class MAFV2RecordModel
extends RecordModel {
    ListModelPlug mdlCompTbl;
    ListModelPlug persistedMdlCompTbl;
    ValueModelPlug mdlMafSelector;
    boolean v2Ind;
    static final int[] compatibleRecordIds = new int[]{6, 15};

    MAFV2RecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    boolean isV2() {
        return this.v2Ind;
    }

    @Override
    protected void initAndTrackModels(Map map) {
        if (RecordSet.containsRecordId(15, map)) {
            this.v2Ind = true;
        }
        BaseRecord baseRecord = RecordSet.getRecord(compatibleRecordIds, map);
        ListModelPlug listModelPlug = baseRecord.numberListField("MafComp");
        if (this.doingPersistedCreate) {
            this.persistedMdlCompTbl = listModelPlug;
        }
        this.mdlCompTbl = this.track(this.mdlCompTbl, listModelPlug);
        if (this.v2Ind) {
            this.mdlMafSelector = this.track(this.mdlMafSelector, baseRecord.numberFieldAsInteger("MAFSelect"));
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        boolean bl = RecordSet.containsRecordId(6, map);
        boolean bl2 = RecordSet.containsRecordId(15, map);
        return this.isV2() ? bl2 : bl;
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(compatibleRecordIds, map);
    }
}

