/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.Number2IntegerFilter;
import com.ecmtuning.ecmlink.util.model.PropertyConnector2;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2DataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2RecordModel;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.component.UIFButton;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class MAFV2RecordView
extends AbstractView {
    private JComboBox comboBaseMaf;
    private JComboBox comboTemplate;
    private JButton btnUseTemplate;
    private MAFV2DataAdapter dataAdapter;
    private ChtTblBuilder chtTblBuilder;
    private final MAFV2RecordModel model;
    private static final List baseMafChoices = Arrays.asList("1G DSM", "2G DSM", "VR4");

    public MAFV2RecordView(MAFV2RecordModel mAFV2RecordModel) {
        this.model = mAFV2RecordModel;
    }

    public void resetViewport() {
        this.chtTblBuilder.getChart().resetViewport();
    }

    public MAFV2DataAdapter getDataAdapter() {
        return this.dataAdapter;
    }

    public Component getDefaultFocusComponent() {
        return this.chtTblBuilder.getChart();
    }

    private void initComponents() {
        this.dataAdapter = new MAFV2DataAdapter(this.model);
        this.chtTblBuilder = new ChtTblBuilder(this.dataAdapter);
        this.initTable();
        this.initChart();
        SelectionInList selectionInList = new SelectionInList((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionNames", true));
        selectionInList.setSelectionIndexHolder((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionIndex", true));
        this.comboTemplate = new JComboBox(new ComboBoxAdapter(selectionInList));
        this.btnUseTemplate = new UIFButton(this.dataAdapter.getUseTemplateAction());
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        FloatRect floatRect = new FloatRect();
        FloatRect floatRect2 = new FloatRect();
        floatRect.setCorners(50.0f, -50.0f, 2400.0f, 70.0f);
        floatRect2.setCorners(50.0f, 0.0f, 2400.0f, 3500.0f);
        this.dataAdapter.setMaxViewportForDisplayType(MAFV2DataAdapter.DISPLAY_TYPE_PERCENT, floatRect);
        this.dataAdapter.setMaxViewportForDisplayType(MAFV2DataAdapter.DISPLAY_TYPE_FREQUENCY, floatRect2);
        FloatRect floatRect3 = new FloatRect(0.0f, 0.0f, 100.0f, 10.0f);
        FloatRect floatRect4 = new FloatRect(0.0f, 0.0f, 100.0f, 500.0f);
        this.dataAdapter.setGridForDisplayType(MAFV2DataAdapter.DISPLAY_TYPE_PERCENT, floatRect3);
        this.dataAdapter.setGridForDisplayType(MAFV2DataAdapter.DISPLAY_TYPE_FREQUENCY, floatRect4);
        chart.setXAxisLoc(0.0f);
        chart.setYAxisLoc(0.0f);
        this.chtTblBuilder.setStandardPlotDescs();
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        handyJTable.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
        if (this.model.isV2()) {
            PropertyConnector2 propertyConnector2 = new PropertyConnector2(this.model.mdlMafSelector, "value", (Object)this.dataAdapter, "mafType");
            propertyConnector2.setValueFilter(new Number2IntegerFilter());
            propertyConnector2.updateProperty2();
            SelectionInList selectionInList = new SelectionInList(baseMafChoices);
            selectionInList.setSelectionIndexHolder((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "mafType", true));
            this.comboBaseMaf = new JComboBox(new ComboBoxAdapter(selectionInList));
        } else {
            this.dataAdapter.setMafType(new Integer(1));
        }
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.FILL_DEFAULT_GROW_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec2, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Active MAF Compensation", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.chtTblBuilder.getPanel(), cellConstraints.xy(2, 3));
        panelBuilder.addSeparator("Options", cellConstraints.xyw(1, 5, 2));
        panelBuilder.add((Component)this.buildOptionPanel(), cellConstraints.xy(2, 7));
        return panelBuilder.getPanel();
    }

    protected JComponent buildOptionPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        if (this.model.isV2()) {
            arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
            arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        }
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{3, 5}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        if (this.model.isV2()) {
            panelBuilder.addLabel("Base MAF type:", cellConstraints.xy(1, n));
            panelBuilder.add((Component)this.comboBaseMaf, cellConstraints.xy(3, n));
            n += 2;
        }
        panelBuilder.addLabel("Display template:", cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.comboTemplate, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.btnUseTemplate, cellConstraints.xy(5, n));
        return panelBuilder.getPanel();
    }
}

