/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV3Record;
import com.ecmtuning.ecmlink.device.ecmlink.records.MAFV5Record;
import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.Float8SpinnerModel;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.InterpListValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleListValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetListValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFScaleDialog;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2DataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3RecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import com.jgoodies.uifextras.util.PopupAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public final class MAFV3DataAdapter
extends ChtTblDataAdapter {
    public static final String PROPERTYNAME_MAF_TYPE = "mafType";
    public static final String HEADER_OUTPUT_ADJ = "Adj %";
    Integer mafType = new Integer(0);
    final ValueModel dataColumnHeader = new ValueHolder((Object)"Adj %");
    final MAFV3RecordModel recordModel;
    final ArrayList templateOptionsForMAFType;
    Action changeGlobalAction;
    Action zeroAction;
    Action useTemplateAction;
    Action hideTemplateAction;
    Action copyTableAction;
    Action pasteTableAction;
    public static float[] GVR4_MAF_COMP_TABLE = new float[]{11.33f, 9.38f, 7.42f, 5.47f, 5.47f, 5.47f, 4.3f, 3.13f, 2.93f, 2.74f, 2.54f, 2.34f, 2.73f, 3.12f, 3.51f, 3.9f, 3.32f, 2.73f, 2.15f, 1.56f};
    public static float[] HACKED_2G_MAF_COMP_TABLE = new float[]{57.0f, 48.0f, 39.0f, 30.0f, 27.5f, 25.0f, 23.5f, 22.0f, 20.75f, 19.5f, 18.25f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f};
    private static ArrayList templateOptionsForMAFType1GV3 = new ArrayList();
    private static ArrayList templateOptionsForMAFType2GV3 = new ArrayList();
    private static ArrayList templateOptionsForMAFType1GV5 = new ArrayList();
    private static ArrayList templateOptionsForMAFType2GV5 = new ArrayList();
    private static float[] v34xIndices;
    private static ArrayListModel v34xFloatList;
    private static float[] v5xIndices;
    private static ArrayListModel v5xFloatList;

    public MAFV3DataAdapter(MAFV3RecordModel mAFV3RecordModel) {
        this.recordModel = mAFV3RecordModel;
        super.construct(new String[]{HEADER_OUTPUT_ADJ, "99999"});
        this.createLocalActions();
        this.templateOptionsForMAFType = mAFV3RecordModel.isV3MAFComp || mAFV3RecordModel.isV4MAFComp ? (ECMLinkDeviceMap.is1GDSMDevice(mAFV3RecordModel.deviceId) ? templateOptionsForMAFType1GV3 : templateOptionsForMAFType2GV3) : (mAFV3RecordModel.isV5MAFComp ? (ECMLinkDeviceMap.is1GDSMDevice(mAFV3RecordModel.deviceId) ? templateOptionsForMAFType1GV5 : templateOptionsForMAFType2GV5) : null);
        this.populateTemplateOptions();
    }

    @Override
    protected ValueModel createRowHeaderColumnHeaderModel() {
        return new ValueHolder((Object)"In (hz)");
    }

    @Override
    protected ValueModel createDataColumnHeaderModel() {
        return this.dataColumnHeader;
    }

    @Override
    protected ValueModel createTemplateColumnHeaderModel() {
        return new ValueHolder((Object)"Templ");
    }

    @Override
    protected ValueModel createRawDataModel() {
        return this.recordModel.mdlCompTbl;
    }

    @Override
    protected ValueModel createRawRowHeaderModel() {
        return new ValueHolder((Object)(this.recordModel.isV5MAFComp ? v5xFloatList : v34xFloatList));
    }

    @Override
    protected ValueModel createRawTemplateModel() {
        MAFV3Record mAFV3Record = this.recordModel.isV5MAFComp ? new MAFV5Record(3) : new MAFV3Record(3);
        ArrayListModel arrayListModel = (ArrayListModel)mAFV3Record.getField("MafComp").getValue();
        Collections.fill(arrayListModel, new Float(0.0f));
        return new ValueHolder((Object)arrayListModel);
    }

    @Override
    protected void handleNewTemplateSelectionIndex(int n) {
        MAFV2DataAdapter.MAFTemplateOptions mAFTemplateOptions = (MAFV2DataAdapter.MAFTemplateOptions)this.templateOptionsForMAFType.get(this.mafType);
        if (mAFTemplateOptions == null || n < 0) {
            n = 0;
        } else if (n >= mAFTemplateOptions.getTemplateValuesSize()) {
            n = 0;
        }
        if (n == 0) {
            Collections.fill((List)this.rawTemplateModel.getValue(), new Float(0.0f));
        } else {
            Object[] objectArray = mAFTemplateOptions.getTemplateValues(n);
            ListUtil.setContents((List)this.rawTemplateModel.getValue(), objectArray);
        }
        boolean bl = n != 0;
        this.getUseTemplateAction().setEnabled(bl);
        this.getHideTemplateAction().setEnabled(bl);
        this.setTemplateVisible(bl);
    }

    @Override
    protected Number calculateNextRawValue(Number number, boolean bl) {
        Float8Field float8Field = (Float8Field)this.recordModel.mdlCompTbl.getSubject();
        return bl ? float8Field.nextStepValue((Float)number) : float8Field.previousStepValue((Float)number);
    }

    public float[] getXIndices() {
        return this.recordModel.isV5MAFComp ? v5xIndices : v34xIndices;
    }

    public float[] getPersistedValuesCopy() {
        ArrayListModel arrayListModel = this.recordModel.persistedMdlCompTbl.getLocalArrayListValue();
        float[] fArray = new float[arrayListModel.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Number)arrayListModel.get(i)).floatValue();
        }
        return fArray;
    }

    public void setGeneratedTemplateData(float[] fArray) {
        Object[] objectArray = ListUtil.convertToFloatArray(fArray);
        this.setTemplateSelectionIndex(null, new Integer(0));
        ListUtil.setContents((List)this.rawTemplateModel.getValue(), objectArray);
        this.getUseTemplateAction().setEnabled(true);
        this.getHideTemplateAction().setEnabled(true);
        this.setTemplateVisible(Boolean.TRUE);
    }

    @Override
    protected int getDataPrec() {
        return 1;
    }

    private void populateTemplateOptions() {
        MAFV2DataAdapter.MAFTemplateOptions mAFTemplateOptions = (MAFV2DataAdapter.MAFTemplateOptions)this.templateOptionsForMAFType.get(this.mafType);
        this.setTemplateSelectionNames(mAFTemplateOptions.getTemplateNames());
        this.setTemplateSelectionIndex(null, new Integer(0));
    }

    public Integer getMafType() {
        return this.mafType;
    }

    public void setMafType(Integer n) {
        Integer n2 = this.mafType;
        if (!n2.equals(n)) {
            this.mafType = n;
            this.populateTemplateOptions();
            this.firePropertyChange(PROPERTYNAME_MAF_TYPE, n2, n);
        }
    }

    public Action getUseTemplateAction() {
        return this.useTemplateAction;
    }

    public Action getHideTemplateAction() {
        return this.hideTemplateAction;
    }

    public Action getZeroAction() {
        return this.zeroAction;
    }

    public Action getChangeGlobalAction() {
        return this.changeGlobalAction;
    }

    MouseListener getPopupListener(final HandyJTable handyJTable) {
        return new PopupAdapter(true){

            protected JPopupMenu buildPopupMenu(MouseEvent mouseEvent) {
                return MAFV3DataAdapter.this.buildPopupMenu(handyJTable);
            }
        };
    }

    private JPopupMenu buildPopupMenu(HandyJTable handyJTable) {
        PopupMenuBuilder popupMenuBuilder = new PopupMenuBuilder((String)null);
        popupMenuBuilder.add(this.copyTableAction);
        popupMenuBuilder.add(this.pasteTableAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.hideTemplateAction);
        popupMenuBuilder.add(this.useTemplateAction);
        popupMenuBuilder.addSeparator();
        AbstractAction abstractAction = new InterpListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "interpTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new SetListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        abstractAction = new ScaleListValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        popupMenuBuilder.add((Action)abstractAction);
        popupMenuBuilder.addSeparator();
        popupMenuBuilder.add(this.changeGlobalAction);
        popupMenuBuilder.add(this.zeroAction);
        return popupMenuBuilder.getPopupMenu();
    }

    private void createLocalActions() {
        this.zeroAction = new DispatchingAction("zeroAdjustments");
        ECMLinkResources.configureAction(this.zeroAction, "zeroAdjustments");
        this.changeGlobalAction = new DispatchingAction("changeGlobalMAF");
        ECMLinkResources.configureAction(this.changeGlobalAction, "changeGlobalMAF");
        this.useTemplateAction = new DispatchingAction("useTemplate");
        ECMLinkResources.configureAction(this.useTemplateAction, "useTemplate");
        this.hideTemplateAction = new DispatchingAction("hideTemplate");
        ECMLinkResources.configureAction(this.hideTemplateAction, "hideTemplate");
    }

    void createTableActions(ChtTblBuilder chtTblBuilder) {
        this.copyTableAction = chtTblBuilder.getDataTable().getCopyAction();
        ECMLinkResources.configureAction(this.copyTableAction, "copyTable");
        this.pasteTableAction = chtTblBuilder.getDataTable().getPasteAction();
        ECMLinkResources.configureAction(this.pasteTableAction, "pasteTable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScaleAction() {
        String string = (String)this.recordModel.mdlGlobalMAFAdj.getValue();
        List list = (List)this.rawDataModel.getValue();
        float f = (XFormatter.parse(string) + 100.0f) / 100.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            float f4 = f * (((Number)list.get(i)).floatValue() + 100.0f) / 100.0f;
            if (f4 < f2) {
                f2 = f4;
            }
            if (!(f4 > f3)) continue;
            f3 = f4;
        }
        float f5 = (f2 + f3) / 2.0f;
        String string2 = Float.toString(f5 * 100.0f - 100.0f);
        Float8SpinnerModel float8SpinnerModel = new Float8SpinnerModel(this.recordModel.mdlGlobalMAFAdj);
        boolean bl = false;
        try {
            MAFScaleDialog mAFScaleDialog = new MAFScaleDialog(MainModel.getDefaultParentFrame(), string, string2, float8SpinnerModel);
            mAFScaleDialog.open();
            if (!mAFScaleDialog.hasBeenCanceled()) {
                float f6;
                float f7 = XFormatter.parse(string);
                if (f7 != (f6 = mAFScaleDialog.getNewScalar())) {
                    float f8 = (f7 + 100.0f) / (f6 + 100.0f);
                    for (int i = 0; i < list.size(); ++i) {
                        float f9 = ((Number)list.get(i)).floatValue();
                        list.set(i, new Float((f9 + 100.0f) * f8 - 100.0f));
                    }
                }
                bl = true;
            }
        }
        finally {
            float8SpinnerModel.unplug();
            if (!bl) {
                this.recordModel.mdlGlobalMAFAdj.setValue(string);
            }
        }
    }

    public static float[] fillV3Template(float[] fArray) {
        float[] fArray2 = new float[40];
        Arrays.fill(fArray2, fArray[fArray.length - 1]);
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static float[] fillV5Template(float[] fArray) {
        float[] fArray2 = new float[28];
        Arrays.fill(fArray2, fArray[fArray.length - 1]);
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    static {
        MAFV2DataAdapter.MAFTemplateOptions mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(0);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 2G", MAFV3DataAdapter.fillV3Template(new float[]{57.0f, 48.0f, 39.0f, 30.0f, 27.5f, 25.0f, 23.5f, 22.0f, 20.75f, 19.5f, 18.25f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f}));
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(0);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 1G", MAFV3DataAdapter.fillV3Template(GVR4_MAF_COMP_TABLE));
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(1);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(2);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(3);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(4);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 2G", MAFV3DataAdapter.fillV3Template(HACKED_2G_MAF_COMP_TABLE));
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(5);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(6);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV3.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV3.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(0);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 2G", MAFV3DataAdapter.fillV5Template(new float[]{57.0f, 48.0f, 39.0f, 30.0f, 27.5f, 25.0f, 23.5f, 22.0f, 20.75f, 19.5f, 18.25f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f}));
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(0);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 1G", MAFV3DataAdapter.fillV5Template(GVR4_MAF_COMP_TABLE));
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(1);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(2);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(3);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(4);
        mAFTemplateOptions.addTemplate("None", null);
        mAFTemplateOptions.addTemplate("Hacked 2G", MAFV3DataAdapter.fillV5Template(HACKED_2G_MAF_COMP_TABLE));
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(5);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        mAFTemplateOptions = new MAFV2DataAdapter.MAFTemplateOptions(6);
        mAFTemplateOptions.addTemplate("None", null);
        templateOptionsForMAFType2GV5.add(mAFTemplateOptions);
        templateOptionsForMAFType1GV5.add(mAFTemplateOptions);
        v34xIndices = new float[]{0.0f, 50.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 400.0f, 500.0f, 600.0f, 700.0f, 800.0f, 900.0f, 1000.0f, 1100.0f, 1200.0f, 1300.0f, 1400.0f, 1500.0f, 1600.0f, 1700.0f, 1800.0f, 1900.0f, 2000.0f, 2100.0f, 2200.0f, 2300.0f, 2400.0f, 2500.0f, 2600.0f, 2700.0f, 2800.0f, 2900.0f, 3000.0f, 3100.0f, 3200.0f, 3300.0f, 3400.0f, 3500.0f, 3600.0f};
        v34xFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(v34xIndices)));
        v5xIndices = new float[]{0.0f, 50.0f, 100.0f, 150.0f, 200.0f, 250.0f, 300.0f, 400.0f, 500.0f, 600.0f, 700.0f, 800.0f, 900.0f, 1000.0f, 1100.0f, 1200.0f, 1300.0f, 1400.0f, 1500.0f, 1600.0f, 1700.0f, 1800.0f, 1900.0f, 2000.0f, 2100.0f, 2200.0f, 2300.0f, 2400.0f};
        v5xFloatList = new ArrayListModel(Arrays.asList(ListUtil.convertToFloatArray(v5xIndices)));
    }

    private class DispatchingAction
    extends AbstractAction {
        private final String id;

        DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id == "changeGlobalMAF") {
                MAFV3DataAdapter.this.doScaleAction();
            } else if (this.id == "zeroAdjustments") {
                List list = (List)MAFV3DataAdapter.this.rawDataModel.getValue();
                Collections.fill(list, new Float(0.0f));
            } else if (this.id == "useTemplate") {
                List list = (List)MAFV3DataAdapter.this.rawDataModel.getValue();
                Collections.copy(list, (List)MAFV3DataAdapter.this.rawTemplateModel.getValue());
            } else if (this.id == "hideTemplate") {
                MAFV3DataAdapter.this.setTemplateSelectionIndex(null, new Integer(0));
            }
        }
    }
}

