/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class MAFV3RecordModel
extends RecordModel {
    ListModelPlug mdlCompTbl;
    ListModelPlug persistedMdlCompTbl;
    ValueModelPlug mdlMafSelector;
    ValueModelPlug persistedMdlMafSelector;
    boolean isV3MAFComp;
    boolean isV4MAFComp;
    boolean isV5MAFComp;
    ValueModelPlug mdlGlobalMAFAdj;
    ValueModel mdlNoSDMAFComp;
    final int deviceId;
    static final int[] compatibleRecordIds = new int[]{30, 38, 49};

    MAFV3RecordModel(RecordSet recordSet) {
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = (ECMLinkConfigRecordSet)recordSet;
        this.deviceId = eCMLinkConfigRecordSet.getDeviceId();
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        this.mdlNoSDMAFComp = this.track(this.mdlNoSDMAFComp, (UnpluggableValueModel)baseRecord.getFeaturePlug("noSDMAFComp"));
        BaseRecord baseRecord2 = RecordSet.getRecord(compatibleRecordIds, map);
        this.isV3MAFComp = RecordSet.containsRecordId(30, map);
        this.isV4MAFComp = RecordSet.containsRecordId(38, map);
        this.isV5MAFComp = RecordSet.containsRecordId(49, map);
        ListModelPlug listModelPlug = baseRecord2.numberListField("MafComp");
        if (this.doingPersistedCreate) {
            this.persistedMdlCompTbl = listModelPlug;
        }
        this.mdlCompTbl = this.track(this.mdlCompTbl, listModelPlug);
        ValueModelPlug valueModelPlug = baseRecord2.numberFieldAsInteger("BaseMAFSelect");
        this.mdlMafSelector = this.track(this.mdlMafSelector, valueModelPlug);
        if (this.doingPersistedCreate) {
            this.persistedMdlMafSelector = valueModelPlug;
        }
        this.mdlGlobalMAFAdj = this.track(this.mdlGlobalMAFAdj, baseRecord2.numberFieldAsString("GlobalMAFAdj", 1));
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        if (this.isV3MAFComp || this.isV4MAFComp) {
            return RecordSet.containsRecordId(30, map) || RecordSet.containsRecordId(38, map);
        }
        if (this.isV5MAFComp) {
            return RecordSet.containsRecordId(49, map);
        }
        return false;
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsAnyRecordId(compatibleRecordIds, map);
    }
}

