/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChartPlotDesc;
import com.ecmtuning.ecmlink.gui.chart.ChtTblBuilder;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ComboMap;
import com.ecmtuning.ecmlink.util.model.Integer2ComboFilter;
import com.ecmtuning.ecmlink.util.model.Number2IntegerFilter;
import com.ecmtuning.ecmlink.util.model.PropertyConnector2;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.ActionWrapper;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3DataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3RecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.component.UIFButton;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;

public class MAFV3RecordView
extends AbstractView {
    private JComboBox comboBaseMaf;
    private JComboBox comboTemplate;
    private JButton btnUseTemplate;
    private JSpinner spnrGlobalAdj;
    private JButton btnChangeGlobal;
    private JCheckBox cbNoSDMAFComp;
    private MAFV3DataAdapter dataAdapter;
    private ChtTblBuilder chtTblBuilder;
    private final MAFV3RecordModel model;
    ValueModelPlug mafSelectorComboPlug;
    static final String DISPLAY_NAME_STOCK = "Stock";
    static final String DISPLAY_NAME_2G = "2G DSM";
    static final String DISPLAY_NAME_EVO8 = "EVO8/3G";
    static final String DISPLAY_NAME_GM3 = "GM 3\" (25180303)";
    static final String DISPLAY_NAME_GM35 = "GM 3.5\" (25179711)";
    static final String DISPLAY_NAME_GM375 = "GM 3.75\" (25318411)";
    static final String DISPLAY_NAME_SD = "Speed Density";
    ComboMap[] mafSelect1GV3Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(4, "2G DSM"), new ComboMap(5, "EVO8/3G"), new ComboMap(1, "GM 3\" (25180303)"), new ComboMap(2, "GM 3.5\" (25179711)")};
    ComboMap[] mafSelect2GV3Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(5, "EVO8/3G"), new ComboMap(1, "GM 3\" (25180303)"), new ComboMap(2, "GM 3.5\" (25179711)")};
    ComboMap[] mafSelect1GV4Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(4, "2G DSM"), new ComboMap(5, "EVO8/3G"), new ComboMap(1, "GM 3\" (25180303)"), new ComboMap(2, "GM 3.5\" (25179711)"), new ComboMap(3, "GM 3.75\" (25318411)"), new ComboMap(6, "Speed Density")};
    ComboMap[] mafSelect2GV4Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(5, "EVO8/3G"), new ComboMap(1, "GM 3\" (25180303)"), new ComboMap(2, "GM 3.5\" (25179711)"), new ComboMap(3, "GM 3.75\" (25318411)"), new ComboMap(6, "Speed Density")};
    ComboMap[] mafSelect1GV5Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(4, "2G DSM"), new ComboMap(5, "EVO8/3G"), new ComboMap(6, "Speed Density")};
    ComboMap[] mafSelect2GV5Map = new ComboMap[]{new ComboMap(0, "Stock"), new ComboMap(5, "EVO8/3G"), new ComboMap(6, "Speed Density")};

    public MAFV3RecordView(MAFV3RecordModel mAFV3RecordModel) {
        this.model = mAFV3RecordModel;
    }

    public void resetViewport() {
        this.chtTblBuilder.getChart().resetViewport();
    }

    public MAFV3DataAdapter getDataAdapter() {
        return this.dataAdapter;
    }

    public Component getDefaultFocusComponent() {
        return this.chtTblBuilder.getChart();
    }

    private void initComponents() {
        this.dataAdapter = new MAFV3DataAdapter(this.model);
        this.chtTblBuilder = new ChtTblBuilder(this.dataAdapter);
        this.dataAdapter.createTableActions(this.chtTblBuilder);
        this.initTable();
        this.initChart();
        SelectionInList selectionInList = new SelectionInList((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionNames", true));
        selectionInList.setSelectionIndexHolder((ValueModel)new PropertyAdapter((Object)this.dataAdapter, "templateSelectionIndex", true));
        this.comboTemplate = new JComboBox(new ComboBoxAdapter(selectionInList));
        this.btnUseTemplate = new UIFButton(this.dataAdapter.getUseTemplateAction());
    }

    private void initChart() {
        Chart chart = this.chtTblBuilder.getChart();
        float f = this.model.isV5MAFComp ? 2400.0f : 3600.0f;
        FloatRect floatRect = new FloatRect();
        floatRect.setCorners(0.0f, -50.0f, Math.round(f), 70.0f);
        this.dataAdapter.setMaxViewportForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect);
        FloatRect floatRect2 = new FloatRect(0.0f, 0.0f, 100.0f, 10.0f);
        this.dataAdapter.setGridForDisplayType(ChtTblDataAdapter.DEFAULT_DISPLAY_TYPE, floatRect2);
        chart.setXAxisLoc(0.0f);
        chart.setYAxisLoc(0.0f);
        ChartPlotDesc chartPlotDesc = this.chtTblBuilder.getYDesc();
        chartPlotDesc.setMarkerSize(0.011428571f * f);
        ChartPlotDesc chartPlotDesc2 = this.chtTblBuilder.getTemplateDesc();
        chartPlotDesc2.setMarkerSize(0.011428571f * f * 0.8f);
        this.chtTblBuilder.resetViewport();
        this.chtTblBuilder.addDefaultValueChangeActions(chart, false);
        chart.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    private void initTable() {
        HandyJTable handyJTable = this.chtTblBuilder.getDataTable();
        this.chtTblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        PropertyConnector2 propertyConnector2 = new PropertyConnector2(this.model.mdlMafSelector, "value", (Object)this.dataAdapter, "mafType");
        propertyConnector2.setValueFilter(new Number2IntegerFilter());
        propertyConnector2.updateProperty2();
        this.mafSelectorComboPlug = new ValueModelPlug(this.model.mdlMafSelector, null);
        Object[] objectArray = ECMLinkDeviceMap.is1GDSMDevice(this.model.deviceId) ? (this.model.isV3MAFComp ? this.mafSelect1GV3Map : (this.model.isV4MAFComp ? this.mafSelect1GV4Map : this.mafSelect1GV5Map)) : (this.model.isV3MAFComp ? this.mafSelect2GV3Map : (this.model.isV4MAFComp ? this.mafSelect2GV4Map : this.mafSelect2GV5Map));
        Integer2ComboFilter integer2ComboFilter = new Integer2ComboFilter(0, objectArray[0]);
        integer2ComboFilter.addValidCombos((ComboMap[])objectArray);
        this.mafSelectorComboPlug.addObjectFilter(integer2ComboFilter);
        this.comboBaseMaf = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList(objectArray, (ValueModel)this.mafSelectorComboPlug));
        this.spnrGlobalAdj = DialogUtil.createSpinnerTextField(this.model.mdlGlobalMAFAdj, "MAF scalar, scales value from table globally");
        if (this.model.mdlNoSDMAFComp != null) {
            this.cbNoSDMAFComp = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlNoSDMAFComp, (String)"Disable MAF compensation w/SD operation");
            this.cbNoSDMAFComp.setToolTipText("Disables active MAF compensation while running speed density");
        }
        ActionWrapper actionWrapper = new ActionWrapper(this.dataAdapter.getChangeGlobalAction());
        actionWrapper.overrideValue("Name", ECMLinkResources.getString("ecmlink.globalmafbtn.label"));
        this.btnChangeGlobal = new JButton(actionWrapper);
        handyJTable.addMouseListener(this.dataAdapter.getPopupListener(this.chtTblBuilder.getDataTable()));
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.FILL_DEFAULT_GROW_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec2, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Active MAF Compensation", cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.chtTblBuilder.getPanel(), cellConstraints.xy(2, 3));
        panelBuilder.addSeparator("Options", cellConstraints.xyw(1, 5, 2));
        panelBuilder.add((Component)this.buildOptionPanel(), cellConstraints.xy(2, 7));
        return panelBuilder.getPanel();
    }

    protected JComponent buildOptionPanel() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        ArrayList<RowSpec> arrayList2 = new ArrayList<RowSpec>();
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
        arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        if (this.cbNoSDMAFComp != null) {
            arrayList2.add(DialogUtil.RELATED_GAP_ROWSPEC);
            arrayList2.add(DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC);
        }
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{3, 5}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel("Base MAF type:", cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.comboBaseMaf, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Global scalar:", cellConstraints.xy(5, n, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelBuilder.add((Component)this.spnrGlobalAdj, cellConstraints.xy(7, n));
        panelBuilder.add((Component)this.btnChangeGlobal, cellConstraints.xy(9, n));
        panelBuilder.addLabel("Display template:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.comboTemplate, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.btnUseTemplate, cellConstraints.xy(5, n));
        if (this.cbNoSDMAFComp != null) {
            panelBuilder.add((Component)this.cbNoSDMAFComp, cellConstraints.xyw(3, n += 2, 7));
        }
        return panelBuilder.getPanel();
    }
}

