/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3RecordView;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsSubTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.uif.AbstractView;
import java.io.IOException;
import java.util.Map;

public class MAFV3Tab
extends SettingsSubTab {
    public MAFV3Tab(RecordSet recordSet, SettingsTab settingsTab) {
        super(recordSet, settingsTab);
    }

    public static boolean canDisplay(Map map) {
        return MAFV3RecordModel.canDisplay(map);
    }

    @Override
    protected RecordModel createLocalModel() {
        return new MAFV3RecordModel(this.getRecordSet());
    }

    @Override
    protected AbstractView createView(RecordModel recordModel) {
        MAFV3RecordModel mAFV3RecordModel = (MAFV3RecordModel)recordModel;
        return new MAFV3RecordView(mAFV3RecordModel);
    }

    @Override
    protected String getTabTitle() {
        return "MAF Comp";
    }

    @Override
    protected String getTipText() {
        return "Shows active MAF compensation";
    }

    @Override
    protected String getTabHelpId() {
        return "ecmlink.mafcomp.tab";
    }

    @Override
    void saveTabToECU() throws IOException, DeviceException {
        MAFV3RecordModel mAFV3RecordModel = (MAFV3RecordModel)this.getRecordModel();
        int n = ((Number)mAFV3RecordModel.persistedMdlMafSelector.getValue()).intValue();
        int n2 = ((Number)mAFV3RecordModel.mdlMafSelector.getValue()).intValue();
        if (n2 == 6 && n2 != n && OptionalMessageDialog.isShowingMsg("mafcomp.sdwarning.msg")) {
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "mafcomp.sdwarning.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(true);
            optionalMessageDialog.setOkText("Continue");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            if (optionalMessageDialog.hasBeenCanceled()) {
                return;
            }
        }
        super.saveTabToECU();
    }

    @Override
    protected void resetTab() {
        super.resetTab();
        if (this.getNullableView() != null) {
            ((MAFV3RecordView)this.getNullableView()).resetViewport();
        }
    }
}

