/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class MiscRecordModel
extends RecordModel {
    ValueModel mdlTiming;
    ValueModel mdlDiag;
    ValueModel mdlEvap;
    ValueModel mdlEGR;
    ValueModel mdlFPS;
    ValueModel mdlBCS;
    ValueModel mdlFans;
    ValueModel mdlCAS;
    ValueModel mdlClutch;
    ValueModel mdlOpenLoop;
    ValueModel mdlFuelPump;
    ValueModel mdlInj1;
    ValueModel mdlInj2;
    ValueModel mdlInj3;
    ValueModel mdlInj4;
    ValueModel mdlLockComm;
    ValueModel mdlNoSDSmoothing;
    ValueModel mdlHotStartFuel;
    ValueModelPlug mdlFuelPumpPrimeSecs;
    ValueModel mdlPersistedFPSCntrlEnable;
    ValueModel mdlPersistedFPSNormal;
    ValueModel mdlPersistedEGRCntrlEnable;
    ValueModel mdlPersistedEGRNormal;
    ValueModel mdlPersistedWGSCntrlEnable;
    Object bitsRecordId;
    Object toolsRecordId;
    int mb9Mask1;
    int mb9Mask2;
    int mb9Mask3;
    int mb9Mask4;

    MiscRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
        Map map = recordSet.getPersistentRecordMap();
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.FPS_RECORD_IDS, map);
        BaseRecord baseRecord2 = RecordSet.getRecord(35, map);
        BaseRecord baseRecord3 = RecordSet.getRecord(50, map);
        if (baseRecord != null) {
            this.mdlPersistedFPSCntrlEnable = baseRecord.numberFieldAsBoolean("FPSCtl", 128);
            this.mdlPersistedFPSNormal = baseRecord.numberFieldAsBoolean("FPSCtl", 64);
        }
        if (baseRecord2 != null) {
            this.mdlPersistedEGRCntrlEnable = baseRecord2.numberFieldAsBoolean("EGRCtl", 128);
            this.mdlPersistedEGRNormal = baseRecord2.numberFieldAsBoolean("EGRCtl", 64);
        }
        if (baseRecord3 != null) {
            this.mdlPersistedWGSCntrlEnable = baseRecord3.numberFieldAsBoolean("WGSCtl", 128);
        }
    }

    @Override
    public void deregisterModel() {
        super.deregisterModel();
        if (this.mdlPersistedFPSCntrlEnable != null) {
            ((ValueModelPlug)this.mdlPersistedFPSCntrlEnable).unplug();
            ((ValueModelPlug)this.mdlPersistedFPSNormal).unplug();
        }
        if (this.mdlPersistedEGRCntrlEnable != null) {
            ((ValueModelPlug)this.mdlPersistedEGRCntrlEnable).unplug();
            ((ValueModelPlug)this.mdlPersistedEGRNormal).unplug();
        }
        if (this.mdlPersistedWGSCntrlEnable != null) {
            ((ValueModelPlug)this.mdlPersistedWGSCntrlEnable).unplug();
        }
    }

    @Override
    protected void initAndTrackModels(Map map) {
        int n;
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        BaseRecord baseRecord2 = RecordSet.getRecord(44, map);
        if (this.doingPersistedCreate) {
            this.bitsRecordId = baseRecord.getRecordID();
            if (baseRecord2 != null) {
                this.mb9Mask1 = baseRecord.getField("MiscBits1Mask").intValue();
                this.mb9Mask2 = baseRecord.getField("MiscBits2Mask").intValue();
                this.mb9Mask3 = baseRecord.getField("MiscBits3Mask").intValue();
                this.mb9Mask4 = baseRecord.getField("MiscBits4Mask").intValue();
            }
        }
        this.mdlTiming = this.track(this.mdlTiming, (UnpluggableValueModel)baseRecord.getFeaturePlug("timingCheckCtl"));
        this.mdlDiag = this.track(this.mdlDiag, (UnpluggableValueModel)baseRecord.getFeaturePlug("diagPinCtl"));
        this.mdlFans = this.track(this.mdlFans, (UnpluggableValueModel)baseRecord.getFeaturePlug("fanCtl"));
        this.mdlCAS = this.track(this.mdlCAS, (UnpluggableValueModel)baseRecord.getFeaturePlug("casInvert"));
        this.mdlClutch = this.track(this.mdlClutch, (UnpluggableValueModel)baseRecord.getFeaturePlug("invertClutch"));
        this.mdlOpenLoop = this.track(this.mdlOpenLoop, (UnpluggableValueModel)baseRecord.getFeaturePlug("forceOpenloop"));
        this.mdlLockComm = this.track(this.mdlLockComm, (UnpluggableValueModel)baseRecord.getFeaturePlug("lockComm"));
        this.mdlNoSDSmoothing = this.track(this.mdlNoSDSmoothing, (UnpluggableValueModel)baseRecord.getFeaturePlug("noSDSmoothing"));
        this.mdlHotStartFuel = this.track(this.mdlHotStartFuel, (UnpluggableValueModel)baseRecord.getFeaturePlug("hotStartFuel"));
        BaseRecord baseRecord3 = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_TOOLS_RECORD_IDS, map);
        if (this.doingPersistedCreate) {
            this.toolsRecordId = baseRecord3.getRecordID();
        }
        this.mdlEvap = this.track(this.mdlEvap, (UnpluggableValueModel)baseRecord3.getFeaturePlug("evapOn"));
        this.mdlEGR = this.track(this.mdlEGR, (UnpluggableValueModel)baseRecord3.getFeaturePlug("egrOn"));
        this.mdlFPS = this.track(this.mdlFPS, (UnpluggableValueModel)baseRecord3.getFeaturePlug("fpsOn"));
        this.mdlBCS = this.track(this.mdlBCS, (UnpluggableValueModel)baseRecord3.getFeaturePlug("bcsOn"));
        this.mdlFuelPump = this.track(this.mdlFuelPump, (UnpluggableValueModel)baseRecord3.getFeaturePlug("fuelPumpOn"));
        this.mdlInj1 = this.track(this.mdlInj1, (UnpluggableValueModel)baseRecord3.getFeaturePlug("inj1Off"));
        this.mdlInj2 = this.track(this.mdlInj2, (UnpluggableValueModel)baseRecord3.getFeaturePlug("inj2Off"));
        this.mdlInj3 = this.track(this.mdlInj3, (UnpluggableValueModel)baseRecord3.getFeaturePlug("inj3Off"));
        this.mdlInj4 = this.track(this.mdlInj4, (UnpluggableValueModel)baseRecord3.getFeaturePlug("inj4Off"));
        if (baseRecord2 != null && ((n = baseRecord2.getField("MiscBits3Mask").intValue()) & 0x40) != 0) {
            this.mdlFuelPumpPrimeSecs = baseRecord2.numberFieldAsString("FPTmr400KeyOn", 1);
            this.track(null, this.mdlFuelPumpPrimeSecs);
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        BaseRecord baseRecord2 = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_TOOLS_RECORD_IDS, map);
        if (baseRecord == null || baseRecord2 == null) {
            return false;
        }
        if (BindingUtils.equals((Object)baseRecord.getRecordID(), (Object)this.bitsRecordId) && BindingUtils.equals((Object)baseRecord2.getRecordID(), (Object)this.toolsRecordId)) {
            if (baseRecord.isRecordID(44)) {
                int n = baseRecord.getField("MiscBits1Mask").intValue();
                int n2 = baseRecord.getField("MiscBits2Mask").intValue();
                int n3 = baseRecord.getField("MiscBits3Mask").intValue();
                int n4 = baseRecord.getField("MiscBits4Mask").intValue();
                return n == this.mb9Mask1 && n2 == this.mb9Mask2 && n3 == this.mb9Mask3 && n4 == this.mb9Mask4;
            }
            return true;
        }
        return false;
    }

    public static boolean canDisplay(Map map) {
        boolean bl = RecordSet.containsRecordId(12, map);
        boolean bl2 = RecordSet.containsRecordId(16, map);
        boolean bl3 = RecordSet.containsRecordId(21, map);
        boolean bl4 = RecordSet.containsRecordId(22, map);
        boolean bl5 = RecordSet.containsRecordId(32, map);
        boolean bl6 = RecordSet.containsRecordId(33, map);
        boolean bl7 = RecordSet.containsRecordId(40, map);
        boolean bl8 = RecordSet.containsRecordId(41, map);
        boolean bl9 = RecordSet.containsRecordId(44, map);
        boolean bl10 = RecordSet.containsRecordId(5, map);
        boolean bl11 = RecordSet.containsRecordId(17, map);
        boolean bl12 = RecordSet.containsRecordId(20, map);
        boolean bl13 = RecordSet.containsRecordId(45, map);
        boolean bl14 = (bl2 || bl4 || bl6 || bl8) && bl11;
        bl14 |= bl && bl10;
        bl14 |= (bl3 || bl5 || bl7) && bl12;
        return bl14 |= bl9 && (bl11 || bl12 || bl13);
    }
}

