/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.MiscRecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;

public class MiscRecordView
extends AbstractRecordView {
    private JCheckBox cbFans;
    private JCheckBox cbFuel;
    private JCheckBox cbTiming;
    private JCheckBox cbDiag;
    private JCheckBox cbCAS;
    private JCheckBox cbClutch;
    private JCheckBox cbOpenLoop;
    private JCheckBox cbLockComm;
    private JCheckBox cbNoSDSmoothing;
    private JCheckBox cbHotStartFuel;
    private JToggleButton tbEvap;
    private JToggleButton tbEGR;
    private JToggleButton tbFPS;
    private JToggleButton tbBCS;
    private JToggleButton tbInj1;
    private JToggleButton tbInj2;
    private JToggleButton tbInj3;
    private JToggleButton tbInj4;
    private JSpinner spnrFuelPumpPrimeSecs;
    private final MiscRecordModel model;
    PropertyChangeListener fpsEnabler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)((MiscRecordView)MiscRecordView.this).model.mdlPersistedFPSNormal.getValue();
            boolean bl2 = (Boolean)((MiscRecordView)MiscRecordView.this).model.mdlPersistedFPSCntrlEnable.getValue();
            MiscRecordView.this.tbFPS.setEnabled(!bl2 && bl);
        }
    };
    PropertyChangeListener egrEnabler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)((MiscRecordView)MiscRecordView.this).model.mdlPersistedEGRNormal.getValue();
            boolean bl2 = (Boolean)((MiscRecordView)MiscRecordView.this).model.mdlPersistedEGRCntrlEnable.getValue();
            MiscRecordView.this.tbEGR.setEnabled(!bl2 && bl);
        }
    };
    PropertyChangeListener wgsEnabler = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)((MiscRecordView)MiscRecordView.this).model.mdlPersistedWGSCntrlEnable.getValue();
            MiscRecordView.this.tbBCS.setEnabled(!bl);
        }
    };

    public MiscRecordView(MiscRecordModel miscRecordModel) {
        this.model = miscRecordModel;
        miscRecordModel.setAutoSaveEnabled(Boolean.TRUE);
    }

    private void initComponents() {
        if (this.modelHasFanControls()) {
            this.cbFans = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlFans, (String)"Activate fans full on");
            this.cbFans.setToolTipText("Turns both fans on full high");
        }
        if (this.model.mdlFuelPump != null) {
            this.cbFuel = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlFuelPump, (String)"Activate fuel pump (always on)");
            this.cbFuel.setToolTipText("Forces fuel pump on");
        }
        if (this.model.mdlTiming != null) {
            this.cbTiming = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlTiming, (String)"Ground timing connector to ECU");
            this.cbTiming.setToolTipText("Simulates grounding of the timing check connector");
        }
        if (this.model.mdlDiag != null) {
            this.cbDiag = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlDiag, (String)"Ground diagnostic pin to ECU");
            this.cbDiag.setToolTipText("Simulates grounding of the diagnostic pin to the ECU");
        }
        if (this.modelHasCltchAndOpenLoop()) {
            this.cbClutch = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlClutch, (String)"Use starter switch for clutch wire (invert signal)");
            this.cbClutch.setToolTipText("Inverts the clutch wire signal as appropriate for use with the starter switch");
            this.cbOpenLoop = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlOpenLoop, (String)"Lock in open loop mode");
            this.cbOpenLoop.setToolTipText("Locks the car in open loop mode, effectively disabling the front O2 signal for closed loop fuel control");
        }
        if (this.modelHasCASInvert()) {
            this.cbCAS = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlCAS, (String)"Use non-95/96 style cam angle sensor");
            this.cbCAS.setToolTipText("Inverts the cam angle signal as appropriate for use with '95 ECU and a non-'95/'96 style cam angle sensor");
        }
        if (this.modelHasLockComm()) {
            this.cbLockComm = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlLockComm, (String)"Lock comm in ECMLink mode");
            this.cbLockComm.setToolTipText("Locks communication in ECMLink mode on powerup (disables other OBD/MUTT modes)");
        }
        if (this.modelHasHotStartFuel()) {
            this.cbHotStartFuel = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlHotStartFuel, (String)"Enable hot start enrichment");
            this.cbHotStartFuel.setToolTipText("Enables additional fuel enrichment when starting with a hot engine");
        }
        if (this.modelHasNoSDSmoothing()) {
            this.cbNoSDSmoothing = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlNoSDSmoothing, (String)"Disable airflow smoothing w/SD operation");
            this.cbNoSDSmoothing.setToolTipText("Disables airflow smoothing while running speed density");
        }
        if (this.model.mdlEvap != null) {
            this.tbEvap = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlEvap, (String)"EVAP");
            this.tbEvap.setToolTipText("Toggles the evaporative emissions solenoid line (switch to ground)");
        }
        this.tbEGR = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlEGR, (String)"EGR");
        this.tbEGR.setToolTipText("Toggles the EGR solenoid line (switch to ground).   Only works if EGR is is set to factory mode in EGR tab.");
        this.tbFPS = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlFPS, (String)"FPS");
        this.tbFPS.setToolTipText("Toggles the fuel pressure solenoid line (switch to ground).  Only works if FPS is is set to factory mode in FPS tab.");
        this.tbBCS = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlBCS, (String)"BCS");
        this.tbBCS.setToolTipText("Toggles the boost control solenoid line (switch to ground).  Only works if boost control is disabled in the Boost (WGS) tab.");
        if (this.model.mdlPersistedFPSCntrlEnable != null) {
            this.model.mdlPersistedFPSNormal.addValueChangeListener(this.fpsEnabler);
            this.model.mdlPersistedFPSCntrlEnable.addValueChangeListener(this.fpsEnabler);
            this.fpsEnabler.propertyChange(null);
        }
        if (this.model.mdlPersistedEGRCntrlEnable != null) {
            this.model.mdlPersistedEGRNormal.addValueChangeListener(this.egrEnabler);
            this.model.mdlPersistedEGRCntrlEnable.addValueChangeListener(this.egrEnabler);
            this.egrEnabler.propertyChange(null);
        }
        if (this.model.mdlPersistedWGSCntrlEnable != null) {
            this.model.mdlPersistedWGSCntrlEnable.addValueChangeListener(this.wgsEnabler);
            this.wgsEnabler.propertyChange(null);
        }
        if (this.hasInjControls()) {
            this.tbInj1 = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlInj1, (String)"Inj 1");
            this.tbInj1.setToolTipText("Enables/disables the firing of the injector for cylinder 1");
            this.tbInj2 = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlInj2, (String)"Inj 2");
            this.tbInj2.setToolTipText("Enables/disables the firing of the injector for cylinder 2");
            this.tbInj3 = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlInj3, (String)"Inj 3");
            this.tbInj3.setToolTipText("Enables/disables the firing of the injector for cylinder 3");
            this.tbInj4 = BasicComponentFactory.createToggleButton((ValueModel)this.model.mdlInj4, (String)"Inj 4");
            this.tbInj4.setToolTipText("Enables/disables the firing of the injector for cylinder 4");
        }
        if (this.model.mdlFuelPumpPrimeSecs != null) {
            this.spnrFuelPumpPrimeSecs = DialogUtil.createSpinnerTextField(this.model.mdlFuelPumpPrimeSecs, "Activates fuel pump for this many seconds after key on");
        }
    }

    private final boolean modelHasFanControls() {
        return this.model.mdlFans != null;
    }

    private final boolean modelHasCASInvert() {
        return this.model.mdlCAS != null;
    }

    private final boolean modelHasLockComm() {
        return this.model.mdlLockComm != null;
    }

    private final boolean modelHasNoSDSmoothing() {
        return this.model.mdlNoSDSmoothing != null;
    }

    private final boolean modelHasHotStartFuel() {
        return this.model.mdlHotStartFuel != null;
    }

    private final boolean modelHasCltchAndOpenLoop() {
        return this.model.mdlClutch != null && this.model.mdlOpenLoop != null;
    }

    private final boolean hasInjControls() {
        return this.model.mdlInj1 != null && this.model.mdlInj2 != null && this.model.mdlInj3 != null && this.model.mdlInj4 != null;
    }

    protected JComponent buildPanel() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("fill:pref, 10dlu, fill:pref:grow", "fill:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildLeftColumn(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildRightColumn(), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JComponent buildLeftColumn() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(indentColSpec);
        arrayList.add(new ColumnSpec("fill:pref"));
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.addSeparator("Options");
        panelBuilder.nextLine(2, 2);
        if (this.modelHasCltchAndOpenLoop()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbClutch);
            panelBuilder.nextLine(2, 2);
            panelBuilder.add((Component)this.cbOpenLoop);
            panelBuilder.nextLine(2, 2);
        }
        if (this.modelHasCASInvert()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbCAS);
            panelBuilder.nextLine(2, 2);
        }
        if (this.modelHasLockComm()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbLockComm);
            panelBuilder.nextLine(2, 2);
        }
        if (this.modelHasNoSDSmoothing()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbNoSDSmoothing);
            panelBuilder.nextLine(2, 2);
        }
        if (this.modelHasHotStartFuel()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbHotStartFuel);
            panelBuilder.nextLine(2, 2);
        }
        MiscRecordView.nextSection(panelBuilder);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.addSeparator("Solenoid Activation");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.build4CompPanel(this.tbEvap, this.tbEGR, this.tbFPS, this.tbBCS));
        panelBuilder.nextLine(2);
        if (this.hasInjControls()) {
            MiscRecordView.nextSection(panelBuilder);
            panelBuilder.appendRows(prefRowSpec, postSepGap);
            panelBuilder.addSeparator("Injectors");
            panelBuilder.nextLine(2, 2);
            panelBuilder.appendRow(prefRowSpec);
            panelBuilder.add((Component)this.build4CompPanel(this.tbInj1, this.tbInj2, this.tbInj3, this.tbInj4));
            panelBuilder.nextLine();
        }
        return panelBuilder.getPanel();
    }

    private JComponent build4CompPanel(Component component, Component component2, Component component3, Component component4) {
        ColumnSpec columnSpec = DialogUtil.FILL_PREF_GROW_COLSPEC;
        ColumnSpec columnSpec2 = DialogUtil.RELATED_GAP_COLSPEC;
        ArrayList arrayList = new ArrayList();
        ListUtil.add(arrayList, columnSpec, columnSpec2);
        ListUtil.add(arrayList, columnSpec, columnSpec2);
        ListUtil.add(arrayList, columnSpec, columnSpec2);
        ListUtil.add(arrayList, columnSpec, indentColSpec);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{1, 3, 5, 7}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        if (component != null) {
            panelBuilder.add(component, cellConstraints.xy(n, 1));
            n += 2;
        }
        if (component2 != null) {
            panelBuilder.add(component2, cellConstraints.xy(n, 1));
            n += 2;
        }
        if (component3 != null) {
            panelBuilder.add(component3, cellConstraints.xy(n, 1));
            n += 2;
        }
        if (component4 != null) {
            panelBuilder.add(component4, cellConstraints.xy(n, 1));
            n += 2;
        }
        return panelBuilder.getPanel();
    }

    private JComponent buildRightColumn() {
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        ListUtil.add(arrayList, indentColSpec);
        arrayList.add(DialogUtil.FILL_PREF_GROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.addSeparator("Devices and Diagnostics");
        panelBuilder.nextLine(2, 2);
        if (this.modelHasFanControls()) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbFans);
            panelBuilder.nextLine(2, 2);
        }
        if (this.cbFuel != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbFuel);
            panelBuilder.nextLine(2, 2);
        }
        if (this.cbTiming != null) {
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)this.cbTiming);
            panelBuilder.nextLine(2, 2);
        }
        if (this.cbDiag != null) {
            panelBuilder.appendRows(prefRowSpec, postSepGap);
            panelBuilder.add((Component)this.cbDiag);
        }
        if (this.spnrFuelPumpPrimeSecs != null) {
            panelBuilder.nextLine(2, 1);
            panelBuilder.appendRows(prefRowSpec, postSepGap);
            panelBuilder.addSeparator("Fuel Pump Prime");
            panelBuilder.nextLine(2, 2);
            ArrayList<ColumnSpec> arrayList3 = new ArrayList<ColumnSpec>();
            arrayList3.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
            arrayList3.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
            arrayList3.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
            arrayList3.add(DialogUtil.RELATED_GAP_COLSPEC);
            arrayList3.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
            ArrayList arrayList4 = new ArrayList();
            FormLayout formLayout2 = new FormLayout(arrayList3, arrayList4);
            PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
            panelBuilder2.getPanel().setOpaque(false);
            panelBuilder2.appendRow(prefRowSpec);
            panelBuilder2.addLabel("Post key-on prime time:");
            panelBuilder2.nextColumn(2);
            panelBuilder2.add((Component)this.spnrFuelPumpPrimeSecs);
            panelBuilder2.nextColumn(2);
            panelBuilder2.addLabel("secs");
            panelBuilder2.nextColumn(2);
            panelBuilder.appendRows(prefRowSpec, interCompGap);
            panelBuilder.add((Component)panelBuilder2.getPanel());
            panelBuilder.nextLine(2, 2);
        }
        return panelBuilder.getPanel();
    }
}

