/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class NBO2SimRecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModelPlug mdlSwitchPntVolts;
    ValueModelPlug mdlDelaySeconds;
    ValueModelPlug mdlDelayVolts;
    ValueModelPlug mdlDelayWindowVolts;
    ValueModel mdlPersistedWBInputX;
    private static int[] validBitsIds = new int[]{21, 22, 32, 33, 40, 41, 44};

    NBO2SimRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
        Map map = recordSet.getPersistentRecordMap();
        BaseRecord baseRecord = RecordSet.getRecord(validBitsIds, map);
        this.mdlPersistedWBInputX = baseRecord.getFeaturePlug("wbInputX");
    }

    @Override
    public void deregisterModel() {
        super.deregisterModel();
        ((ValueModelPlug)this.mdlPersistedWBInputX).unplug();
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(24, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.getFeaturePlug("nbo2Sim"));
        this.mdlSwitchPntVolts = this.track(this.mdlSwitchPntVolts, baseRecord.numberFieldAsString("SwitchPointVolts", 2));
        this.mdlDelaySeconds = this.track(this.mdlDelaySeconds, baseRecord.numberFieldAsString("StartupSeconds", 1));
        this.mdlDelayVolts = this.track(this.mdlDelayVolts, baseRecord.numberFieldAsString("StartupVolts", 2));
        this.mdlDelayWindowVolts = this.track(this.mdlDelayWindowVolts, baseRecord.numberFieldAsString("StartupWindowVolts", 2));
    }

    public static boolean canDisplay(Map map) {
        if (!RecordSet.containsAnyRecordId(validBitsIds, map)) {
            return false;
        }
        BaseRecord baseRecord = RecordSet.getRecord(validBitsIds, map);
        if (!baseRecord.hasFeature("wbInputX")) {
            return false;
        }
        return RecordSet.containsRecordId(24, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return RecordSet.containsRecordId(24, map);
    }
}

