/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.NBO2SimRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public class NBO2SimRecordView
extends AbstractRecordView {
    private JCheckBox cbEnable;
    private JLabel lblSwitchPnt;
    private JLabel lblSwitchPntUnits;
    private JLabel lblDelaySecs;
    private JLabel lblDelaySecsUnits;
    private JLabel lblWBVolts;
    private JLabel lblWBWindowVolts;
    private JLabel lblWBWindowVoltsUnits;
    private JSpinner spnrSwitchPnt;
    private JSpinner spnrDelaySecs;
    private JSpinner spnrWBVolts;
    private JSpinner spnrWBWindowVolts;
    private final NBO2SimRecordModel model;
    ActionLabel inputsTabActionLabel;
    private final SettingsTab parentTab;

    public NBO2SimRecordView(NBO2SimRecordModel nBO2SimRecordModel, SettingsTab settingsTab) {
        this.model = nBO2SimRecordModel;
        this.parentTab = settingsTab;
    }

    private void initComponents() {
        this.cbEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnable, (String)"Enable narrowband simulation");
        this.cbEnable.setToolTipText("Enables narrowband simulation from a wideband sensor");
        this.lblSwitchPnt = new JLabel("WB switch point:");
        this.spnrSwitchPnt = DialogUtil.createSpinnerTextField(this.model.mdlSwitchPntVolts, "Switches between lean and rich readings around this voltage output from the wideband kit");
        this.lblSwitchPntUnits = new JLabel("volts");
        this.lblDelaySecs = new JLabel("Delay for:");
        this.spnrDelaySecs = DialogUtil.createSpinnerTextField(this.model.mdlDelaySeconds, "Forces open loop for the given time period following engine startup");
        this.lblDelaySecsUnits = new JLabel("secs");
        this.lblWBVolts = new JLabel("And until WB not equal to:");
        this.spnrWBVolts = DialogUtil.createSpinnerTextField(this.model.mdlDelayVolts, "Forces open loop until WB output is not equal to given value +/- other value");
        this.lblWBWindowVolts = new JLabel("+/-");
        this.spnrWBWindowVolts = DialogUtil.createSpinnerTextField(this.model.mdlDelayWindowVolts, "Window around \"WB not equal to\" value");
        this.lblWBWindowVoltsUnits = new JLabel("volts");
        DialogUtil.installComponentEnabler(this.model.mdlEnable, new Component[]{this.lblSwitchPnt, this.spnrSwitchPnt, this.lblSwitchPntUnits, this.lblDelaySecs, this.spnrDelaySecs, this.lblDelaySecsUnits, this.lblWBVolts, this.spnrWBVolts, this.lblWBWindowVolts, this.spnrWBWindowVolts, this.lblWBWindowVoltsUnits});
        Action action = this.parentTab.createTabAction(ECUIOTab.class);
        this.inputsTabActionLabel = new ActionLabel(action);
        this.model.mdlPersistedWBInputX.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NBO2SimRecordView.this.setEnable();
            }
        });
        this.setEnable();
    }

    void setEnable() {
        boolean bl = ((Number)this.model.mdlPersistedWBInputX.getValue()).intValue() != 0;
        boolean bl2 = bl && this.cbEnable.isSelected();
        this.cbEnable.setEnabled(bl);
        this.lblSwitchPnt.setEnabled(bl2);
        this.spnrSwitchPnt.setEnabled(bl2);
        this.lblSwitchPntUnits.setEnabled(bl2);
        this.lblDelaySecs.setEnabled(bl2);
        this.spnrDelaySecs.setEnabled(bl2);
        this.lblDelaySecsUnits.setEnabled(bl2);
        this.lblWBVolts.setEnabled(bl2);
        this.spnrWBVolts.setEnabled(bl2);
        this.lblWBWindowVolts.setEnabled(bl2);
        this.spnrWBWindowVolts.setEnabled(bl2);
        this.lblWBWindowVoltsUnits.setEnabled(bl2);
        if (!bl) {
            this.inputsTabActionLabel.setText("To enable, assign Wideband input pin\u2026");
            this.inputsTabActionLabel.setForeground(Color.RED);
        } else {
            this.inputsTabActionLabel.setText("Edit Wideband input pin assignment\u2026");
            this.inputsTabActionLabel.setForeground(Color.BLUE);
        }
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Narrowband O2 simulation");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.inputsTabActionLabel, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), panelBuilder.getColumnCount() - 1));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.cbEnable, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), panelBuilder.getColumnCount() - 1));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interSectGap);
        panelBuilder.add((Component)this.lblSwitchPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrSwitchPnt);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblSwitchPntUnits);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Startup options");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interSectGap);
        panelBuilder.add((Component)this.lblDelaySecs);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDelaySecs);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblDelaySecsUnits);
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interSectGap);
        panelBuilder.add((Component)this.lblWBVolts);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrWBVolts);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblWBWindowVolts, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 1, "right, center"));
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrWBWindowVolts);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblWBWindowVoltsUnits);
        panelBuilder.nextLine(2, 2);
        return panelBuilder.getPanel();
    }
}

