/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkRecordAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.records.TPSV1Record;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

public class RPMTPSRecordModel
extends RecordModel {
    ValueModel mdlIdleRPM;
    ValueModel mdlLaunchRPM;
    ValueModel mdlRevRPM;
    ValueModel mdlClutchEnable;
    ValueModel mdlClutchRev;
    ValueModelPlug mdlCoastFC;
    ValueModelPlug mdlTPSOffset;
    ValueModelPlug mdlTPSScale;
    ValueModelPlug mdlDisableSpd;
    ValueModel mdlEnableTPS;
    ValueModel mdlEnableIdleSw;
    ValueModel mdlDisableMoving;
    ValueModel mdlSimulate;
    boolean v2RPMInd;
    TPSV1Record persistedTPSRecord;
    TPSV1Record volatileTPSRecord;

    RPMTPSRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    boolean isV2RPM() {
        return this.v2RPMInd;
    }

    public TPSV1Record getVolatileTPSRecord() {
        return this.volatileTPSRecord;
    }

    public TPSV1Record getPersistedTPSRecord() {
        return this.persistedTPSRecord;
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = null;
        if (RecordSet.containsRecordId(8, map)) {
            this.v2RPMInd = true;
        }
        baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.RPM_CONTROL_RECORD_IDS, map);
        ValueModelPlug valueModelPlug = baseRecord.numberFieldAsInteger("idleRPMMin", 10);
        this.mdlIdleRPM = this.track(this.mdlIdleRPM, (UnpluggableValueModel)valueModelPlug);
        this.mdlLaunchRPM = this.track(this.mdlLaunchRPM, (UnpluggableValueModel)baseRecord.numberFieldAsInteger("launchMPR", 50));
        this.mdlRevRPM = this.track(this.mdlRevRPM, (UnpluggableValueModel)baseRecord.numberFieldAsInteger("revLimitMPR", 50));
        if (this.v2RPMInd) {
            this.mdlCoastFC = this.track(this.mdlCoastFC, baseRecord.numberFieldAsIntegerString("IdleFCOff", 10));
            this.mdlDisableSpd = baseRecord.numberFieldAsString("LaunchSpeed");
            UnitsHelper.installFilter(this.mdlDisableSpd, "typeSpeedFromMPH");
            this.track(null, this.mdlDisableSpd);
            this.mdlClutchRev = this.track(this.mdlClutchRev, (UnpluggableValueModel)baseRecord.numberFieldAsInteger("ShiftMPR", 50));
            BaseRecord baseRecord2 = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
            this.mdlClutchEnable = this.track(this.mdlClutchEnable, (UnpluggableValueModel)baseRecord2.getFeaturePlug("shiftRPMCtl"));
            BaseRecord baseRecord3 = RecordSet.getRecord(11, map);
            if (this.doingPersistedCreate) {
                this.persistedTPSRecord = (TPSV1Record)baseRecord3;
            } else if (this.doingVolatileCreate) {
                this.volatileTPSRecord = (TPSV1Record)baseRecord3;
            }
            this.mdlEnableTPS = this.track(this.mdlEnableTPS, (UnpluggableValueModel)baseRecord3.numberFieldAsBoolean("TPSCtl", 8));
            this.mdlTPSOffset = this.track(this.mdlTPSOffset, baseRecord3.numberFieldAsString("TPSOffset"));
            this.mdlTPSScale = this.track(this.mdlTPSScale, baseRecord3.numberFieldAsString("TPSScale"));
            this.mdlEnableIdleSw = this.track(this.mdlEnableIdleSw, (UnpluggableValueModel)baseRecord3.numberFieldAsBoolean("TPSCtl", 2, true));
            this.mdlDisableMoving = this.track(this.mdlDisableMoving, (UnpluggableValueModel)baseRecord3.numberFieldAsBoolean("TPSCtl", 4));
            this.mdlSimulate = this.track(this.mdlSimulate, (UnpluggableValueModel)baseRecord3.numberFieldAsBoolean("TPSCtl", 1));
        }
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        boolean bl;
        boolean bl2 = RecordSet.containsRecordId(4, map);
        boolean bl3 = RecordSet.containsRecordId(8, map);
        boolean bl4 = RecordSet.containsRecordId(11, map);
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        boolean bl5 = bl = baseRecord != null && baseRecord.hasFeature("shiftRPMCtl");
        return this.isV2RPM() ? bl3 && bl4 && bl : bl2;
    }

    public static boolean canDisplay(Map map) {
        boolean bl = RecordSet.containsRecordId(4, map);
        boolean bl2 = RecordSet.containsRecordId(8, map);
        boolean bl3 = RecordSet.containsRecordId(11, map);
        BaseRecord baseRecord = RecordSet.getRecord(ECMLinkRecordAdapter.MISC_BITS_RECORD_IDS, map);
        return bl || bl2 && bl3 && baseRecord != null && baseRecord.hasFeature("shiftRPMCtl");
    }
}

