/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.RPMTPSRecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public class RPMTPSRecordView
extends AbstractView {
    private JComboBox comboIdleRPM;
    private JComboBox comboLaunchRPM;
    private JComboBox comboRevRPM;
    private JCheckBox cbClutchCut;
    private JSpinner spnrCoastFC;
    private JSpinner spnrDisableSpd;
    private JLabel lblClutchRev;
    private JLabel lblClutchRevUnits;
    private JComboBox comboClutchRev;
    private JCheckBox cbEnableTPS;
    private JLabel lblTPSOff;
    private JLabel lblTPSScale;
    private JLabel lblTPSScaleUnits;
    private JSpinner spnrTPSOff;
    private JSpinner spnrTPSScale;
    private JCheckBox cbEnableIdleSw;
    private JCheckBox cbDisableMoving;
    private JCheckBox cbSimulate;
    private final RPMTPSRecordModel model;
    private static int[] idleRPMChoices = new int[]{750, 800, 850, 900, 950, 1000, 1050, 1100};
    private static int[] launchRPMChoices = new int[]{2000, 2500, 3000, 3500, 4000, 4500, 4750, 5000, 5250, 5500, 5750, 6000, 6250, 6500, 6750, 7000};
    private static int[] revRPMChoices = new int[]{3000, 3500, 4000, 7500, 7750, 8000, 8250, 8500, 8750, 9000, 9250, 9500, 9750, 10000};
    private static int[] clutchCutRPMChoices = new int[]{4000, 4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000};
    private static List idleRPMChoiceList = Arrays.asList(ListUtil.convertToIntegerArray(idleRPMChoices));
    private static List launchRPMChoiceList = Arrays.asList(ListUtil.convertToIntegerArray(launchRPMChoices));
    private static List revRPMChoiceList = Arrays.asList(ListUtil.convertToIntegerArray(revRPMChoices));
    private static List clutchCutRPMList = Arrays.asList(ListUtil.convertToIntegerArray(clutchCutRPMChoices));

    public RPMTPSRecordView(RPMTPSRecordModel rPMTPSRecordModel) {
        this.model = rPMTPSRecordModel;
    }

    public RPMTPSRecordModel getRecordModel() {
        return this.model;
    }

    private boolean isShowingTPS() {
        return this.model.isV2RPM();
    }

    private boolean isShowingRPMV2() {
        return this.model.isV2RPM();
    }

    private void initComponents() {
        this.comboIdleRPM = DialogUtil.createNearestNumberComboBox(idleRPMChoiceList, this.model.mdlIdleRPM, true, "Sets target base idle speed");
        this.comboLaunchRPM = DialogUtil.createNearestNumberComboBox(launchRPMChoiceList, this.model.mdlLaunchRPM, true, "Sets rev limit while speed is near zero");
        this.comboRevRPM = DialogUtil.createNearestNumberComboBox(revRPMChoiceList, this.model.mdlRevRPM, true, "Sets the upper rev limit");
        if (this.isShowingRPMV2()) {
            this.spnrCoastFC = DialogUtil.createSpinnerTextField(this.model.mdlCoastFC, "Adjusts the RPM point at which fuel will be re-enabled while coasting down");
            this.spnrDisableSpd = DialogUtil.createSpinnerTextField(this.model.mdlDisableSpd, "Defines the speed above which the launch rev limiter will no longer be used");
            this.cbClutchCut = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlClutchEnable, (String)"Enable clutch cut (No Lift To Shift)");
            this.cbClutchCut.setToolTipText("Enables use of clutch wire mod to control the rev limit while shifting");
            this.comboClutchRev = DialogUtil.createNearestNumberComboBox(clutchCutRPMList, this.model.mdlClutchRev, true, "Sets the rev limit when clutch is in and throttle is high");
            this.lblClutchRev = new JLabel("Clutch cut rev limit:");
            this.lblClutchRevUnits = new JLabel("rpm");
            DialogUtil.installComponentEnabler(this.model.mdlClutchEnable, new Component[]{this.comboClutchRev, this.lblClutchRev, this.lblClutchRevUnits});
        }
        if (this.isShowingTPS()) {
            this.cbEnableTPS = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnableTPS, (String)"Enable TPS adjustments");
            this.cbEnableTPS.setToolTipText("Enables adjustment to raw throttle position seen by ECU");
            this.spnrTPSOff = DialogUtil.createSpinnerTextField(this.model.mdlTPSOffset, "Value added to raw throttle position seen by the ECU");
            this.lblTPSOff = new JLabel("TPS Offset:");
            this.spnrTPSScale = DialogUtil.createSpinnerTextField(this.model.mdlTPSScale, "Scale to apply to raw throttle position after offset");
            this.lblTPSScale = new JLabel("TPS Scale:");
            this.lblTPSScaleUnits = new JLabel("%");
            this.cbEnableIdleSw = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnableIdleSw, (String)"Enable idle switch operation");
            this.cbEnableIdleSw.setToolTipText("Enables idle switch function inside ECU");
            this.cbDisableMoving = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlDisableMoving, (String)"Disable idle switch while moving");
            this.cbDisableMoving.setToolTipText("Disables idle switch function while car is moving");
            this.cbSimulate = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlSimulate, (String)"Simulate idle switch from TPS");
            this.cbSimulate.setToolTipText("Simulates idle switch behavior from throttle position");
            DialogUtil.installComponentEnabler(this.model.mdlEnableTPS, new Component[]{this.spnrTPSOff, this.lblTPSOff, this.lblTPSScale, this.spnrTPSScale, this.lblTPSScaleUnits});
            DialogUtil.installComponentEnabler(this.model.mdlEnableIdleSw, new Component[]{this.cbDisableMoving, this.cbSimulate});
        }
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.UNRELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        formLayout.setColumnGroups((int[][])new int[][]{{4, 10}});
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("RPM Controls", cellConstraints.xyw(1, n, 13));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "Target idle:", this.comboIdleRPM, "rpm", cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Launch limit:", this.comboLaunchRPM, "rpm", cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "Rev limit:", this.comboRevRPM, "rpm", cellConstraints.xy(2, n));
        if (this.isShowingRPMV2()) {
            n = 3;
            n = DialogUtil.addTriplet(panelBuilder, "Coasting FC offset:", this.spnrCoastFC, "rpm", cellConstraints.xy(8, n));
            n = DialogUtil.addTriplet(panelBuilder, "Disable launch at or above:", this.spnrDisableSpd, UnitsHelper.createJLabel("typeSpeedFromMPH"), cellConstraints.xy(8, n));
            panelBuilder.add((Component)this.cbClutchCut, cellConstraints.xyw(8, n, 5));
            n += 2;
            n = DialogUtil.addTriplet(panelBuilder, this.lblClutchRev, this.comboClutchRev, this.lblClutchRevUnits, cellConstraints.xy(8, n));
        }
        if (this.isShowingTPS()) {
            n = 11;
            panelBuilder.addSeparator("TPS and Idle Switch Controls", cellConstraints.xyw(1, n, 13));
            panelBuilder.add((Component)this.cbEnableTPS, cellConstraints.xyw(2, n += 2, 5));
            panelBuilder.add((Component)this.cbEnableIdleSw, cellConstraints.xyw(8, n, 5));
            panelBuilder.add((Component)this.lblTPSOff, cellConstraints.xy(2, n += 2));
            panelBuilder.add((Component)this.spnrTPSOff, cellConstraints.xy(4, n));
            panelBuilder.add((Component)this.cbDisableMoving, cellConstraints.xyw(8, n, 5));
            DialogUtil.addTriplet(panelBuilder, this.lblTPSScale, this.spnrTPSScale, this.lblTPSScaleUnits, cellConstraints.xy(2, n += 2));
            panelBuilder.add((Component)this.cbSimulate, cellConstraints.xyw(8, n, 5));
        }
        return panelBuilder.getPanel();
    }
}

