/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.UnpluggableCollection;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;

public abstract class RecordModel
extends UnpluggableCollection {
    public static final String PROPERTYNAME_DIRTY = "dirty";
    public static final String PROPERTYNAME_PERSISTED_VISIBLE_WITH_SAVED_DATA = "persistedVisibleWithSavedData";
    public static final String PROPERTYNAME_VALUE_CHANGED_BY_USER = "valueChangedByUser";
    public static final String PROPERTYNAME_VOLATILE_VALUE_CHANGED = "volatileValueChanged";
    public static final String PROPERTYNAME_AUTO_SAVE_ENABLED = "autoSaveEnabled";
    public static final String PROPERTYNAME_SHOW_AUTO_SAVE = "showAutoSave";
    private ValueModel[] volatileModelsArray;
    private ValueModel[] persistedModelsArray;
    Object[] savedVolatileValues = null;
    private boolean dirty;
    private boolean valueChangedByUser;
    private boolean volatileValueChanged;
    private boolean persistedVisibleWithSavedData = false;
    private boolean doingReset;
    private Boolean autoSaveEnabled = Boolean.FALSE;
    private Boolean showAutoSave = Boolean.FALSE;
    protected boolean doingPersistedCreate = false;
    protected boolean doingVolatileCreate = false;
    private ArrayList dirtyCheckVolatileModels = new ArrayList();
    boolean inSetDirty = false;
    boolean inSetPersistedVisible = false;
    protected PropertyChangeListener volatileChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (RecordModel.indexOf(RecordModel.this.volatileModelsArray, propertyChangeEvent.getSource()) == -1) {
                return;
            }
            boolean bl = RecordModel.this.checkAndSetDirty();
            if (!RecordModel.this.doingReset) {
                RecordModel.this.setValueChangedByUser(bl);
            }
            RecordModel.this.setVolatileValueChanged(false);
            RecordModel.this.setVolatileValueChanged(true);
        }
    };
    protected PropertyChangeListener persistedChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (RecordModel.indexOf(RecordModel.this.persistedModelsArray, propertyChangeEvent.getSource()) == -1) {
                return;
            }
            boolean bl = RecordModel.this.checkAndSetDirty();
            if (!bl && RecordModel.this.valueChangedByUser) {
                RecordModel.this.setValueChangedByUser(bl);
            }
        }
    };

    final void initialize(RecordSet recordSet) {
        this.doingPersistedCreate = true;
        try {
            this.persistedModelsArray = this.createModelsArray(recordSet.getPersistentRecordMap());
            RecordModel.addListener(this.persistedModelsArray, this.persistedChangeListener);
        }
        finally {
            this.doingPersistedCreate = false;
        }
        this.doingVolatileCreate = true;
        try {
            this.volatileModelsArray = this.createModelsArray(recordSet.getVolatileRecordMap());
            RecordModel.addListener(this.volatileModelsArray, this.volatileChangeListener);
        }
        finally {
            this.doingVolatileCreate = false;
        }
    }

    private ValueModel[] createModelsArray(Map map) {
        this.trackedModels.clear();
        this.initAndTrackModels(map);
        ValueModel[] valueModelArray = new ValueModel[this.trackedModels.size()];
        this.trackedModels.toArray(valueModelArray);
        this.trackedModels.clear();
        return valueModelArray;
    }

    public void deregisterModel() {
        RecordModel.removeListener(this.persistedModelsArray, this.persistedChangeListener);
        RecordModel.removeListener(this.volatileModelsArray, this.volatileChangeListener);
        RecordModel.deregisterModels(this.volatileModelsArray);
        RecordModel.deregisterModels(this.persistedModelsArray);
    }

    protected abstract void initAndTrackModels(Map var1);

    protected abstract boolean isCompatibleWith(Map var1);

    public Boolean getAutoSaveEnabled() {
        return this.autoSaveEnabled;
    }

    public void setAutoSaveEnabled(Boolean bl) {
        Boolean bl2 = this.autoSaveEnabled;
        this.autoSaveEnabled = bl;
        this.firePropertyChange(PROPERTYNAME_AUTO_SAVE_ENABLED, bl2, bl);
    }

    public Boolean getShowAutoSave() {
        return this.showAutoSave;
    }

    public void setShowAutoSave(Boolean bl) {
        Boolean bl2 = this.showAutoSave;
        this.showAutoSave = bl;
        this.firePropertyChange(PROPERTYNAME_SHOW_AUTO_SAVE, bl2, bl);
    }

    public boolean isVolatileValueChanged() {
        return this.volatileValueChanged;
    }

    protected void setVolatileValueChanged(boolean bl) {
        boolean bl2 = this.volatileValueChanged;
        this.volatileValueChanged = bl;
        this.firePropertyChange(PROPERTYNAME_VOLATILE_VALUE_CHANGED, bl2, bl);
    }

    public boolean getDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (this.getAutoSaveEnabled().booleanValue()) {
            this.firePropertyChange(PROPERTYNAME_DIRTY, null, bl);
        } else {
            this.firePropertyChange(PROPERTYNAME_DIRTY, bl2, bl);
        }
        RecordModel recordModel = this;
        synchronized (recordModel) {
            this.inSetDirty = true;
            try {
                this.setPersistedVisibleWithSavedData(!this.dirty);
            }
            finally {
                this.inSetDirty = false;
            }
        }
    }

    public boolean getPersistedVisibleWithSavedData() {
        return this.persistedVisibleWithSavedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistedVisibleWithSavedData(boolean bl) {
        RecordModel recordModel = this;
        synchronized (recordModel) {
            if (this.inSetPersistedVisible) {
                return;
            }
            this.inSetPersistedVisible = true;
            try {
                if (this.inSetDirty) {
                    if (this.savedVolatileValues == null) {
                        bl = false;
                    } else if (!bl) {
                        this.savedVolatileValues = null;
                    }
                } else if (bl != this.persistedVisibleWithSavedData) {
                    if (bl) {
                        this.savedVolatileValues = new Object[this.volatileModelsArray.length];
                        for (int i = 0; i < this.volatileModelsArray.length; ++i) {
                            this.savedVolatileValues[i] = this.volatileModelsArray[i].getValue();
                            if (!(this.savedVolatileValues[i] instanceof ArrayListModel)) continue;
                            this.savedVolatileValues[i] = ((ArrayListModel)this.savedVolatileValues[i]).clone();
                        }
                        this.reset();
                    } else if (this.savedVolatileValues != null) {
                        for (int i = 0; i < this.volatileModelsArray.length; ++i) {
                            this.volatileModelsArray[i].setValue(this.savedVolatileValues[i]);
                        }
                        this.savedVolatileValues = null;
                    }
                }
            }
            finally {
                this.inSetPersistedVisible = false;
            }
        }
        boolean bl2 = this.persistedVisibleWithSavedData;
        this.persistedVisibleWithSavedData = bl;
        this.firePropertyChange(PROPERTYNAME_PERSISTED_VISIBLE_WITH_SAVED_DATA, bl2, this.persistedVisibleWithSavedData);
    }

    public boolean hasSavedVolatileData() {
        return this.savedVolatileValues != null;
    }

    protected void setValueChangedByUser(boolean bl) {
        boolean bl2 = this.valueChangedByUser;
        this.valueChangedByUser = bl;
        if (this.getAutoSaveEnabled().booleanValue()) {
            this.firePropertyChange(PROPERTYNAME_VALUE_CHANGED_BY_USER, null, bl);
        } else {
            this.firePropertyChange(PROPERTYNAME_VALUE_CHANGED_BY_USER, bl2, bl);
        }
    }

    protected ValueModel track(ValueModel valueModel, UnpluggableValueModel unpluggableValueModel) {
        if (unpluggableValueModel == null) {
            return null;
        }
        if (!(unpluggableValueModel instanceof ValueModel)) {
            throw new IllegalArgumentException("Internal error: track() called with non-ValueModel instance");
        }
        return (ValueModel)this._track(valueModel, unpluggableValueModel, true);
    }

    protected ValueModel track(ValueModel valueModel, UnpluggableValueModel unpluggableValueModel, boolean bl) {
        if (unpluggableValueModel == null) {
            return null;
        }
        if (!(unpluggableValueModel instanceof ValueModel)) {
            throw new IllegalArgumentException("Internal error: track() called with non-ValueModel instance");
        }
        return (ValueModel)this._track(valueModel, unpluggableValueModel, bl);
    }

    private UnpluggableValueModel _track(ValueModel valueModel, UnpluggableValueModel unpluggableValueModel, boolean bl) {
        this.trackedModels.add(unpluggableValueModel);
        if (this.doingVolatileCreate) {
            if (bl) {
                this.dirtyCheckVolatileModels.add(unpluggableValueModel);
            }
            return unpluggableValueModel;
        }
        return (UnpluggableValueModel)valueModel;
    }

    protected ListModelPlug track(ListModelPlug listModelPlug, ListModelPlug listModelPlug2) {
        if (listModelPlug2 == null) {
            return null;
        }
        return (ListModelPlug)this._track(listModelPlug, listModelPlug2, true);
    }

    protected ListModelPlug track(ListModelPlug listModelPlug, ListModelPlug listModelPlug2, boolean bl) {
        if (listModelPlug2 == null) {
            return null;
        }
        return (ListModelPlug)this._track(listModelPlug, listModelPlug2, bl);
    }

    protected ValueModelPlug track(ValueModelPlug valueModelPlug, ValueModelPlug valueModelPlug2) {
        if (valueModelPlug2 == null) {
            return null;
        }
        return (ValueModelPlug)this._track(valueModelPlug, valueModelPlug2, true);
    }

    protected ValueModelPlug track(ValueModelPlug valueModelPlug, ValueModelPlug valueModelPlug2, boolean bl) {
        if (valueModelPlug2 == null) {
            return null;
        }
        return (ValueModelPlug)this._track(valueModelPlug, valueModelPlug2, bl);
    }

    public void applyVolatileModel(Map map) {
        ValueModel[] valueModelArray = this.createModelsArray(map);
        for (int i = 0; i < this.volatileModelsArray.length; ++i) {
            valueModelArray[i].setValue(this.volatileModelsArray[i].getValue());
        }
        RecordModel.deregisterModels(valueModelArray);
    }

    public synchronized void reset() {
        this.doingReset = true;
        for (int i = 0; i < this.volatileModelsArray.length; ++i) {
            this.volatileModelsArray[i].setValue(this.persistedModelsArray[i].getValue());
        }
        this.setValueChangedByUser(false);
        this.doingReset = false;
    }

    private static void addListener(ValueModel[] valueModelArray, PropertyChangeListener propertyChangeListener) {
        for (int i = 0; i < valueModelArray.length; ++i) {
            valueModelArray[i].addValueChangeListener(propertyChangeListener);
        }
    }

    private static void removeListener(ValueModel[] valueModelArray, PropertyChangeListener propertyChangeListener) {
        for (int i = 0; i < valueModelArray.length; ++i) {
            valueModelArray[i].removeValueChangeListener(propertyChangeListener);
        }
    }

    public boolean checkAndSetDirty() {
        boolean bl = false;
        int n = this.volatileModelsArray.length;
        if (this.persistedModelsArray.length == n) {
            bl = true;
            for (int i = 0; bl && i < n; ++i) {
                ValueModel valueModel = this.volatileModelsArray[i];
                if (!this.dirtyCheckVolatileModels.contains(valueModel)) continue;
                ValueModel valueModel2 = this.persistedModelsArray[i];
                if (valueModel != null ? valueModel.getValue().equals(valueModel2.getValue()) : valueModel2 == null) continue;
                bl = false;
            }
        }
        this.setDirty(!bl);
        return !bl;
    }

    protected void volatileValueChanged() {
    }
}

