/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetTab;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif.AbstractView;
import com.jgoodies.uif.component.UIFButton;
import com.jgoodies.uif.util.ResourceUtils;
import foxtrot.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Map;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class RecordSetSubTab
extends TrackedTabPanel {
    private RecordSet localRecordSet;
    private RecordSetTab parentTab;
    private RecordModel localRecordModel;
    protected AbstractView localView;
    protected boolean initialized;
    protected boolean built;
    static final Icon cleanIcon = ResourceUtils.getIcon((String)"tab.clean.icon");
    static final Icon dirtyIcon = ResourceUtils.getIcon((String)"tab.dirty.icon");
    AbstractAction resetAction;
    AbstractAction saveAction;
    private Task saveTabToECUTask = new Task(){

        public Object run() throws Exception {
            RecordSetSubTab.this.saveTabToECU();
            return null;
        }
    };
    private PropertyChangeListener dirtyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            RecordSetSubTab.this.setDirty(bl);
        }
    };

    public RecordSetSubTab(RecordSet recordSet, RecordSetTab recordSetTab) {
        this.localRecordSet = recordSet;
        this.parentTab = recordSetTab;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.built) {
            this.build();
        }
        super.setVisible(bl);
    }

    synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.localRecordModel = this.createLocalModel();
        this.initialized = true;
        this.localRecordModel.addPropertyChangeListener("dirty", this.dirtyListener);
        this.setTabName(this.getTabTitle());
        this.setToolTip(this.getTipText());
        this.setDirty(false);
        this.getSaveTabAction().setEnabled(false);
        this.getResetTabAction().setEnabled(false);
        this.localRecordModel.checkAndSetDirty();
    }

    final RecordSet getRecordSet() {
        return this.localRecordSet;
    }

    final RecordSetTab getParentTab() {
        return this.parentTab;
    }

    public AbstractView getNullableView() {
        return this.localView;
    }

    public AbstractView getBuiltView() {
        if (!this.built) {
            this.build();
        }
        return this.localView;
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
    }

    @Override
    public void tabShown() {
        super.tabShown();
        MainModel mainModel = MainModel.getInstance();
        HelpBroker helpBroker = mainModel.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpKey((Component)this, this.getTabHelpId(), null);
        }
    }

    public RecordModel getRecordModel() {
        this.initialize();
        return this.localRecordModel;
    }

    Icon getDirtyIcon() {
        return dirtyIcon;
    }

    Icon getCleanIcon() {
        return cleanIcon;
    }

    abstract RecordModel createLocalModel();

    abstract String getTabHelpId();

    abstract String getTabTitle();

    abstract String getTipText();

    abstract AbstractView createView(RecordModel var1);

    abstract Border getSubTabBorder();

    abstract void saveTabToECU() throws IOException, DeviceException;

    public boolean isCompatibleWith(Map map) {
        return this.getRecordModel().isCompatibleWith(map);
    }

    void setDirty(boolean bl) {
        this.setActionEnable(bl);
        this.setTabIcon(bl);
    }

    void setTabIcon(boolean bl) {
        this.setTabIcon(bl ? this.getDirtyIcon() : this.getCleanIcon());
    }

    void setActionEnable(boolean bl) {
        this.getSaveTabAction().setEnabled(bl |= !this.getParentTab().isLiveView());
        this.getResetTabAction().setEnabled(bl);
    }

    void deregisterTab() {
        this.resetTab();
        RecordModel recordModel = this.getRecordModel();
        recordModel.removePropertyChangeListener("dirty", this.dirtyListener);
        recordModel.deregisterModel();
        this.parentTab = null;
        this.localRecordModel = null;
        this.localRecordSet = null;
        this.removeAll();
    }

    void setLiveView(boolean bl) {
        boolean bl2 = this.getRecordModel() == null ? false : this.getRecordModel().getDirty();
        this.setActionEnable(bl2);
        if (!bl) {
            RecordModel recordModel = this.getRecordModel();
            recordModel.setAutoSaveEnabled(Boolean.FALSE);
            recordModel.setShowAutoSave(Boolean.FALSE);
            this.parentTab.configureAction(this.getSaveTabAction(), "copyRecord");
        }
    }

    public void applyVolatileModel(Map map) {
        this.getRecordModel().applyVolatileModel(map);
    }

    synchronized void build() {
        if (this.built) {
            return;
        }
        this.built = true;
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(this.getSubTabBorder());
        this.localView = this.createView(this.getRecordModel());
        this.add((Component)this.localView.getPanel(), "Center");
        this.add((Component)this.buildButtonBar(), "South");
    }

    JPanel buildButtonBar() {
        JButton jButton = DialogUtil.createDefaultHelpButton(this.getTabHelpId());
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGriddedButtons(new JButton[]{this.createSaveAllButton(), this.createResetAllButton()});
        buttonBarBuilder.addGlue();
        JComponent jComponent = this.getCustomButtonBarComponent();
        if (jComponent != null) {
            buttonBarBuilder.addFixed(jComponent);
            buttonBarBuilder.addUnrelatedGap();
        }
        buttonBarBuilder.addGriddedButtons(new JButton[]{this.createSaveButton(), this.createResetButton()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)jButton);
        JPanel jPanel = buttonBarBuilder.getPanel();
        jPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        return jPanel;
    }

    abstract JComponent getCustomButtonBarComponent();

    JButton createSaveAllButton() {
        return new UIFButton(this.parentTab.getSaveAllAction());
    }

    JButton createResetAllButton() {
        return new UIFButton(this.parentTab.getResetAllAction());
    }

    JButton createSaveButton() {
        return new UIFButton(this.getSaveTabAction());
    }

    JButton createResetButton() {
        return new UIFButton(this.getResetTabAction());
    }

    void resetTab() {
        this.getRecordModel().reset();
    }

    Action getResetTabAction() {
        if (this.resetAction == null) {
            this.resetAction = new DispatchingAction("resetRecord");
            this.parentTab.configureAction(this.resetAction, "resetRecord");
        }
        return this.resetAction;
    }

    Action getSaveTabAction() {
        if (this.saveAction == null) {
            this.saveAction = new DispatchingAction("saveRecord");
            this.parentTab.configureAction(this.saveAction, "saveRecord");
        }
        return this.saveAction;
    }

    private final class DispatchingAction
    extends AbstractAction {
        private final String id;

        private DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id.equals("saveRecord")) {
                MainActions.handleMainFrameTask(RecordSetSubTab.this.saveTabToECUTask, true);
            } else if (this.id.equals("resetRecord")) {
                RecordSetSubTab.this.resetTab();
            } else {
                throw new IllegalStateException("Unknown action name" + this.id);
            }
        }
    }
}

