/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSetFile;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetSubTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.tabs.MainTabPanel;
import com.jgoodies.uif.lazy.BackgroundLoader;
import com.jgoodies.uif.lazy.Preparable;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public abstract class RecordSetTab
extends MainTabPanel {
    private final RecordSet managedRecordSet;
    private RecordSetFile lastSavedRecordSetFile;
    private final DatalogFile parentDatalogFile;
    private final DatalogTab parentDatalogTab;
    private RecordSetSubTab[] subTabs;
    private boolean liveViewInd;
    String oldOpenPropName;
    private AbstractAction doSaveAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(RecordSetTab.this.saveSettingsTask, false);
        }
    };
    private AbstractAction doSaveAsAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(RecordSetTab.this.saveAsSettingsTask, false);
        }
    };
    private Task saveSettingsTask = new Task(){

        public Object run() throws Exception {
            if (RecordSetTab.this.getLastSavedRecordSetFile() == null) {
                RecordSetTab.this.saveAsSettingsTask.run();
            } else {
                RecordSetTab.this.getLastSavedRecordSetFile().save();
                if (!RecordSetTab.this.isLiveView()) {
                    RecordSetTab.this.getManagedRecordSet().copyVolatileToPersistent();
                }
            }
            return null;
        }
    };
    Task saveAsSettingsTask = new Task(){

        public Object run() throws Exception {
            MainModel mainModel = MainModel.getInstance();
            FilenameModel filenameModel = mainModel.getFilenameModel();
            File file = RecordSetTab.this.createDefaultFile(filenameModel);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(file);
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.addChoosableFileFilter(RecordSetTab.this.getRecordSetFileFilter());
            jFileChooser.setDialogTitle("Save Device Data");
            File file2 = DialogUtil.invokeSaveAsChooser(jFileChooser, RecordSetTab.this, RecordSetTab.this.getFileExtension());
            if (file2 != null) {
                if (RecordSetTab.this.lastSavedRecordSetFile == null) {
                    RecordSetTab.this.setLastSavedRecordSetFile(RecordSetTab.this.createRecordSetFile(file2));
                }
                RecordSetTab.this.lastSavedRecordSetFile.saveAs(file2);
                if (!RecordSetTab.this.isLiveView()) {
                    RecordSetTab.this.managedRecordSet.copyVolatileToPersistent();
                }
                filenameModel.setLastDeviceSettingsDirectory(file.getParent());
            }
            return null;
        }
    };
    AbstractAction resetAllAction;
    AbstractAction saveAllAction;
    private Task saveAllToECUTask = new Task(){

        public Object run() throws Exception {
            RecordSetTab.this.saveAllRecordsToECU();
            return null;
        }
    };

    public RecordSetTab(RecordSet recordSet, DatalogFile datalogFile) {
        this.managedRecordSet = recordSet;
        this.parentDatalogFile = datalogFile;
        if (datalogFile == null) {
            this.parentDatalogTab = DatalogTab.getOrCreateLiveTab();
        } else {
            Iterator iterator = MainModel.getInstance().getTabPanelArrayList().iterator();
            DatalogTab datalogTab = null;
            while (iterator.hasNext()) {
                DatalogTab datalogTab2;
                Object e = iterator.next();
                if (!(e instanceof DatalogTab) || (datalogTab2 = (DatalogTab)e).getLastSavedDatalog() != datalogFile) continue;
                datalogTab = datalogTab2;
            }
            this.parentDatalogTab = datalogTab;
        }
    }

    public RecordSetTab(RecordSetFile recordSetFile) {
        this.lastSavedRecordSetFile = recordSetFile;
        this.parentDatalogFile = null;
        this.parentDatalogTab = null;
        this.managedRecordSet = recordSetFile.getRecordSet();
    }

    public RecordSetTab(RecordSet recordSet) {
        this.lastSavedRecordSetFile = null;
        this.parentDatalogFile = null;
        this.parentDatalogTab = null;
        this.managedRecordSet = recordSet;
    }

    protected void initialize(boolean bl) {
        this.subTabs = this.build();
        BackgroundLoader backgroundLoader = new BackgroundLoader();
        for (int i = 0; i < this.subTabs.length; ++i) {
            backgroundLoader.add((Preparable)new SubTabBuilder(this.subTabs[i]));
        }
        backgroundLoader.start();
        this.setLiveView(bl);
    }

    abstract String getResourcePrefix();

    protected abstract RecordSetSubTab[] build();

    protected abstract File createDefaultFile(FilenameModel var1);

    protected abstract FileFilter getRecordSetFileFilter();

    protected abstract String getFileExtension();

    abstract void saveAllRecordsToECU() throws IOException, DeviceException;

    protected abstract RecordSetFile createRecordSetFile(File var1);

    protected void setLiveViewNameAndTipText() {
        this.setTabName(ECMLinkResources.getString(this.getResourcePrefix(), "liveTitle"));
        this.setToolTip(ECMLinkResources.getString(this.getResourcePrefix(), "liveToolTip"));
    }

    protected void resetAllRecords() {
        for (int i = 0; i < this.subTabs.length; ++i) {
            this.subTabs[i].resetTab();
        }
    }

    public DatalogFile getParentDatalogFile() {
        return this.parentDatalogFile;
    }

    public DatalogTab getParentDatalogTab() {
        return this.parentDatalogTab;
    }

    private void assignNameAndTipText(boolean bl) {
        if (this.isLiveView()) {
            this.setLiveViewNameAndTipText();
        } else {
            Object object;
            if (this.getLastSavedRecordSetFile() == null && (bl || this.getLastSavedRecordSetFile() == null && this.parentDatalogFile == null)) {
                object = MainModel.getInstance();
                FilenameModel filenameModel = ((MainModel)((Object)object)).getFilenameModel();
                File file = this.createDefaultFile(filenameModel);
                this.setLastSavedRecordSetFile(this.createRecordSetFile(file));
            }
            if (this.getLastSavedRecordSetFile() != null) {
                object = this.getLastSavedRecordSetFile();
                this.setTabName(XFormatter.clipAndPrefixWithEllipses(FilenameModel.getFilenameNoExt(((RecordSetFile)object).getSaveFile()), 25));
                this.setToolTip(((RecordSetFile)object).getSaveFile().getAbsolutePath());
            } else {
                this.setTabName(XFormatter.clipAndPrefixWithEllipses(FilenameModel.getFilenameNoExt(this.parentDatalogFile.getSaveFile()) + "(*)", 25));
                this.setToolTip("Data saved with datalog named " + this.parentDatalogFile.getSaveFile().getName());
            }
        }
    }

    @Override
    public void tabShown() {
        super.tabShown();
        MainActions mainActions = MainModel.getInstance().getMainActions();
        this.oldOpenPropName = mainActions.setOpenDirectoryPropName("userDeviceSettingsDirectory");
        mainActions.installActionHook("saveFile", this.doSaveAction, "Saves settings data to disk");
        mainActions.installActionHook("saveFileAs", this.doSaveAsAction, "Saves settings data to disk as new file");
        mainActions.installActionHook("closeFile", MainActions.CLOSE_TAB_ACTION, "Close current tab");
    }

    @Override
    public void tabHidden() {
        super.tabHidden();
        MainActions mainActions = MainModel.getInstance().getMainActions();
        mainActions.setOpenDirectoryPropName(this.oldOpenPropName);
        mainActions.uninstallActionHook("saveFile");
        mainActions.uninstallActionHook("saveFileAs");
        mainActions.uninstallActionHook("closeFile");
    }

    @Override
    protected void tabRemoved() {
        super.tabRemoved();
        for (int i = 0; i < this.subTabs.length; ++i) {
            this.subTabs[i].deregisterTab();
        }
    }

    public boolean isLiveView() {
        return this.liveViewInd;
    }

    public void setLiveView(boolean bl) {
        boolean bl2 = this.liveViewInd & this.liveViewInd != bl;
        this.liveViewInd = bl;
        this.assignNameAndTipText(bl2);
        if (!this.liveViewInd) {
            this.configureAction(this.getSaveAllAction(), "copyAllRecords");
        }
        for (int i = 0; i < this.subTabs.length; ++i) {
            this.subTabs[i].setLiveView(bl);
        }
    }

    protected RecordSetFile getLastSavedRecordSetFile() {
        return this.lastSavedRecordSetFile;
    }

    protected void setLastSavedRecordSetFile(RecordSetFile recordSetFile) {
        this.lastSavedRecordSetFile = recordSetFile;
    }

    protected RecordSet getManagedRecordSet() {
        return this.managedRecordSet;
    }

    protected RecordSetSubTab[] getSubTabs() {
        return this.subTabs;
    }

    Action getResetAllAction() {
        if (this.resetAllAction == null) {
            this.resetAllAction = new DispatchingAction("resetAllRecords");
            this.configureAction(this.resetAllAction, "resetAllRecords");
        }
        return this.resetAllAction;
    }

    Action getSaveAllAction() {
        if (this.saveAllAction == null) {
            this.saveAllAction = new DispatchingAction("saveAllRecords");
            this.configureAction(this.saveAllAction, "saveAllRecords");
        }
        return this.saveAllAction;
    }

    void configureAction(Action action, String string) {
        ECMLinkResources.configureAction(action, this.getResourcePrefix() + "." + string);
    }

    private final class DispatchingAction
    extends AbstractAction {
        private final String id;

        private DispatchingAction(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.id.equals("saveAllRecords")) {
                MainActions.handleMainFrameTask(RecordSetTab.this.saveAllToECUTask, true);
            } else if (this.id.equals("resetAllRecords")) {
                RecordSetTab.this.resetAllRecords();
            } else {
                throw new IllegalStateException("Unknown action name" + this.id);
            }
        }
    }

    class SubTabBuilder
    implements Runnable,
    Preparable {
        final RecordSetSubTab subTab;

        public SubTabBuilder(RecordSetSubTab recordSetSubTab) {
            this.subTab = recordSetSubTab;
        }

        @Override
        public void run() {
            if (!TrackedTabPanel.STATE_TAB_REMOVED.equals(RecordSetTab.this.getState())) {
                this.subTab.build();
            }
        }

        public void prepare() {
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to initialize sub tab", exception);
            }
        }
    }
}

