/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SDRecordModel
extends RecordModel {
    ValueModelPlug mdlDisplacement;
    ListModelPlug mdlVETable;
    public List volatileVETableList;
    public List persistedVETableList;
    public ValueModel mdlPersistedMAPInputX;
    public ValueModel mdlPersistedMAPSelect;
    public ValueModel persistedDisplacement;
    ValueModel mdlPersistedBaseMaf;
    ValueModel mdlSDEnable;
    public boolean isV1SD;
    public boolean isV2SD;
    public boolean isV3SD;
    static int[] supportedV1MiscBitsRecordIds = new int[]{40, 41, 44};
    static int[] mafCompRecordIdsWithBaseMAF = new int[]{38, 49};
    static int[] supportedSDRecordIds = new int[]{42, 47, 48};

    SDRecordModel(RecordSet recordSet) {
        BaseRecord baseRecord;
        Map map = recordSet.getPersistentRecordMap();
        this.isV1SD = RecordSet.containsRecordId(42, map);
        this.isV2SD = RecordSet.containsRecordId(47, map);
        this.isV3SD = RecordSet.containsRecordId(48, map);
        this.initialize(recordSet);
        if (this.isV1SD) {
            baseRecord = RecordSet.getRecord(supportedV1MiscBitsRecordIds, map);
            this.mdlPersistedMAPInputX = baseRecord.getFeaturePlug("mapInputX");
            this.mdlPersistedMAPSelect = baseRecord.getFeaturePlug("mapSelectFeature");
        } else if (this.isV2SD || this.isV3SD) {
            baseRecord = RecordSet.getRecord(44, map);
            this.mdlPersistedMAPInputX = baseRecord.getFeaturePlug("mapInputX");
            this.mdlPersistedMAPSelect = baseRecord.getFeaturePlug("mapSelectFeature");
        }
        baseRecord = RecordSet.getRecord(mafCompRecordIdsWithBaseMAF, map);
        if (baseRecord != null) {
            this.mdlPersistedBaseMaf = baseRecord.numberFieldAsInteger("BaseMAFSelect");
        }
        BaseRecord baseRecord2 = RecordSet.getRecord(this.getSDRecordId(), map);
        this.persistedVETableList = (ArrayList)baseRecord2.numberListField("SDVETable").getValue();
        this.volatileVETableList = this.mdlVETable.getLocalArrayListValue();
        this.persistedDisplacement = baseRecord2.getField("DisplacementAdj");
    }

    @Override
    public void deregisterModel() {
        super.deregisterModel();
        if (this.mdlPersistedBaseMaf != null) {
            ((ValueModelPlug)this.mdlPersistedBaseMaf).unplug();
        }
        ((ValueModelPlug)this.mdlPersistedMAPInputX).unplug();
        ((ValueModelPlug)this.mdlPersistedMAPSelect).unplug();
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(this.getSDRecordId(), map);
        this.mdlDisplacement = this.track(this.mdlDisplacement, baseRecord.numberFieldAsString("DisplacementAdj", 1));
        this.mdlVETable = this.track(this.mdlVETable, baseRecord.numberListField("SDVETable"));
        if (this.isV2SD) {
            this.mdlSDEnable = this.track(this.mdlSDEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("SDCtl", 128));
        }
    }

    public static boolean canDisplay(Map map) {
        if (RecordSet.containsRecordId(42, map)) {
            return RecordSet.containsAnyRecordId(supportedV1MiscBitsRecordIds, map) && RecordSet.containsRecordId(38, map);
        }
        if (RecordSet.containsRecordId(47, map)) {
            return RecordSet.containsRecordId(44, map);
        }
        if (RecordSet.containsRecordId(48, map)) {
            return RecordSet.containsRecordId(44, map) && RecordSet.containsRecordId(49, map);
        }
        return false;
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return RecordSet.containsRecordId(this.getSDRecordId(), map);
    }

    private int getSDRecordId() {
        return this.isV1SD ? 42 : (this.isV2SD ? 47 : 48);
    }
}

