/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.LocationTOC;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV3Record;
import com.ecmtuning.ecmlink.device.records.ColorMapEntry;
import com.ecmtuning.ecmlink.gui.chart.TblBuilder;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.InterpTableValuesAction;
import com.ecmtuning.ecmlink.util.ui.ScaleTableValuesAction;
import com.ecmtuning.ecmlink.util.ui.SetTableValuesAction;
import com.ecmtuning.ecmlink.view.ecmlink.AbstractRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.DetachedTableDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.ECUIOTab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3Tab;
import com.ecmtuning.ecmlink.view.ecmlink.NumberStringCellRenderer;
import com.ecmtuning.ecmlink.view.ecmlink.SDRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SDTab;
import com.ecmtuning.ecmlink.view.ecmlink.SDTableAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.ecmlink.TableSelectionDataAdapter;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uifextras.util.ActionLabel;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;

public class SDRecordView
extends AbstractRecordView {
    private JSpinner spnrDisplacement;
    private JLabel lblDisp;
    private JLabel lblDispUnits;
    private JToggleButton btnDetach;
    private JToggleButton btnTrack;
    ActionLabel inputsTabActionLabel;
    ActionLabel mafTabActionLabel;
    JCheckBox cbSDEnable;
    private final SDRecordModel model;
    private final SettingsTab parentTab;
    private final SDTab parentSubTab;
    private SDTableAdapter tableAdapter;
    TblBuilder tblBuilder;
    private JScrollPane veTablePane;
    private CellConstraints veTablePaneCC;
    ValueHolder mdlDetached = new ValueHolder(false);
    ToggleAction actionDetach;
    DetachedTableDialog detachedDialog;
    PropertyAdapter detachedNameAdapter = new PropertyAdapter(null, "tabName", true);
    ValueHolder mdlTrackData = new ValueHolder(false);
    ToggleAction trackDataAction;
    TableSelectionDataAdapter tableSelectionAdapter;
    ColorMapEntry[] veColorMap = new ColorMapEntry[]{new ColorMapEntry(50.0f, 61680), new ColorMapEntry(62.0f, 38894), new ColorMapEntry(75.0f, 65280), new ColorMapEntry(82.0f, 0xFFFA88), new ColorMapEntry(89.0f, 0xFFFA00), new ColorMapEntry(95.0f, 16762880), new ColorMapEntry(115.0f, 0xFF0000)};
    ValueHolder enabledHolder = new ValueHolder(false);

    public SDRecordView(SDRecordModel sDRecordModel, SettingsTab settingsTab, SDTab sDTab) {
        this.model = sDRecordModel;
        this.parentTab = settingsTab;
        this.parentSubTab = sDTab;
    }

    public Component getDefaultFocusComponent() {
        return this.tblBuilder.getDataTable();
    }

    private void initComponents() {
        EventListener eventListener;
        this.tableAdapter = new SDTableAdapter(this.model);
        this.tblBuilder = new TblBuilder(this.tableAdapter);
        this.tableAdapter.createTableActions(this.tblBuilder);
        this.initTable();
        this.lblDisp = new JLabel("Engine displacement:");
        this.lblDispUnits = new JLabel("L");
        this.spnrDisplacement = DialogUtil.createSpinnerTextField(this.model.mdlDisplacement, "Engine displacement, in liters");
        Action action = this.parentTab.createTabAction(ECUIOTab.class);
        this.inputsTabActionLabel = new ActionLabel(action);
        if (this.model.mdlPersistedBaseMaf != null) {
            eventListener = this.parentTab.createTabAction(MAFV3Tab.class);
            this.mafTabActionLabel = new ActionLabel(eventListener);
        } else {
            this.cbSDEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlSDEnable, (String)"Enable Speed Density");
            this.cbSDEnable.setToolTipText("Must be checked in order to enable SD operation");
        }
        eventListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SDRecordView.this.updateEnabledValue();
            }
        };
        this.model.mdlPersistedMAPInputX.addValueChangeListener((PropertyChangeListener)eventListener);
        this.model.mdlPersistedMAPSelect.addValueChangeListener((PropertyChangeListener)eventListener);
        if (this.model.mdlPersistedBaseMaf != null) {
            this.model.mdlPersistedBaseMaf.addValueChangeListener((PropertyChangeListener)eventListener);
        }
        this.updateEnabledValue();
        this.btnDetach = BasicComponentFactory.createToggleButton((ValueModel)this.mdlDetached, (String)"Detach");
        this.btnDetach.setAction((Action)this.getDetachedToggleAction());
        this.btnDetach.setIcon(null);
        this.btnTrack = BasicComponentFactory.createToggleButton((ValueModel)this.mdlTrackData, (String)"Track");
        this.btnTrack.setAction((Action)this.getTrackDataToggleAction());
    }

    private void initTable() {
        HandyJTable handyJTable = this.tblBuilder.getDataTable();
        this.tableSelectionAdapter = new TableSelectionDataAdapter((JTable)((Object)handyJTable), SDTableAdapter.getRPMIndices(this.model), SDTableAdapter.getPsiaIndices(this.model));
        this.tblBuilder.addDefaultValueChangeActions((JComponent)((Object)handyJTable), true);
        TableCellRenderer tableCellRenderer = handyJTable.getDefaultRenderer(String.class);
        NumberStringCellRenderer numberStringCellRenderer = new NumberStringCellRenderer(tableCellRenderer, this.veColorMap, this.model.volatileVETableList, this.model.persistedVETableList, SDTableAdapter.getRPMIndices(this.model).length);
        handyJTable.setDefaultRenderer(String.class, numberStringCellRenderer);
        this.tableAdapter.addPopupAction(this.parentSubTab.getResetTabAction());
        this.tableAdapter.addPopupAction(this.parentSubTab.getSaveTabAction());
        this.tableAdapter.addPopupAction(null);
        AbstractAction abstractAction = new InterpTableValuesAction(handyJTable, SDTableAdapter.getRPMIndices(this.model), SDTableAdapter.getPsiaIndices(this.model), true, true);
        ECMLinkResources.configureAction(abstractAction, "interpTableValues");
        this.tableAdapter.addPopupAction(abstractAction);
        abstractAction = new InterpTableValuesAction(handyJTable, SDTableAdapter.getRPMIndices(this.model), SDTableAdapter.getPsiaIndices(this.model), true, false);
        ECMLinkResources.configureAction(abstractAction, "interpTableRows");
        this.tableAdapter.addPopupAction(abstractAction);
        abstractAction = new InterpTableValuesAction(handyJTable, SDTableAdapter.getRPMIndices(this.model), SDTableAdapter.getPsiaIndices(this.model), false, true);
        ECMLinkResources.configureAction(abstractAction, "interpTableColumns");
        this.tableAdapter.addPopupAction(abstractAction);
        abstractAction = new SetTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "setTableValues");
        this.tableAdapter.addPopupAction(abstractAction);
        abstractAction = new ScaleTableValuesAction((JTable)((Object)handyJTable));
        ECMLinkResources.configureAction(abstractAction, "scaleTableValues");
        this.tableAdapter.addPopupAction(abstractAction);
        this.tableAdapter.addPopupAction(null);
        this.tableAdapter.addPopupAction((Action)this.getDetachedToggleAction());
        this.tableAdapter.addPopupAction((Action)this.getTrackDataToggleAction());
        handyJTable.addMouseListener(this.tableAdapter.getPopupListener());
    }

    public void setDetached(boolean bl) {
        this.mdlDetached.setValue(bl);
    }

    public boolean isDetached() {
        return this.mdlDetached.booleanValue();
    }

    ToggleAction getDetachedToggleAction() {
        if (this.actionDetach == null) {
            this.actionDetach = ToggleAction.createCheck((ValueModel)this.mdlDetached);
            ECMLinkResources.configureAction((Action)this.actionDetach, "detach");
            this.mdlDetached.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SDRecordView.this.handleDetachedChange();
                }
            });
        }
        return this.actionDetach;
    }

    protected synchronized void handleDetachedChange() {
        if (this.isDetached()) {
            if (this.detachedDialog == null) {
                this.detachedNameAdapter.setBean((Object)this.parentTab);
                this.getPanel().remove(this.veTablePane);
                this.getPanel().revalidate();
                this.getPanel().repaint();
                this.detachedDialog = DetachedTableDialog.createPopoutDialog(Application.getDefaultParentFrame());
                this.detachedDialog.setPopoutControls((ValueModel)this.detachedNameAdapter, "Speed Density VE Table", (ValueModel)this.mdlDetached, this.veTablePane);
                this.detachedDialog.open();
            }
        } else if (this.detachedDialog != null) {
            this.detachedNameAdapter.setBean(null);
            this.detachedDialog.reallyClose();
            this.detachedDialog = null;
            this.getPanel().add((Component)this.veTablePane, this.veTablePaneCC);
            this.getPanel().revalidate();
            this.getPanel().repaint();
        }
    }

    public void setTrackData(boolean bl) {
        this.mdlTrackData.setValue(bl);
    }

    public boolean isTrackData() {
        return this.mdlTrackData.booleanValue();
    }

    ToggleAction getTrackDataToggleAction() {
        if (this.trackDataAction == null) {
            this.trackDataAction = ToggleAction.createCheck((ValueModel)this.mdlTrackData);
            ECMLinkResources.configureAction((Action)this.trackDataAction, "trackData");
            this.mdlTrackData.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SDRecordView.this.handleTrackDataChange();
                }
            });
        }
        return this.trackDataAction;
    }

    protected synchronized void handleTrackDataChange() {
        if (this.isTrackData()) {
            this.reconnectTracking(true);
        } else {
            this.tableSelectionAdapter.deregisterModels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void reconnectTracking(boolean bl) {
        Object object;
        LocationTOC locationTOC;
        Dataset dataset;
        DatalogTab datalogTab;
        String string;
        boolean bl2;
        block28: {
            block27: {
                bl2 = false;
                int n = ((Number)this.model.mdlPersistedMAPInputX.getValue()).intValue();
                if (n == 0) {
                    if (bl) {
                        MainModel.showErrorMessage("Input pin for MAP sensor has not been assigned.", "Error");
                    }
                    if (bl2) return;
                    this.setTrackData(false);
                    return;
                }
                string = MiscBitsV3Record.INPUT_X_TO_LOCNAME[n];
                if (string == null) {
                    if (bl) {
                        MainModel.showErrorMessage("Invalid input pin selected for MAP sensor.", "Error");
                    }
                    if (bl2) return;
                    this.setTrackData(false);
                    return;
                }
                datalogTab = this.parentTab.getParentDatalogTab();
                if (datalogTab != null) break block27;
                if (bl) {
                    MainModel.showErrorMessage("Can't find associated datalog tab.", "Error");
                }
                if (bl2) return;
                this.setTrackData(false);
                return;
            }
            Dataset dataset2 = dataset = datalogTab.getDataset();
            // MONITORENTER : dataset2
            locationTOC = dataset.getMainDataTOC();
            if (locationTOC != null) break block28;
            if (bl) {
                MainModel.showErrorMessage("No active datalog found.  You must start a datalog first.", "Error");
            }
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        List list = DisplayChain.generateDisplayChains(locationTOC, false);
        DisplayChain displayChain = DisplayChain.findChainByOutputType(list, "data.sys.rpm");
        if (displayChain == null) {
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        List list2 = DisplayChain.findChainsByOutputType(list, "data.sys.airpsia");
        Object object2 = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext() && object2 == null) {
            object = (DisplayChain)iterator.next();
            if (!((DisplayChain)object).usesAssignedLocationName(string)) continue;
            object2 = object;
        }
        if (object2 == null) {
            if (bl) {
                MainModel.showErrorMessage("Can not find log item for MAP sensor in log file.", "Error");
            }
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        object = new DisplaySet();
        try {
            ((DisplaySet)object).registerModels(dataset, datalogTab.getConverterPrefs());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(displayChain);
            arrayList.add(object2);
            ((DisplaySet)object).setDisplayChains(arrayList);
        }
        catch (Exception exception) {
            if (bl) {
                MainModel.showErrorMessage("Internal error: " + exception.getMessage(), "Error");
            }
            ((DisplaySet)object).deregisterModels();
            // MONITOREXIT : dataset2
            if (bl2) return;
            this.setTrackData(false);
            return;
        }
        try {
            this.tableSelectionAdapter.registerModels((DisplaySet)object, datalogTab.getTextDisplayTimeModel());
            bl2 = true;
            // MONITOREXIT : dataset2
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (!bl2) {
                this.setTrackData(false);
            }
        }
    }

    void updateEnabledValue() {
        boolean bl = !this.model.isV2SD;
        boolean bl2 = !bl || ((Number)this.model.mdlPersistedBaseMaf.getValue()).intValue() == 6;
        boolean bl3 = ((Number)this.model.mdlPersistedMAPInputX.getValue()).intValue() != 0;
        boolean bl4 = ((Number)this.model.mdlPersistedMAPSelect.getValue()).intValue() != 0;
        boolean bl5 = (!bl || bl2) && bl3 && bl4;
        this.enabledHolder.setValue(bl5);
        if (!bl3 || !bl4) {
            this.inputsTabActionLabel.setForeground(Color.RED);
            String string = "";
            string = !bl3 && !bl4 ? "input pin & type" : (!bl3 ? "input pin" : "sensor type");
            this.inputsTabActionLabel.setText("Assign MAP " + string + "\u2026");
        } else {
            this.inputsTabActionLabel.setForeground(Color.BLUE);
            this.inputsTabActionLabel.setText("Edit MAP input pin & type\u2026");
        }
        if (bl) {
            if (!bl2) {
                this.mafTabActionLabel.setForeground(Color.RED);
                this.mafTabActionLabel.setText("Set BaseMAF type to Speed Density\u2026");
            } else {
                this.mafTabActionLabel.setForeground(Color.BLUE);
                this.mafTabActionLabel.setText("Edit MAF Comp\u2026");
            }
        } else {
            boolean bl6 = bl3 && bl4;
            this.cbSDEnable.setEnabled(bl6);
        }
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.RELATED_COLUMN_GAP_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.FILL_PREF_NOGROW_COLSPEC);
        ArrayList arrayList2 = new ArrayList();
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        formLayout.setColumnGroups((int[][])new int[][]{{12, 13}});
        panelBuilder.appendRows(prefRowSpec, postSepGap);
        panelBuilder.setColumn(1);
        panelBuilder.addSeparator("Speed Density Configuration");
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(prefRowSpec, interCompGap);
        panelBuilder.add((Component)this.lblDisp);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.spnrDisplacement);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.lblDispUnits);
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.inputsTabActionLabel);
        panelBuilder.nextColumn(2);
        if (!this.model.isV2SD) {
            panelBuilder.add((Component)this.mafTabActionLabel);
        } else {
            panelBuilder.add((Component)this.cbSDEnable);
        }
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.btnDetach, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 1, CellConstraints.FILL, CellConstraints.FILL));
        panelBuilder.nextColumn();
        panelBuilder.add((Component)this.btnTrack, cellConstraints.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), 1, CellConstraints.FILL, CellConstraints.FILL));
        panelBuilder.nextLine(2, 2);
        panelBuilder.appendRows(DialogUtil.FILL_DEFAULT_GROW_ROWSPEC, interCompGap);
        this.veTablePane = this.tblBuilder.getDataTableWithScrollPane();
        this.veTablePaneCC = new CellConstraints();
        this.veTablePaneCC.xyw(panelBuilder.getColumn(), panelBuilder.getRow(), panelBuilder.getColumnCount() - 1);
        panelBuilder.add((Component)this.veTablePane, this.veTablePaneCC);
        panelBuilder.nextLine(2, 2);
        return panelBuilder.getPanel();
    }
}

